package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 施工机械结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_settlement")
public class RentMachineSettlementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="is_contract")
    private String isContract; // 是否有合同
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编号
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编号
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商ID
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="settlement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate; // 结算日期
    @TableField(value="settlement_amount")
    private BigDecimal settlementAmount; // 结算金额
    @TableField(value="settlement_no_tax_amount")
    private BigDecimal settlementNoTaxAmount; // 无税金额
    @TableField(value="settlement_tax_amount")
    private BigDecimal settlementTaxAmount; // 税额
    @TableField(value = "pay_type")
    private String payType;
    /**
     * 推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "push_pool_flag")
    private String pushPoolFlag;

    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    @TableField(value = "settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称

    
    @TableField(exist=false)
    @SubEntity(serviceName="rentMachineSettlementContentService",pidName = "settlementId")
    private List<RentMachineSettlementContentEntity> rentMachineSettlementContentList = new ArrayList<>(); // 施工机械结算子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getIsContract() {
        return isContract;
    }

    public void setIsContract(String isContract) {
        this.isContract = isContract;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    public BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    public void setSettlementAmount(BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    public BigDecimal getSettlementNoTaxAmount() {
        return settlementNoTaxAmount;
    }

    public void setSettlementNoTaxAmount(BigDecimal settlementNoTaxAmount) {
        this.settlementNoTaxAmount = settlementNoTaxAmount;
    }
    public BigDecimal getSettlementTaxAmount() {
        return settlementTaxAmount;
    }

    public void setSettlementTaxAmount(BigDecimal settlementTaxAmount) {
        this.settlementTaxAmount = settlementTaxAmount;
    }
    

    public List<RentMachineSettlementContentEntity> getRentMachineSettlementContentList() {
        return rentMachineSettlementContentList;
    }

    public void setRentMachineSettlementContentList(List<RentMachineSettlementContentEntity> rentMachineSettlementContentList) {
        this.rentMachineSettlementContentList = rentMachineSettlementContentList;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
}
