package com.ejianc.business.rent.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.service.impl.ConfirmationContentServiceImpl;
import com.ejianc.business.rent.service.impl.ConfirmationServiceImpl;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rent.service.IConfirmationService;

/**
 * 机械台班确认单
 *
 * @author generator
 */
@Controller
@RequestMapping("confirmation")
public class ConfirmationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CONFIRM";//此处需要根据实际修改

    @Autowired
    private IConfirmationService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ConfirmationServiceImpl confirmationService;
    @Autowired
    private ConfirmationContentServiceImpl confirmationContentService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConfirmationVO> saveOrUpdate(@RequestBody ConfirmationVO saveOrUpdateVO) {
        ConfirmationEntity entity = BeanMapper.map(saveOrUpdateVO, ConfirmationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ConfirmationVO vo = BeanMapper.map(entity, ConfirmationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfirmationVO> queryDetail(Long id) {
        ConfirmationEntity entity = service.selectById(id);
        ConfirmationVO vo = BeanMapper.map(entity, ConfirmationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfirmationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConfirmationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ConfirmationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询处置申请列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListDisposal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DisposalVo>> queryListDisposal(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "supplierName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (param.getParams().containsKey("useDate")) {
            String useDate = param.getParams().get("useDate").getValue().toString();
            String[] split = useDate.split(",");
            param.getParams().put("useDate", new Parameter(QueryParam.SQL,
                    "use_date <= " + "'" + split[1] + "'" + " and use_date >=" + "'" + split[0] + "'"));
        }
        IPage<DisposalVo> page = service.queryData(param);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConfirmationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ConfirmationEntity> page = service.queryPage(param, false);
        IPage<ConfirmationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfirmationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param param
     * @Description 导出处置申请
     * @Return void
     */
    @RequestMapping(value = "/excelExportDisposal", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDisposal(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "supplierName", "billState", "billCode"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (param.getParams().containsKey("useDate")) {
            String useDate = param.getParams().get("useDate").getValue().toString();
            String[] split = useDate.split(",");
            param.getParams().put("useDate", new Parameter(QueryParam.SQL,
                    "use_date <= " + "'" + split[1] + "'" + " and use_date >=" + "'" + split[0] + "'"));
        }
        IPage<DisposalVo> page = service.queryData(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("disposal.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ConfirmationEntity> pageData = service.queryPage(param, false);
        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ConfirmationVO> list = BeanMapper.mapList(pageData.getRecords(), ConfirmationVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                        if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                        }
                    }
                });
            }

            beans.put("records", list);
            ExcelExport.getInstance().export("confirmation.xlsx", beans, response);
        }
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConfirmationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConfirmationVO>> refConfirmationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> _con = JSONObject.parseObject(condition);
            //根据项目过滤
            if (_con.get("projectId") != null) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
                logger.info("条件过滤project:{}", _con.get("projectId"));
            }
            if (_con.get("contractId") != null) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
                logger.info("条件过滤contractId:{}", _con.get("contractId"));
            }else{
                param.getParams().put("contractId", new Parameter(QueryParam.SQL, "contract_id is null"));
            }
            if (_con.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.get("supplierId")));
                logger.info("条件过滤supplierId:{}", _con.get("supplierId"));
            }
            if (_con.get("settlementFlag") != null) {
                param.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, _con.get("settlementFlag")));
                logger.info("条件过滤settlementFlag:{}", _con.get("settlementFlag"));
            }
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        IPage<ConfirmationEntity> page = service.queryPage(param, false);

        IPage<ConfirmationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<ConfirmationVO> confirmationVOS = BeanMapper.mapList(page.getRecords(), ConfirmationVO.class);

        List<ConfirmationEntity> list = page.getRecords();
        List<Long> ids = list.stream().map(ConfirmationEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(ids)) {
            pageData.setRecords(confirmationVOS);
            return CommonResponse.success("查询参照数据成功！", pageData);
        }
        LambdaQueryWrapper<ConfirmationContentEntity> lambdaQueryWrapper = new LambdaQueryWrapper<ConfirmationContentEntity>().in(ConfirmationContentEntity::getConfirmId, ids);
        List<ConfirmationContentEntity> confirmationContentEntities = confirmationContentService.list(lambdaQueryWrapper);
        Map<Long, List<ConfirmationContentEntity>> collect = confirmationContentEntities.stream().collect(Collectors.groupingBy(ConfirmationContentEntity::getConfirmId));
        if(CollectionUtil.isNotEmpty(confirmationVOS)){
            confirmationVOS.forEach(vo -> {
                if (collect.containsKey(vo.getId())) {
                    List<ConfirmationContentEntity> contentList = collect.get(vo.getId());
                    List<ConfirmationContentVO> confirmationContentVOS = BeanMapper.mapList(contentList, ConfirmationContentVO.class);
                    List<ConfirmationContentVO> confirmationContentVOList = vo.getConfirmationContentVOList();
                    if(confirmationContentVOList == null){
                        confirmationContentVOList = new ArrayList<>();
                    }
                    for (ConfirmationContentVO contentVO : confirmationContentVOS) {
                        vo.setEquipmentId(contentVO.getEquipmentId());
                        vo.setEquipmentCode(contentVO.getEquipmentCode());
                        vo.setCategoryId(contentVO.getCategoryId());
                        vo.setCategoryCode(contentVO.getCategoryCode());
                        vo.setCategoryName(contentVO.getCategoryName());
                        vo.setEquipmentCode(contentVO.getEquipmentCode());
                        vo.setEquipmentName(contentVO.getEquipmentName());
                        confirmationContentVOList.add(contentVO);
                    }
                    vo.setConfirmationContentVOList(confirmationContentVOList);

//                vo.setUnit(confirmationContentEntity.getRentUnit());
//                vo.setSpecs(confirmationContentEntity.getSpecs());
//                vo.setPrice(confirmationContentEntity.getPrice());
//                vo.setNum(confirmationContentEntity.getNum());
//                vo.setUseDate(confirmationContentEntity.getUseDate());
//                vo.setContent(confirmationContentEntity.getContent());
//                vo.setsId(confirmationContentEntity.getId());
//                vo.setBeginTime(confirmationContentEntity.getBeginTime());
//                vo.setEndTime(confirmationContentEntity.getEndTime());
//                vo.setRentUnit(confirmationContentEntity.getRentUnit());
                }
            });
        }


        pageData.setRecords(confirmationVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
