package com.ejianc.business.rent.controller;

import java.io.Serializable;

import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.vo.ExportRentSettlementVO;
import com.ejianc.business.rent.vo.RentRentalVO;
import com.ejianc.business.rent.vo.RentSettleRecordVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.vo.RentSettlementVO;

/**
 * 设备租赁结算主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentSettlement")
@Api(value = "设备租赁结算主表", tags = {"设备租赁结算主表"})
public class RentSettlementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICostDetailApi costDetailApi;

    private static final String BILL_CODE = "RENT_SETTLE";//此处需要根据实际修改

    @Autowired
    private IRentSettlementService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/equipmentRent/card";

    private final String billTypeCode = "EJCBT202204000006";

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        RentSettlementEntity entity = service.selectById(id);

        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl,null);

    }
    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentSettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentSettlementVO saveOrUpdateVO) {
        RentSettlementVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetail(@RequestParam Long id) {
    	RentSettlementEntity entity = service.selectById(id);
    	RentSettlementVO vo = BeanMapper.map(entity, RentSettlementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("查询租金单据")
    @RequestMapping(value = "/queryRental", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentRentalVO>> queryRental(@RequestParam Long contractId,@RequestParam("settleDate") String settleDate) {
        List<RentRentalEntity> rentalEntityList = service.queryRental(contractId, settleDate);
        List<RentRentalVO> voList = BeanMapper.mapList(rentalEntityList, RentRentalVO.class);
        return CommonResponse.success("查询租金数据成功！",voList);
    }
    @ApiOperation("同步结算池接口")
    @RequestMapping(value = "/syncSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        RentSettlementEntity entity = service.selectById(id);
        boolean pool = service.pushSettleToPool(BeanMapper.map(entity, RentSettlementVO.class));
        if(!pool){
            throw new BusinessException("推送结算池失败");
        }
        return CommonResponse.success("同步成功");
    }
    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentSettlementVO> pushCost(@RequestBody RentSettlementVO vo) {
        return service.pushCost(vo);
    }

    @ApiOperation("获取最近一次结算日期和结算金额、结算次数")
    @RequestMapping(value = "/getDateMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return service.getDateMny(contractId);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentSettlementVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            // 删除策划成本
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (RentSettlementVO vo : vos) {
                ExecutionVO executionVO = service.settlementTargetCost(service.selectById(vo.getId()), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
//                //删除实际成本
//                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(vo.getId());
//                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
//                if(!stringCommonResponse.isSuccess()){
//                    throw new BusinessException(stringCommonResponse.getMsg());
//                }
            }
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException(response.getMsg());
            }


        }


        service.delete(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<RentSettlementEntity> page = service.queryPage(param,false);
        IPage<RentSettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentSettlementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentSettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        ArrayList<ExportRentSettlementVO> settlementVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for (RentSettlementEntity entity : list) {
                ExportRentSettlementVO map = BeanMapper.map(entity, ExportRentSettlementVO.class);
                if(entity.getSettlementDate()!=null){
                    map.setSettlementDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSettlementDate()));
                }
                switch (entity.getSignStatus()){
                    case 0: map.setSignStatus("未签字");break;
                    case 1: map.setSignStatus("已签字");break;
                }
                //TODO  待补充 --签章
                switch (entity.getSignatureStatus()){
                    case 0: map.setSignatureStatus("未签章");break;
                }
                switch (entity.getBillState()){
                    case 0: map.setBillState("自由态");break;
                    case 1: map.setBillState("已提交");break;
                    case 2: map.setBillState("审批中");break;
                    case 3: map.setBillState("审批通过");break;
                    case 4: map.setBillState("审批驳回");break;
                    case 5: map.setBillState("审批中");break;
                }
                settlementVOS.add(map);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("RentSettlement-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refRentSettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> refRentSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RentSettlementEntity> page = service.queryPage(param,false);
        IPage<RentSettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentSettlementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody RentSettlementVO rentSettlementVO) {
        return CommonResponse.success("参数校验成功！", service.checkParams(rentSettlementVO));
    }
    /**
     * 策划成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }

    /**
     * 结算推送策划成本（不限制结算状态）
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushSettlementTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettlementTargetCost(Long id) {
        return service.pushSettlementTargetCost(id);
    }

    /**
     * 查询合同结算记录
     *
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    @ResponseBody
    public CommonResponse<RentSettleRecordVO> queryDetailRecord(Long id) {
        RentSettleRecordVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }
}
