package com.ejianc.business.rent.mapper;

import com.ejianc.business.rent.bean.RentAcceptanceSubEntity;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.rent.bean.RentAcceptanceEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 租赁设备验收
 * 
 * @author generator
 * 
 */
@Mapper
public interface RentAcceptanceMapper extends BaseCrudMapper<RentAcceptanceEntity> {
    /**
     * 查询出场编号是否重复
     * @param contractId
     * @param equipmentAppearanceCode
     * @return
     */
    public List<RentAcceptanceSubEntity> selectEquipmentAppearanceCodeList(@Param("contractId") Long contractId, @Param("equipmentAppearanceCode") String equipmentAppearanceCode);
    @Delete("DELETE m,s FROM ejc_proequipment_rent_acceptance m LEFT JOIN ejc_proequipment_rent_acceptance_sub s ON m.id = s.pid WHERE m.id = #{id}")
    Boolean delById(@Param(value = "id") Long id);
}
