package com.ejianc.business.rent.service;

import com.ejianc.business.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.rent.vo.EquipmentReportVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.rent.vo.RentRentalMonthVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rent.bean.RentParameterEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 租赁设备台账
 * 
 * @author generator
 * 
 */
public interface IRentParameterService extends IBaseService<RentParameterEntity> {
    /**
     * 根据合同id查询最多日期的一条数据
     * @param contractId
     * @return
     */
    public RentParameterEntity selectByContractIdOrderTime(Long contractId, Long acceptanceId);

    /**
     * 查询是否最新日期
     * @param contractId
     * @param myDate
     */
    public CommonResponse<String> selectValidationNewDate(Long contractId, Date myDate, Long id);

    /**
     * 弃审验证日期
     * @param contractId
     * @param myDate
     * @return
     */
    public EquipmentNewDateVO selectAbandonDate(Long contractId, Date myDate);

    /**
     * 根据验收单id删除
     *
     * @param acceptanceId
     */
    public void deleteAcceptanceId(Long acceptanceId);

    public EquipmentNewDateVO selectValidationNewDateList(Long contractId, Date myDate, Long id);

    public EquipmentNewDateVO selectValidationNewDateSub(Long contractId);

    /**
     * 变更设备台账
     * 设备启用、设备停用、设备退场，更改台账状态，并添加操作记录
     *
     * @param parameterList 设备台账列表
     * @param sourceType    来源类型
     */
    void changeParameter(List<RentParameterEntity> parameterList, String sourceType);

    /**
     * 撤销设备台账变更
     *
     * @param parameterIdList 设备台账id列表
     * @param sourceType      变更类型
     * @param sourceId        变更单据id
     */
    void cancelParameter(List<Long> parameterIdList, String sourceType, Long sourceId);

    /**
     * 启用单、停用单、退场单保存前校验，校验不通过则抛出异常
     * <p>1.校验单据类型与当前设备状态，设备启用状态无法新增启用单，设备停用状态无法新增停用单</p>
     * <p>2.互斥性校验，启用单、停用单、退场单同一个合同下只能存在一个非生效状态的单据</p>
     * <p>3.日期校验，三个单据的日期状态是滚动向前的，每次新增单据时，需要查询当前单据的时间是否大于数据库中最新的时间</p>
     *
     * @param parameterIdList 需要校验的设备台账id列表
     * @param sourceType      单据类型
     * @param sourceId        单据id
     * @param contractId      合同id
     * @param myDate          校验的时间
     */
    void checkValidation(List<Long> parameterIdList, String sourceType, Long sourceId, Long contractId, Date myDate);
    /**
     * 启用单、停用单、退场单保存前校验，校验不通过则抛出异常
     * <p>1.校验单据类型与当前设备状态，设备启用状态无法新增启用单，设备停用状态无法新增停用单</p>
     * <p>2.互斥性校验，启用单、停用单、退场单同一个合同下只能存在一个非生效状态的单据</p>
     * <p>3.日期校验，三个单据的日期状态是滚动向前的，每次新增单据时，需要查询当前单据的时间是否大于数据库中最新的时间</p>
     *
     * @param parameterIdList 需要校验的设备台账id列表
     * @param sourceType      单据类型
     * @param sourceId        单据id
     * @param contractId      合同id
     * @param myDate          校验的时间
     */
    void checkValidationSub(List<Long> parameterIdList, Map<Long, Date> detailMap, String sourceType, Long sourceId, Long contractId, Date myDate);


    /**
     * 根据合同id查询当前合同下所有的设备台账
     *
     * @param contractId 合同id
     * @param sourceId   来源id
     * @param endDate    截止日期
     * @return 合同下设备台账
     */
    List<RentParameterVO> getRentParameterByContractId(Long contractId, Long sourceId, Date endDate);

    List<RentRentalMonthVO> getRentalData(List<String> factoryCodeList);
}
