package com.ejianc.business.rent.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rent.vo.DisposalVo;
import com.ejianc.business.rent.vo.RegisterBook;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rent.mapper.RegisterMapper;
import com.ejianc.business.rent.bean.RegisterEntity;
import com.ejianc.business.rent.service.IRegisterService;

import java.util.List;

/**
 * 分包自带设备登记
 * 
 * @author generator
 * 
 */
@Service("registerService")
public class RegisterServiceImpl extends BaseServiceImpl<RegisterMapper, RegisterEntity> implements IRegisterService{

    @Override
    public IPage<RegisterBook> queryData(QueryParam param) {
        IPage<RegisterBook> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<RegisterBook> list = baseMapper.queryData(changeToQueryWrapper(param), page);
        IPage<RegisterBook> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }
}
