package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractFreezeEntity;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.service.IRentContractFreezeService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service("rentContractFreeze") 
public class RentContractFreezeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentContractFreezeService service;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IRentContractService rentContractService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Value("${common.env.base-host}")
	private String BaseHost;
	@Value("${refer.base-host:null}")
	private String BASE_HOST_FRONTEND;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		RentContractFreezeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======终审前回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("冻结解冻审批回调处理成功");
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		RentContractFreezeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("冻结解冻审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("合同冻结不支持撤回");
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentContractFreezeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======终审前回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("冻结解冻审批回调处理成功");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//修改合同状态
		logger.info("afterApprovalProcessor 终审审核完回调 触发");
		RentContractFreezeEntity entity = service.selectById(billId);
		if (entity != null){
			entity.setEffectiveDate(new Date());
			service.saveOrUpdate(entity, false);
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
			logger.error("合同查询参数"+JSONObject.toJSONString(param));
			List<RentContractEntity> contractEntities = rentContractService.queryList(param, false);
			if(entity.getContractPerformanceState()==5){
				//当前是冻结的
				contractEntities.get(0).setContractPerformanceState(ContractPerformanceStateEnum.已冻结.getStateCode());
			}else if (entity.getContractPerformanceState()==2){
				//当前是解冻的
				contractEntities.get(0).setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
			}
			logger.error("终审审核完回调"+JSONObject.toJSONString(contractEntities.get(0)));
			rentContractService.saveOrUpdate(contractEntities.get(0), false);
			// 推送合同池
			rentContractService.pushContract(BeanMapper.map(contractEntities.get(0), RentContractVO.class));

			//策划成本推送(结算单没有开发,无法适配-2022-04-11)
//			String linkUrl = BASE_HOST_FRONTEND + "ejc-proequipment-frontend/#/relieveContract/card?id=" + entity.getId();
//			ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),linkUrl,contractEntity.getContractType());
//			logger.info("策划成本推送数据" + JSON.toJSONString(executionVO));
//			CommonResponse<String> response = executionApi.aggPush(executionVO);
//			if (!response.isSuccess()) {
//				throw new BusinessException("策划成本推送失败," + response.getMsg());
//			}

			/*RentContractVO contractVO = rentContractService.queryDetail(contractEntities.get(0).getId());
			logger.error("终审审核完回调 contractVO:"+JSONObject.toJSONString(contractVO));*/
		}
		return CommonResponse.success("合同冻结/解冻 终审审核完回调处理成功!！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("合同冻结不支持撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentContractFreezeEntity entity = service.selectById(billId);
		LambdaQueryWrapper<RentContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(RentContractFreezeEntity::getContractId, entity.getContractId());
		wrapper.in(RentContractFreezeEntity::getBillState, Arrays.asList(1, 3));
		wrapper.orderByDesc(BaseEntity::getCreateTime);
		List<RentContractFreezeEntity> list = service.list(wrapper);

		if (ListUtil.isNotEmpty(list)) {
			RentContractFreezeEntity freezeEntity = list.get(0);
			if (freezeEntity.getId().equals(billId)) {
				RentContractEntity contractEntity = rentContractService.getById(entity.getContractId());
				if(contractEntity.getContractState().equals(ContractStatusEnum.履约中.getCode())){
					contractEntity.setContractState(ContractStatusEnum.已冻结.getCode());
				}else if (contractEntity.getContractState().equals(ContractStatusEnum.已冻结.getCode())) {
					contractEntity.setContractState(ContractStatusEnum.履约中.getCode());
				}
				rentContractService.save(contractEntity);
			}else {
				throw new BusinessException("存在更晚的冻结单，不允许撤回/弃审！");
			}
		}
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}



		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
}
