package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.rent.service.IRentContractRelieveService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("rentContractRelieve") 
public class RentContractRelieveBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentContractRelieveService service;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IExecutionApi executionApi;
	@Autowired
	private IRentContractService rentContractService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		RentContractRelieveEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("合同解除审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentContractRelieveEntity entity = service.selectById(billId);
		if (entity != null) {
			// 已签章
			if (entity.getDraftType() == 2) {
				entity.setSignatureState("4");
				entity.setPerformanceStatus(ContractPerformanceStateEnum.已作废.getStateCode());
				entity.setEffectiveDate(new Date());
				service.saveOrUpdate(entity, false);

				QueryParam param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
				List<RentContractEntity> contractEntities = rentContractService.queryList(param, false);
				contractEntities.get(0).setContractPerformanceState(ContractPerformanceStateEnum.已作废.getStateCode());
				logger.info("======终审审核完回调,已签章======,{}", JSONObject.toJSONString(contractEntities.get(0)));
				rentContractService.saveOrUpdate(contractEntities.get(0), false);

				// 推送策划成本
				CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
				logger.info("推送策划成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
				if (!response.isSuccess()){
					logger.error("推送策划成本失败: , {}", response.getMsg());
					throw new BusinessException(response.getMsg());
				}


				// 推送合同池
				rentContractService.pushContract(BeanMapper.map(contractEntities.get(0), RentContractVO.class));
			} else if (entity.getDraftType() == 1) {
				// 初始化成未签章
				entity.setSignatureState("1");
				logger.info("======终审审核完回调,初始化成未签章======,{}", JSONObject.toJSONString(entity));
				service.saveOrUpdate(entity, false);
			}
		}

		return CommonResponse.success("合同解除终审审核完回调处理成功!");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		RentContractRelieveEntity entity = service.selectById(billId);

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
		if("4".equals(entity.getSignatureState())){
			return CommonResponse.error("合同解除已生效，不允许弃审!");
		}

		return CommonResponse.success("撤回前校验回调成功！");
	}

}
