package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.ContractStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.mapper.RentContractMapper;
import com.ejianc.business.rent.service.*;
import com.ejianc.business.rent.utils.ListCallable;
import com.ejianc.business.rent.utils.MaterialConstant;
import com.ejianc.business.rent.vo.*;
import com.ejianc.business.settle.vo.CostPriceApiVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderRentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.*;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁合同
 *
 * @author generator
 */
@Service("rentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IRentContractChangeService rentContractChangeService;
    @Autowired
    private IRentContractFreezeService rentContractFreezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITenderRentApi tenderApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRentContractRelieveService rentContractRelieveService;

    private final String RENT_CONTRACT = "BT220303000000002";

    private static final String BILL_CODE = "RENT_CONTRACT";//此处需要根据实际修改
    private static final String BILL_CODE_YNJT = "RENT_CONTRACT_YNJT01";//云南建投编码规则
    private static final String GenerateSourceType = "SPZLSPZR10086";//编码流水号业务类型
    private static final String PRICE_PARAM_CODE = "P-A71vRo0214";//价格控制参数
    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private SessionManager sessionManager;


    private static final String CHECK_SUP_CODE = "P-oOnHR591";//设备租赁补充金额控制
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";//设备租赁总计划金额控制
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    // 设备租赁合同-签订、变更、补充协议  【设备租赁清单历史最高价】 控【设备租赁合同价格】
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-Msv0xc0196";
    // 设备租赁合同-签订、变更、补充协议  【设备租赁清单历史最低价】 控【设备租赁合同价格】
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-H2vDc40195";

    @Autowired
    private IRentContractService service;
    @Autowired
    private IRentTotalPlanService rentTotalPlanService;

    @Autowired
    private IRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractAsyncService rentContractAsyncService;

    private String getBaseHost() {
        return StringUtils.isNotBlank(BASE_HOST_FRONTEND) && !("null").equals(BASE_HOST_FRONTEND) ? BASE_HOST_FRONTEND : BaseHost;
    }

    /**
     * 保存补充协议
     *
     * @param rentContractVO
     * @return
     */
    @Override
    public RentContractVO saveOrUpdateSupplement(RentContractVO rentContractVO, String authority) {
        List<RentContractEntity> entities = null;
        List<RentContractChangeEntity> entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        //主合同
        RentContractEntity rentContractEntity = service.selectById(rentContractVO.getMainContractId());
        if (null == rentContractEntity) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(rentContractVO.getParentOrgCode()) && rentContractVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(rentContractVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                rentContractVO.setParentOrgCode(orgVO.getCode());
            }
        }
        RentContractEntity entity = BeanMapper.map(rentContractVO, RentContractEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),rentContractVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
            entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            entity.setSupplementFlag(1);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
//                entity.setMainContractCreateDate(new Date());
//                if(StringUtils.isEmpty(entity.getCode())){
//                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                }
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", rentContractVO.getMainContractId()));
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
            List<RentContractEntity> supplementList = service.queryList(param, false);

            if (StringUtils.isBlank(entity.getCode())) {
                String supplementNum = "";
                if (supplementList.size() < 9) {
                    supplementNum += "0" + (supplementList.size() + 1);
                } else {
                    supplementNum += (supplementList.size() + 1);
                }
                entity.setCode(rentContractEntity.getCode() + "2" + supplementNum);
            }
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

        }

        //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
        if (rentContractVO.getId() != null && rentContractVO.getId() > 0) {

            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getCode, rentContractVO.getCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVO.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, rentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, rentContractVO.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", rentContractVO.getMainContractId()));
            List<RentContractEntity> supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureState().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getCode, rentContractVO.getCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, rentContractVO.getCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        // 校验其他单据
        this.checkContract(rentContractVO.getMainContractId(), rentContractVO.getId());
        entity.setBaseMny(rentContractVO.getContractMny() == null ? BigDecimal.ZERO : rentContractVO.getContractMny());
        entity.setBaseTaxMny(rentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVO.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVO.getContractMny() == null ? BigDecimal.ZERO : rentContractVO.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : rentContractVO.getContractTaxMny());

        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                RentContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            }
        }

        super.saveOrUpdate(entity, false);
        RentContractVO vo = BeanMapper.map(entity, RentContractVO.class);
        return vo;
    }

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 集采合同只能本机做合同变更、补充协议等操作
        RentContractEntity contractEntity = super.selectById(id);
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureState", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<RentContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureState", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<RentContractChangeEntity> contractChangeEntityList = contractChangeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }


        // 校验解除合同
        QueryParam queryRelParam = new QueryParam();
        queryRelParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryRelParam.getParams().put("signature_state", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 查询合同解除
        List<RentContractRelieveEntity> relieveEntityList = rentContractRelieveService.queryList(queryRelParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureState");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<RentContractFreezeEntity> freezeEntityList = rentContractFreezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }

    @Override
    public RentContractVO addConvertByConId(Long contractId) {

        RentContractEntity entity = super.selectById(contractId);
        RentContractVO supplementVO = new RentContractVO();

        supplementVO.setTargetResultId(entity.getTargetResultId());
        supplementVO.setTargetResultName(entity.getTargetResultName());
        supplementVO.setPartyHandleUser(entity.getPartyHandleUser());
        supplementVO.setPartyHandleUserName(entity.getPartyHandleUserName());
        supplementVO.setPartyPhone(entity.getPartyPhone());
        supplementVO.setSupplierHandleUser(entity.getSupplierHandleUser());
        supplementVO.setSupplierHandleUserName(entity.getSupplierHandleUserName());
        supplementVO.setSupplierPhone(entity.getSupplierPhone());
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());//主合同名称
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setContractTypeName(entity.getContractTypeName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectAddress(entity.getProjectAddress());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setParentOrgId(entity.getParentOrgId());
        supplementVO.setParentOrgName(entity.getParentOrgName());
        supplementVO.setParentOrgCode(entity.getParentOrgCode());
        supplementVO.setSignedDate(new Date());
        supplementVO.setSupplementFlag(RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setSignatureState(SignatureStatusEnum.未签章.getCode().toString());
        supplementVO.setContractPerformanceState(ContractPerformanceStateEnum.未签订.getStateCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setName(entity.getContractName() + "补充协议");
        supplementVO.setMainContractCreateDate(entity.getMainContractCreateDate());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setMeterRentType(entity.getMeterRentType());
        supplementVO.setMeterRentTypeName(entity.getMeterRentTypeName());
        supplementVO.setContractName(entity.getContractName() + "补充协议");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setRentHarborType(entity.getRentHarborType());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
        supplementVO.setSupplementName(entity.getContractName() + "补充协议");
        supplementVO.setMonthSettlement(entity.getMonthSettlement());
        supplementVO.setMeterDate(entity.getMeterDate());
        supplementVO.setPreventDate(entity.getPreventDate());
        supplementVO.setContractTax(entity.getContractTax());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        RentContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增补充协议
        if (!ContractPerformanceStateEnum.履约中.getStateCode().equals(contractEntity.getContractPerformanceState())) {
            return false;
        }
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<RentContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(RentContractEntity::getMainContractId, id);
        lambda.eq(RentContractEntity::getSupplementFlag, 1);
        lambda.and(l -> l.ne(RentContractEntity::getSignatureState, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(RentContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<RentContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(RentContractVO contractVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        //主表赋值
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getCode());
        totalVO.setBillType("BT220303000000002");
        totalVO.setBussinessType(BussinessTypeEnum.施工机械租赁合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);

        //子表赋值
        //表体字段：组织(主表)、项目名称(主表)、计租方式、分类ID、分类编码、分类名称、设备档案编码、设备档案名称、单位、租赁数量、租赁天数、租赁月数、工程量、 租赁金额(无税)、租赁金额
        List<DetailExecutionVO> detailList = new ArrayList<>();
        if (null != contractVO.getRentDayDetailedList()) {
            for (RentDayDetailedVO rentDayDetailedVO : contractVO.getRentDayDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentDayDetailedVO.getId() == null ? IdWorker.getId() : rentDayDetailedVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.日租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentDayDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentDayDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentDayDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentDayDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentDayDetailedVO.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedVO.getDayRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setRentDayNum(rentDayDetailedVO.getRentDay());
                //本期结算金额
                detailExecutionVO.setMoney(rentDayDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentDayDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }
        if (null != contractVO.getRentMonthDetailedList()) {
            for (RentMonthDetailedVO rentMonthDetailedVO : contractVO.getRentMonthDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentMonthDetailedVO.getId() == null ? IdWorker.getId() : rentMonthDetailedVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.月租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentMonthDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentMonthDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentMonthDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentMonthDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentMonthDetailedVO.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedVO.getMonthRentNotTaxPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setRentMonthNum(rentMonthDetailedVO.getRentMonth());
                //本期结算金额
                detailExecutionVO.setMoney(rentMonthDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentMonthDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }
        if (null != contractVO.getRentQuantitiesDetailedList()) {
            for (RentQuantitiesDetailedVO rentQuantitiesDetailedVO : contractVO.getRentQuantitiesDetailedList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                //来源
                detailExecutionVO.setSourceId(rentQuantitiesDetailedVO.getId() == null ? IdWorker.getId() : rentQuantitiesDetailedVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setContractId(contractVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.工程量租.getCode());

                //设备分类
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedVO.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedVO.getCategoryName());

                //设备档案
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(rentQuantitiesDetailedVO.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedVO.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedVO.getName());

                detailExecutionVO.setCategoryContainFlag(false);
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                //单位
                detailExecutionVO.setUnitName(rentQuantitiesDetailedVO.getUnitName());
                //规格
                detailExecutionVO.setSpec(rentQuantitiesDetailedVO.getSpec());
                //月租单价
                detailExecutionVO.setPrice(rentQuantitiesDetailedVO.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedVO.getNotTaxQuantitiesPrice());
                //数量
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedVO.getRentNum()));
                //租赁月数
                detailExecutionVO.setQuantityNum(rentQuantitiesDetailedVO.getQuantitiesNum());
                //本期结算金额
                detailExecutionVO.setMoney(rentQuantitiesDetailedVO.getRentMny());
                detailExecutionVO.setTaxMoney(rentQuantitiesDetailedVO.getRentTaxMny());

                detailList.add(detailExecutionVO);
            }
        }

        //设备分类编码信息赋值
        //根据分类ID查询物料分类信息
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<Long> categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categoryVOList = materialApi.queryCategoryListByIds(categoryIdList).getData();
            if (CollectionUtils.isNotEmpty(categoryVOList)) {
                Map<Long, MaterialCategoryVO> categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
                for (DetailExecutionVO detailExecutionVO : detailList) {
                    if (null != categoryMap.get(detailExecutionVO.getCategoryId())) {
                        detailExecutionVO.setCategoryInnerCode(categoryMap.get(detailExecutionVO.getCategoryId()).getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryMap.get(detailExecutionVO.getCategoryId()).getCode());
                    }
                }
            }
        }
        executionVO.setDetailList(detailList);
        logger.info("策划成本推送数据---设备租赁合同---->{}", JSONObject.toJSONString(executionVO));
        return executionVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    /**
     * 补充协议详情
     *
     * @param id
     * @return
     */
    @Override
    public RentContractVO querySupplementRecord(Long id) {
        RentContractEntity contractEntity = super.selectById(id);
        RentContractVO contractVO = new RentContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper<RentContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("contract_performance_state", ContractPerformanceStateEnum.履约中.getStateCode());
        query.orderByDesc("create_time");
        List<RentContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, RentContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)) {
            for (RentContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() != null) {
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState())))) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    /**
     * 推送合同项目池
     *
     * @param contractVO 需要推送的合同数据
     */
    @Override
    public void pushContract(RentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.设备租赁.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());

            data.setPcCardUrl("/ejc-proequipment-frontend/#/leaseContract/cardList?id=" + contractVO.getId() + "&showTitle=true&supplementFlag=" + contractVO.getSupplementFlag());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));
        c2.getParams().put("signature_state", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        c1.getComplexParams().add(c2);

        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(c1);


        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam2.getComplexParams().add(c1);


        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam3.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = BeanMapper.map(queryParam, QueryParam.class);
        QueryParam param2 = BeanMapper.map(queryParam2, QueryParam.class);
        QueryParam param3 = Utils.deepCopy(queryParam3);// 深拷贝
        if (billId != null) {
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param2.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param3.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }

        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.补充协议.equals(billType) ? param : queryParam, service); // 补充协议
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.变更单.equals(billType) ? param2 : queryParam2, contractChangeService); // 变更单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.解除单.equals(billType) ? param2 : queryParam2, rentContractRelieveService); // 解除单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.冻结单.equals(billType) ? param3 : queryParam3, rentContractFreezeService); // 冻结单

        List<RentContractEntity> supplementList = new ArrayList<>(); // 补充协议
        List<RentContractChangeEntity> changeList = new ArrayList<>(); // 变更单
        List<RentContractRelieveEntity> relieveList = new ArrayList<>(); // 解除单
        List<RentContractFreezeEntity> freezeList = new ArrayList<>(); // 冻结单

        try {
            supplementList = JSONObject.parseArray(future1.get().toJSONString(), RentContractEntity.class);
            changeList = JSONObject.parseArray(future2.get().toJSONString(), RentContractChangeEntity.class);
            relieveList = JSONObject.parseArray(future3.get().toJSONString(), RentContractRelieveEntity.class);
            freezeList = JSONObject.parseArray(future4.get().toJSONString(), RentContractFreezeEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("当前合同存在非审批通过态或未签章的补充协议，不允许" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("当前合同存在非审批通过态或未签章的变更单，不允许" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("当前合同存在非审批通过态的冻结单，不允许" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("当前合同存在非审批通过态或未签章的解除单，不允许" + type + "!");
        }

        return "校验通过！";
    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(RentContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    /**
     * 查询子表数据
     *
     * @return
     */
    @Override
    public IPage<RentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> param) {
        IPage<RentContractEquipmentAllVO> page = new Page<RentContractEquipmentAllVO>();


        /** 数据隔离 本下 */
        //param.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.put("tenantId", InvocationInfoProxy.getTenantid());

        Integer count = rentContractMapper.countNumber(param);
        if (count > 0) {
            List<RentContractEquipmentAllVO> appEntity = rentContractMapper.queryEquipmentSubList(param);
            page.setRecords(appEntity);
        } else {
            page.setRecords(new ArrayList<>());
        }
        if (param.get("pageIndex") != null) {
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }
        return page;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<RentContractVO> vos) {
        vos.forEach(contractVO -> {
            RentContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse<String> tender = tenderApi.updateById(contractEntity.getTargetResultId(), 0);
                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
            }
        });
        this.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public RentContractEntity selectCode(String code) {
        QueryWrapper<RentContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", code);
        queryWrapper.eq("dr", "0");
        List<RentContractEntity> list = rentContractMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    @Override
    public void pushDelContract(RentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.设备租赁.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            data.setSourceId(contractVO.getId());
            logger.info("开始删除合同池合同>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<String> transDataResp = contractPoolApi.deleteContract(data);
            logger.info("删除合同池合同结束，删除结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVO, String authority, Boolean isControl) {
        List<RentContractEntity> entities = null;
        List<RentContractChangeEntity> entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(rentContractVO.getParentOrgCode()) && rentContractVO.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(rentContractVO.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                rentContractVO.setParentOrgCode(orgVO.getCode());
//            }
//        }
//        // orgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(rentContractVO.getOrgCode()) && rentContractVO.getOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(rentContractVO.getOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                rentContractVO.setOrgCode(orgVO.getCode());
//            }
//        }
        if (rentContractVO.getOrgId() != null
                && (StringUtils.isEmpty(rentContractVO.getOrgCode())
                || StringUtils.isEmpty(rentContractVO.getParentOrgCode())
                || StringUtils.isEmpty(rentContractVO.getOrgName()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(rentContractVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                rentContractVO.setOrgCode(orgVO.getCode());
                if (StringUtils.isEmpty(rentContractVO.getOrgName())) {
                    rentContractVO.setOrgName(orgVO.getName());
                }
                // 项目部
                if (5 == orgVO.getOrgType()) {
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        rentContractVO.setParentOrgId(parentOrgVO.getId());
                        rentContractVO.setParentOrgCode(parentOrgVO.getCode());
                        rentContractVO.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    rentContractVO.setParentOrgId(rentContractVO.getOrgId());
                    rentContractVO.setParentOrgCode(rentContractVO.getOrgCode());
                    rentContractVO.setParentOrgName(rentContractVO.getOrgName());
                }
            }
        }
        RentContractEntity entity = BeanMapper.map(rentContractVO, RentContractEntity.class);
        //起草方式为使用合同模板时，将合同文件同步标识置为未同步
        if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl) {
            if (entity.getId() == null || entity.getId() == 0) {
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),rentContractVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if(billCode.isSuccess()) {
                entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                entity.setMainContractCreateDate(new Date());
//                }else{
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }

            }
            if (StringUtils.isEmpty(entity.getCode())) {
                switch (GenerateBillCodeType) {
                    case "common":
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), rentContractVO));
                        if (!billCode.isSuccess()) {
                            logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setCode(billCode.getData());
                        break;
                    case "ynjt":
                        CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE_YNJT, InvocationInfoProxy.getTenantid(), rentContractVO));
                        if (!billCodeFirstPart.isSuccess()) {
                            logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        //根据合同基层单位后三位查询查询流水号
                        CommonSNVO commonSNVO = new CommonSNVO();
                        commonSNVO.setSnLength(4);
                        commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                        commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                        commonSNVO.setSourceType(GenerateSourceType);
                        CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                        if (!snResp.isSuccess()) {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setCode(billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + snResp.getData());
                        rentContractVO.setCode(entity.getCode());
                        break;
                }
//                        entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }
        }

        //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
        if (rentContractVO.getId() != null && rentContractVO.getId() > 0) {

            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getCode, rentContractVO.getCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVO.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, rentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, rentContractVO.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getCode, rentContractVO.getCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, rentContractVO.getCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        //设置合同初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
//        if (entity.getContractFileId() != null && !isControl) {
//            if (entity.getId() != null) {
//                RentContractEntity contract = service.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    service.delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFile(null);
//                }
//            } else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    service.delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFile(null);
//                }
//            }
//        }
        // 1、合同保存方法增加逻辑
        if (entity.getContractFileId() != null) {
            //合同旧数据
            RentContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractType().equals(entity.getContractType())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFile(null);
            }
        }
        if (!isControl) {

            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingRef(0);
            }
            RentContractEntity rentContractEntityTarget = null;//合同操作定标修改使用  报错修改前获取之前合同信息
            if (rentContractVO.getId() != null) {
                rentContractEntityTarget = super.selectById(rentContractVO.getId());
            }
            boolean saveFlag = super.saveOrUpdate(entity, false);
            if (!saveFlag) {
                throw new BusinessException("合同保存失败！");
            }
            // 回写定标结果占据状态
            if (entity.getTargetResultId() != null) {
                // 校验 本合同金额+定标已签合同金额 是否大于 定标金额
                validateTargetMny(entity);
            }
            //定标回写占用
            //占用状态0-未占用,1-已占用,2-已完成
            if (rentContractVO.getId() == null && rentContractVO.getTargetResultId() != null) {
                updateTargetResult(entity, 0);
            }
            if (rentContractVO.getId() != null && rentContractVO.getTargetResultId() != null && rentContractEntityTarget != null) {
                // 如果是合同修改，先对修改前合同做反向操作，再进行占用
                updateTargetResult(rentContractEntityTarget, 1);
                updateTargetResult(entity, 0);
            }
//招标占用
//            if (rentContractVO.getId() != null && rentContractVO.getTargetResultId() != null) {
//                RentContractEntity rentContractEntity = super.selectById(rentContractVO.getId());
//                CommonResponse<String> stringCommonResponse = tenderApi.updateById(rentContractEntity.getTargetResultId(), 0);
//                tenderApi.updateById(rentContractVO.getTargetResultId(), 1);
//            }

            //策划成本推送
            String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + entity.getId();
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, RentContractVO.class), linkUrl);
            logger.info("策划成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("策划成本推送失败," + response.getMsg());
            }
        }

        RentContractVO vo = BeanMapper.map(entity, RentContractVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);

    }

    @Override
    public ParamsCheckVO targetCostCtrl(RentContractVO contractVO, String authority) {
        RentContractVO contractVO1 = saveOrUpdate(contractVO, authority, true).getData();
        //策划成本推送
        String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO1.getId();
        ExecutionVO executionVO = service.targetCost(contractVO1, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO1, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        RentContractVO contractVO = queryDetail(id);
        String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO.getId();
        ExecutionVO executionVO = service.targetCost(contractVO, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = service.selectById(id);
        RentContractVO vo = BeanMapper.map(entity, RentContractVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        //有解除单推送解除数据
//        ExecutionVO executionVO = new ExecutionVO();
        RentContractEntity rentContractEntity = service.selectById(id);
        if (ContractStatusEnum.已作废.getCode().toString().equals(rentContractEntity.getContractPerformanceState())) {
            //查询解除单
            QueryWrapper<RentContractRelieveEntity> relieveQueryWrapper = new QueryWrapper<RentContractRelieveEntity>();
            relieveQueryWrapper.eq("contract_id", id);
            RentContractRelieveEntity rentContractRelieveEntity = rentContractRelieveService.getOne(relieveQueryWrapper);
            ExecutionVO executionVO = rentContractRelieveService.targetCost(rentContractRelieveEntity);
            logger.info("策划成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("策划成本推送失败," + response.getMsg());
            }
        }

        //有变更单推送变更单数据,否则推送主合同数据
        QueryWrapper<RentContractChangeEntity> rentContractChangeEntityQueryWrapper = new QueryWrapper<RentContractChangeEntity>();
        rentContractChangeEntityQueryWrapper.eq("contract_id", id).orderByDesc("create_time");
        ExecutionVO executionVO = new ExecutionVO();
        List<RentContractChangeEntity> contractChangeEntityList = rentContractChangeService.list(rentContractChangeEntityQueryWrapper);
        if (contractChangeEntityList.size() > 0) {
            RentContractChangeEntity rentContractChangeEntity = rentContractChangeService.selectById(contractChangeEntityList.get(0).getId());
            executionVO = rentContractChangeService.targetCost(BeanMapper.map(rentContractChangeEntity, RentContractChangeVO.class), null);
        } else {
            //策划成本推送
            RentContractVO rentContractVO = service.queryDetail(id);
            String linkUrl = getBaseHost() + "ejc-proequipment-frontend/#/leaseContract/card?id=" + rentContractVO.getId();
            executionVO = service.targetCost(rentContractVO, linkUrl);
        }

        logger.info("策划成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("策划成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("策划成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(RentContractVO vo, ParamsCheckVO paramsCheckVO2) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));//总计划控制补充、主合同金额
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), RentContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
        }
        if (paramsCheckVO2 != null) {//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        // 历史价控 合同价
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));

        //策划成本价格控制
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if (costParams != null) {
            paramsCheckVOS.add(costParams);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    /**
     * 目标价格控制
     *
     * @param vo
     * @return
     */
    public ParamsCheckVO costPriceCheckParams(RentContractVO vo) {
        List<RentDayDetailedVO> rentSettlementDayList = vo.getRentDayDetailedList();
        List<RentMonthDetailedVO> rentSettlementMonthList = vo.getRentMonthDetailedList();
        List<RentQuantitiesDetailedVO> rentSettlementQuantitiesList = vo.getRentQuantitiesDetailedList();

        CostPriceApiVO materialPriceHistoryApiVO = new CostPriceApiVO();
        List<CostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(rentSettlementDayList)) {
            for (RentDayDetailedVO detailVO : rentSettlementDayList) {
                if (!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId() != null) {
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getDayRentNotTaxPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getDayRentPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(rentSettlementMonthList)) {
            for (RentMonthDetailedVO detailVO : rentSettlementMonthList) {
                if (!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId() != null) {
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getMonthRentNotTaxPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getMonthRentPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(rentSettlementQuantitiesList)) {
            for (RentQuantitiesDetailedVO detailVO : rentSettlementQuantitiesList) {
                if (!"del".equals(detailVO.getRowState()) && detailVO.getEquipmentId() != null) {
                    CostPriceApiVO priceHistoryApiVO = new CostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getEquipmentId());
                    priceHistoryApiVO.setMaterialName(detailVO.getName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getNotTaxQuantitiesPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getQuantitiesPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = rentSettlementService.costPriceParams(materialPriceHistoryApiVO, PRICE_PARAM_CODE, "设备租赁合同");
        return paramsCheckVO;
    }

    /**
     * 历史价控合同价
     *
     * @param contractVO
     * @return
     */
    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(RentContractVO contractVO) {
        logger.info("proequipment---RentContractServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<RentDayDetailedVO> dayDetailList = contractVO.getRentDayDetailedList();
        List<RentMonthDetailedVO> monthDetailList = contractVO.getRentMonthDetailedList();
        List<RentQuantitiesDetailedVO> quantitiesDetailList = contractVO.getRentQuantitiesDetailedList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());

        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("设备租赁合同历史高价控制信息返回：" + JSONObject.toJSONString(maxParamVOS));
        logger.info("设备租赁合同历史低价控制信息返回：" + JSONObject.toJSONString(minParamVOS));
        if (CollectionUtils.isNotEmpty(maxParamVOS)) {//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (RentDayDetailedVO detailVO : dayDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice() == null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price, maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (RentMonthDetailedVO detailVO : monthDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice() == null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price, maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (RentQuantitiesDetailedVO detailVO : quantitiesDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice() == null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) > 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price, maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty(minParamVOS)) {//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (RentDayDetailedVO detailVO : dayDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getDayRentPrice() == null ? BigDecimal.ZERO : detailVO.getDayRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//日租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("日租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("日租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam, price).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //月租
                for (RentMonthDetailedVO detailVO : monthDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getMonthRentPrice() == null ? BigDecimal.ZERO : detailVO.getMonthRentPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//月租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("月租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("月租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam, price).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                //工程量租
                for (RentQuantitiesDetailedVO detailVO : quantitiesDetailList) {//遍历明细
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea != null && !getHistoryPriceArea.isEmpty()) {//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice = new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}", detailVO.getName(), split[1], split[0]);
                        if (maxPrice.compareTo(minPrice) == 0) {//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getQuantitiesPrice() == null ? BigDecimal.ZERO : detailVO.getQuantitiesPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//工程量租单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getName());
                            paramsCheckDsVO.setWarnName("工程量租单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("工程量租单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam, price).setScale(4, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }


    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(RentContractVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), vo.getOrgId());
        logger.info("施工合同控制信息返回：" + JSONObject.toJSONString(response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("获取施工参数控制信息失败!" + response.getMsg());
        }
        return response.getData();
    }

    /**
     * 单据管控-补充协议金额大于合同金额
     *
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnySup(RentContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();//本次补充协议金额
        RentContractEntity contractEntity = super.selectById(vo.getMainContractId());
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();//初始合同金额
        BigDecimal totalSupMoney = contractTaxMnySup;//累计补充金额  默认赋值本次
        //查询累计补充金额
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureState", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        List<RentContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementContractList)) {
            for (RentContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(), totalSupMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_SUP_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUP_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("协议金额控制信息返回：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 单据管控-合同金额大于总计划金额
     *
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(RentContractVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();//本次合同金额
        BigDecimal planTaxMny = BigDecimal.ZERO;//总计划金额
        BigDecimal totalMoney = contractTaxMny;//累计合同金额  默认赋值本次
        //查询总计划
        LambdaQueryWrapper<RentTotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
        planLambda.eq(RentTotalPlanEntity::getProjectId, vo.getProjectId());
        planLambda.in(RentTotalPlanEntity::getBillState, 1, 3);
        planLambda.eq(RentTotalPlanEntity::getDr, 0);
        List<RentTotalPlanEntity> planList = rentTotalPlanService.list(planLambda);
        if (CollectionUtils.isNotEmpty(planList)) {
            planTaxMny = planList.stream().filter(e -> e.getTemporaryAmount() != null).map(RentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            return paramsCheckVOList;
        }
        //查询合同
        LambdaQueryWrapper<RentContractEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(RentContractEntity::getProjectId, vo.getProjectId());
        Lambda.orderByDesc(RentContractEntity::getCreateTime);
        if (vo.getId() != null) {
            Lambda.ne(RentContractEntity::getId, vo.getId());//除本次
        }
        List<RentContractEntity> list = super.list(Lambda);//查询项目下所有合同
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> collect = list.stream().map(RentContractEntity::getId).collect(Collectors.toList());
            List<RentContractChangeVO> contractChangeList = baseMapper.getRentContractChangeList(collect);//查询未生效的变更单
            Map<Long, RentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<RentSettlementVO> settlementList = baseMapper.getRentSettlementList(collect);//查询最后一个结算单
            Map<Long, RentSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(RentSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (RentContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;//要累加的金额
                if (ContractPerformanceStateEnum.已终止.getStateCode().equals(entity.getContractPerformanceState()) || ContractPerformanceStateEnum.已作废.getStateCode().equals(entity.getContractPerformanceState())) {
                    //合同已终止、已结束、已作废：取合同结算金额）  即最终结算或 最后一次结算  累计结算金额
                    if (mapSettle.containsKey(entity.getId())) {
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }// 校验变更合同
                } else if (mapChange.containsKey(entity.getId())) {//有为生效的变更单  取最新变更单金额
                    zero = mapChange.get(entity.getId()).getContractTaxMny();
                } else {//没有未生效的变更单   合同状态为 未签订、履约中、已冻结取签订金额
                    zero = entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd(zero, totalMoney);//累加变更金额
            }
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE, vo.getOrgId());
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PLAN_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制信息返回：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("租赁金额超总计划金额");
                        paramsCheckDsVO.setWarnName("租赁金额超总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计合同金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse<ContractPaymentResultVO> res = paymentApplyApi.queryJsonByContractId(id);
        if (!res.isSuccess()) {
            logger.error("获取付款详情失败!");
        }
        return res.getData();
    }

    /**
     * 占用/释放 定标结果
     *
     * @param vo   合同vo
     * @param type 0占用，1释放
     */
    @Override
    public void updateTargetResult(RentContractEntity vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }

        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId()); // 定标参照id
        picketageVO.setContractMoneyTax(vo.getContractTaxMny()); // 合同金额（含税）
        picketageVO.setContractMoney(vo.getContractMny()); // 合同金额
        List<TenderPicketageDetailVO> list = new ArrayList<>();
        picketageVO.setTenderPicketageDetailList(list);
        CommonResponse<String> response;
        String typeStr = 0 == type ? "占用" : "释放";
        logger.info("{}定标结果请求参数：{}", typeStr, JSONObject.toJSONString(picketageVO));
        // 占用
        if (0 == type) {
            response = tenderApi.updateStatus(picketageVO);
        }
        // 释放
        else {
            response = tenderApi.delUpdateStatus(picketageVO);
        }
        logger.info("{}定标结果请求结果：{}", typeStr, JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "定标结果失败！");
        }
    }

    @Override
    public Boolean validateTargetMny(RentContractEntity entity) {
        LambdaQueryWrapper<RentContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RentContractEntity::getTargetResultId, entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(RentContractEntity::getId, entity.getId());
        }
        List<RentContractEntity> list = this.list(wrapper);

        BigDecimal sumContractTaxMny = list.stream().map(RentContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        sumContractTaxMny = ComputeUtil.safeAdd(sumContractTaxMny, entity.getContractTaxMny());

        if (sumContractTaxMny.compareTo(entity.getTargetTaxMny()) > 0) {
            throw new BusinessException("合同累计签订金额超过定标金额，不可保存！");
        }

        return true;
    }

    /**
     * 根据定标结果id查询对应合同
     *
     * @param targetResultIdList 定标结果id
     * @return 查询结果
     */
    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        List<SignContractVo> rtnList = new ArrayList<>();
        if (CollectionUtils.isEmpty(targetResultIdList)) return rtnList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
        queryParam.getOrderMap().put("signedDate", QueryParam.DESC);
        List<RentContractEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(entityList)) return rtnList;
        for (RentContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignedDate());
            vo.setBillState(entity.getBillState());
            String url = "/ejc-proequipment-frontend/#/leaseContract/cardList?id=" + entity.getId() + "&showTitle=true";
            vo.setLinkUrl(url);
            rtnList.add(vo);
        }

        return rtnList;
    }

    /**
     * 根据合同id给水印文件赋值
     *
     * @param id 合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        RentContractEntity contractEntity = super.selectById(id);
        // 合同添加水印
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        logger.info("valueData" + valueData);
        if ("0".equals(valueData)) {
            logger.info("valueData" + valueData);
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                    contractEntity.getCode(), "BT220303000000002", "proRentContractWater");
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            rentContractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0 ： 不限制 ， 1 ： 部分限制 ， 2 ： 全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        RentContractEntity rentContractEntity = super.selectById(contractId);
        // 不限制
        if ("0".equals(valueData)) {
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(rentContractEntity.getFilingStatus());
        }
    }

    @Override
    public void delChangeById(Long id) {
        rentContractMapper.delChangeById(id);
    }

    @Override
    public void delRecordById(Long id) {
        rentContractMapper.delRecordById(id);
    }

    /**
     * 删除合同池数据
     *
     * @param id
     * @return
     */
    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public void delById(Long id) {
        rentContractMapper.delById(id);
    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {


        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
        //Map<String, contractCategoryId> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();
//        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        List<ImportContractVO> successList;
        List<ImportContractVO> errorList;
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            successList = new ArrayList<>();
            errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                // 从自定义档案接口查询计租方式并封装成map
                Map<String, String> defMap = new HashMap<>();
                Map<String, Object> defParamMap = new HashMap<>();
                defParamMap.put("tenantId", tenantid);
                String defCondition = JSONObject.toJSONString(defParamMap);
                CommonResponse<List<Map<String, Object>>> defRes = defdocApi.queryDetailListByDefdocCode("meter_rent_type", defCondition);
                if (defRes.isSuccess() && defRes.getData() != null) {
                    List<Map<String, Object>> defList = defRes.getData();
                    defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }

                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractVO detailVO = new ImportContractVO();
                    // 从Excel拿到的数据
                    String projectNameEx = datas.get(0);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String parentOrgName = datas.get(1);// 所属单位，非必填项
                    detailVO.setParentOrgName(parentOrgName);
                    String contractNameEx = datas.get(2);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String contractTypeName = datas.get(3);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setContractTypeName(contractTypeName);
                    String partyName = datas.get(4);// 甲方，必填项
                    detailVO.setPartyName(partyName);
                    String supplierName = datas.get(5);// 乙方，必填项
                    detailVO.setSupplierName(supplierName);
                    String signDateStrEx = datas.get(6);// 签订日期，必填项，日期
                    String meterRentTypeName = datas.get(7);// 计租方式，必填项，
                    detailVO.setMeterRentTypeName(meterRentTypeName);
                    String meterDate = datas.get(8);// 计租日期，必填项，日期
                    String preventDate = datas.get(9);// 止租方式，必填项，日期
                    String contractStatus = datas.get(10); //合同履约状态，必填
                    detailVO.setContractPerformanceName(contractStatus);
                    String taxRate = datas.get(11);// 税率，数值，必填项，大于等于0，保留2位小数
                    String employeeName = datas.get(12); //甲方经办人,必填
                    detailVO.setPartyHandleUserName(employeeName);
                    String partyPhone = datas.get(13); //甲方电话,必填
                    detailVO.setPartyPhone(Long.valueOf(partyPhone));
                    String supplierHandleUserName = datas.get(14);// 乙方经办人,非必填
                    detailVO.setSupplierHandleUserName(supplierHandleUserName);
                    String supplierPhone = datas.get(15);// 乙方电话,非必填
                    detailVO.setSupplierPhone(supplierPhone);

                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    } else {
                        // 优先查询缓存map
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                } else {
                                    if (projectVOList.size() == 1) {
                                        // 存储到缓存map
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        // 项目所在项目部
                                        Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                        if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                            // 缓存map为空或无当前行数据，调用接口查询
                                            CommonResponse<OrgVO> orgVOCommonResponse = iOrgApi.detailById(projectDepartmentId);
                                            if (orgVOCommonResponse.isSuccess()) {
                                                OrgVO orgVO = orgVOCommonResponse.getData();
                                                if (orgVO == null) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    // 存入缓存map
                                                    projectOrgVoMap.put(projectDepartmentId.toString(), orgVO);
                                                    // 封装数据
                                                    orgIdP = orgVO.getId();
                                                    String innerCode = orgVO.getInnerCode();
                                                    if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                        detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                    } else {
                                                        List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                        if (!innerCodes.contains(orgIdP)) {
                                                            detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                        } else {
                                                            detailVO.setOrgId(orgVO.getId());
                                                            detailVO.setOrgCode(orgVO.getCode());
                                                            detailVO.setOrgName(orgVO.getName());
//                                                            detailVO.setParentOrgId(orgVO.getId());
//                                                            detailVO.setParentOrgCode(orgVO.getCode());
//                                                            detailVO.setParentOrgName(orgVO.getName());
                                                        }
                                                    }
                                                }
                                            } else {
                                                detailVO.setErrorMessage("根据项目名称和编码查询所在项目部信息失败");
                                            }
                                        } else {
                                            // 缓存map有当前数据
                                            OrgVO orgVO = projectOrgVoMap.get(projectDepartmentId.toString());
                                            String innerCode = orgVO.getInnerCode();
                                            if (org.apache.commons.lang3.StringUtils.isEmpty(innerCode)) {
                                                detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                            } else {
                                                List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                if (!innerCodes.contains(orgIdP)) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    detailVO.setOrgId(orgVO.getId());
                                                    detailVO.setOrgCode(orgVO.getCode());
                                                    detailVO.setOrgName(orgVO.getName());
//                                                    detailVO.setParentOrgId(orgVO.getId());
//                                                    detailVO.setParentOrgCode(orgVO.getCode());
//                                                    detailVO.setParentOrgName(orgVO.getName());
                                                }
                                            }
                                        }
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                        // 封装数据
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectCode(projectPoolSetVO.getCode());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                    } else {
                                        detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据项目名称查询项目失败");
                            }
                        } else {
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        }
                    }

//                    //所属组织
                    if (StringUtils.isNotBlank(parentOrgName)) {
                        // 与【组织管理】“组织名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgName) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<OrgVO> orgVORes = iOrgApi.findByNameAndTenantId(parentOrgName, tenantid);
                            if (orgVORes.isSuccess()) {
                                OrgVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据项目所属单位查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    orgVOMap.put(parentOrgName, orgVO);
                                    // 封装数据
                                    orgIdP = orgVO.getId();
//                                    detailVO.setOrgId(orgVO.getId());
//                                    detailVO.setOrgCode(orgVO.getCode());
//                                    detailVO.setOrgName(orgVO.getName());
                                    detailVO.setParentOrgId(orgVO.getId());
                                    detailVO.setParentOrgCode(orgVO.getCode());
                                    detailVO.setParentOrgName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据项目所属单位查询数据失败");
                            }
                        } else {
                            OrgVO orgVO = orgVOMap.get(parentOrgName);
//                            detailVO.setOrgId(orgVO.getId());
//                            detailVO.setOrgCode(orgVO.getCode());
//                            detailVO.setOrgName(orgVO.getName());
                            detailVO.setParentOrgId(orgVO.getId());
                            detailVO.setParentOrgCode(orgVO.getCode());
                            detailVO.setParentOrgName(orgVO.getName());
                        }
                    }

                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }

                    //合同类别
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractTypeName)) {
                        detailVO.setErrorMessage("合同类别不能为空");
                    } else {
                        if ("设备租赁".equals(contractTypeName)) {
//                            detailVO.setContractCategoryId(1871018331562053633L);
                            detailVO.setContractType(1903385416673792002L);
                            detailVO.setContractTypeName(contractTypeName);
                            detailVO.setRentTypeName("设备租赁合同");
                        } else {
                            detailVO.setErrorMessage("合同类别错误");
                        }
                    }

                    // 甲方
                    if (StringUtils.isBlank(partyName)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(partyName, tenantid);
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partyName, orgVO);
                                    // 封装数据
                                    //TODO
                                    detailVO.setPartyId(orgVO.getId());
                                    detailVO.setPartyName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(partyName);
                            detailVO.setPartyId(orgVO.getId());
                            detailVO.setPartyName(orgVO.getName());

                        }
                    }


                    //乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierName)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(supplierName) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(supplierName, tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(supplierName, orgVO);
                                    // 封装数据
                                    detailVO.setSupplierId(orgVO.getId());
                                    detailVO.setSupplierName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(supplierName);
                            detailVO.setSupplierId(orgVO.getId());
                            detailVO.setSupplierName(orgVO.getName());

                        }
                    }

                    //甲方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(employeeName)) {
                        detailVO.setErrorMessage("甲方经办人不能为空");
                    } else {
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName) == null) {
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                            if (map.isSuccess()) {
                                Map<String, EmployeeVO> data = map.getData();
                                if (data == null || data.size() == 0) {
                                    detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                                } else {
                                    EmployeeVO employeeVO = data.get(employeeName);
                                    employeeVOMap.put(employeeName, employeeVO);
                                    detailVO.setPartyHandleUser(employeeVO.getId());
                                    detailVO.setPartyHandleUserName(employeeVO.getName());
                                }

                            } else {
                                detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                            }
                        } else {
                            EmployeeVO employeeVO = employeeVOMap.get(employeeName);
                            detailVO.setPartyHandleUser(employeeVO.getId());
                            detailVO.setPartyHandleUserName(employeeVO.getName());
                        }
                    }

                    //甲方电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyPhone)) {
                        detailVO.setErrorMessage("甲方经办人电话不能为空");
                    } else {
                        detailVO.setPartyPhone(Long.valueOf(partyPhone));
                    }


                    //乙方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierHandleUserName)) {
                        detailVO.setErrorMessage("乙方经办人不能为空");
                    } else {
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(supplierHandleUserName) == null) {
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(supplierHandleUserName));
                            if (map.isSuccess()) {
                                Map<String, EmployeeVO> data = map.getData();
                                if (data == null || data.size() == 0) {
                                    detailVO.setErrorMessage("根据乙方经办人查询数据失败");
                                } else {
                                    EmployeeVO employeeVO = data.get(supplierHandleUserName);
                                    employeeVOMap.put(supplierHandleUserName, employeeVO);
                                    detailVO.setSupplierHandleUser(employeeVO.getId());
                                    detailVO.setSupplierHandleUserName(employeeVO.getName());
                                }

                            } else {
                                detailVO.setErrorMessage("根据乙方经办人查询数据失败");
                            }
                        } else {
                            EmployeeVO employeeVO = employeeVOMap.get(supplierHandleUserName);
                            detailVO.setSupplierHandleUser(employeeVO.getId());
                            detailVO.setSupplierHandleUserName(employeeVO.getName());
                        }
                    }
                    //乙方电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(supplierPhone)) {
                        detailVO.setErrorMessage("乙方经办人电话不能为空");
                    } else {
                        detailVO.setSupplierPhone(supplierPhone);
                    }

                    //计租
                    if (org.apache.commons.lang.StringUtils.isBlank(meterRentTypeName)){
                        detailVO.setErrorMessage("计租方式不可为空");
                    }else{
                        StringJoiner sb = new StringJoiner(",");
                        String[] split = meterRentTypeName.split(",");
                        for (String s : split) {
                            if(defMap.containsKey(s)){
                                sb.add(defMap.get(s));
                            }
                        }
                        if(sb != null && sb.length() > 0){
                            detailVO.setMeterRentType(sb.toString());
                        }
                        else{
                            detailVO.setErrorMessage("计租方式填写不正确");
                        }
                    }

                    // 签订日期
                    if (StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignedDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }

                    // 计租日期
                    if (StringUtils.isBlank(meterDate)) {
                        detailVO.setErrorMessage("计租日期不可为空");
                    } else {
                        try {
                            detailVO.setMeterDate(HSSFDateUtil.getJavaDate(Double.parseDouble(meterDate)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("计租日期填写不正确");
                        }
                    }

                    // 止租日期
                    if (StringUtils.isBlank(preventDate)) {
                        detailVO.setErrorMessage("止租日期不可为空");
                    } else {
                        try {
                            detailVO.setPreventDate(HSSFDateUtil.getJavaDate(Double.parseDouble(preventDate)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("止租日期填写不正确");
                        }
                    }


                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRate)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate1 = new BigDecimal(taxRate);
                            if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setContractTax(taxRate1);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }


                    //合同状态
                    if (StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else {
                        if (StringUtils.isBlank(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        }
                        if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getDescription().equals(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getDescription().equals(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getCode());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setContractPerformanceState(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getCode());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }

                    // 封装返回的数据
                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
//                    detailVO.setSupplementFlagName("否");
                    detailVO.setFilingStatus(0);
//                    detailVO.setSignatureStatus("1");
                    detailVO.setDraftType("3");
                    detailVO.setAddType(1);
                    detailVO.setSupplementFlag(0);
//                    detailVO.setPurchaseType(1);
//                    if (flag.equals(0)){
//                        detailVO.setContractPropertyCode("proMaterial-1");
//                        detailVO.setContractPropertyName("大宗材");
//                    }else{
//                        detailVO.setContractPropertyCode("contractConcrete-1");
//                        detailVO.setContractPropertyName("混凝土");
                }

            }
        }
        // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);

        // 拼接入库数据并入库
        Date createTime = new Date();
        UserContext userContext = sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        List<RentContractVO> sucVoList = BeanMapper.mapList(successList, RentContractVO.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sucVoList)) {
            for (RentContractVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                long contractId = com.ejianc.support.idworker.util.IdWorker.getId();
                //vo.setContractId(contractId);
//                    vo.setSourceId(contractId);
                if (StringUtils.isBlank(vo.getCode())) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantid, vo);
                        CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                        if(billCodeRes.isSuccess()) {
                            vo.setCode(billCodeRes.getData());
                        }else{
                            throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                        }
                }
            }
            List<RentContractEntity> sucEntityList = BeanMapper.mapList(sucVoList, RentContractEntity.class);
            saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success(json);
    }

}
