package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.bean.ContractEntity;
import com.ejianc.business.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.ac.service.IContractService;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentMachineSettlementContentVO;
import com.ejianc.business.rent.vo.RentMachineSettlementVO;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rent.mapper.RentMachineSettlementMapper;
import com.ejianc.business.rent.service.IRentMachineSettlementService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 施工机械结算
 * 
 * @author generator
 * 
 */
@Service("rentMachineSettlementService")
public class RentMachineSettlementServiceImpl extends BaseServiceImpl<RentMachineSettlementMapper, RentMachineSettlementEntity> implements IRentMachineSettlementService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentMachineSettlementService rentMachineSettlementService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IRentContractService contractService;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private SessionManager sessionManager;

    private final String BILL_TYPE="EJCBT202504000013";

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return true;
        }
        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        throw new BusinessException("将结算单从结算池中删除失败:"+res.getMsg());
//     return false;
    }

    @Override
    public void updateContractPoolSettle(RentMachineSettlementVO vo, boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSettleType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
//            if (type) {
//                totalSettleTaxMny = vo.getSettlementAmount() == null ? BigDecimal.ZERO : vo.getSettlementAmount();
//                totalSettleMny = vo.getSettlementNoTaxAmount() == null ? BigDecimal.ZERO : vo.getSettlementNoTaxAmount();
//                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
//            } else {//撤回删除本次结算金额
//                totalSettleTaxMny = ComputeUtil.safeSub(vo.getSettlementAmount(), vo.getTaxMny());
//                totalSettleMny = ComputeUtil.safeSub(vo.getTotalMny(), vo.getMny());
//                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
//            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSettleType()) { // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }

    @Override
    public CommonResponse<String> pushSettleToCost(RentMachineSettlementVO settleVO) {
        RentMachineSettlementEntity settleEntity = super.selectById(settleVO.getId());
        RentMachineSettlementVO vo = BeanMapper.map(settleEntity, RentMachineSettlementVO.class);
        String linkUrl = BaseHost + "ejc-proequipment-frontend/#/rentMachineSettlement/card?id=" + vo.getId();
        ExecutionVO executionVO = this.targetCost(vo,linkUrl);
        logger.info("手动推送 施工机械结算策划成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("手动推送 施工机械结算策划成本推送结果---:{}", JSONObject.toJSONString(response));
        return response;
    }

    @Override
    public ExecutionVO targetCost(RentMachineSettlementVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setMemo(settleVO.getMemo());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        totalVO.setBussinessType(BussinessTypeEnum.施工机械结算.getCode());
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());//结算
        if (settleVO.getProjectId()==null){
            throw new BusinessException("策划成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(settleVO.getProjectId());
        }
        if (settleVO.getOrgId()==null){
            throw new BusinessException("策划成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(settleVO.getOrgId());
        }
//        LambdaQueryWrapper<RentMachineSettlementEntity> query = new LambdaQueryWrapper<>();
//        query.eq(RentMachineSettlementEntity::getContractId, settleVO.getContractId());
//        query.in(RentMachineSettlementEntity::getBillState, 1,3);
//        query.eq(RentMachineSettlementEntity::getDr,0);
//        List<RentMachineSettlementEntity> entity = rentMachineSettlementService.list(query); // 过程结算
//        BigDecimal sumMny = BigDecimal.ZERO;//本期结算金额(无税)
//        BigDecimal sumTaxMny = BigDecimal.ZERO;//本期结算金额
//        RentContractEntity contractEntity = contractService.selectById(settleVO.getContractId());
//        for (RentMachineSettlementEntity settleEntity : entity){
//            sumMny = ComputeUtil.safeAdd(sumMny, settleEntity.getSettlementNoTaxAmount());
//            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, settleEntity.getSettlementAmount());
//        }
        totalVO.setMoney(settleVO.getSettlementAmount()); //
        totalVO.setTaxMoney(settleVO.getSettlementNoTaxAmount()); //
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);

        //明细
        for(RentMachineSettlementContentVO settleDetail:settleVO.getRentMachineSettlementContentList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(settleDetail.getId());
            // 来源主表id
            detailExecutionVO.setSourceBillId(settleVO.getId());
            detailExecutionVO.setCategoryId(settleDetail.getCategoryId()); // 档案分类ID
            // 根据档案id判断是否是分类
            detailExecutionVO.setCategoryFlag(settleDetail.getEquipmentId() == null);
            detailExecutionVO.setCategoryContainFlag(false);

            // 根据档案分类id查询档案分类信息
            if (null == settleDetail.getCategoryId()) {
                throw new BusinessException("档案分类id不能为空");
            }
            // 档案id
            if (settleDetail.getEquipmentId() == null) {
                throw new BusinessException("档案id不能为空");
            }
            detailExecutionVO.setDocId(settleDetail.getEquipmentId());
            detailExecutionVO.setName(settleDetail.getEquipmentName());
            detailExecutionVO.setUnitName(settleDetail.getRentalUnit());
            detailExecutionVO.setNum(settleDetail.getQuantity());
            detailExecutionVO.setTaxPrice(settleDetail.getPrice());
            detailExecutionVO.setPrice(settleDetail.getPrice());
            detailExecutionVO.setSpec(settleDetail.getSpec());
//            detailExecutionVO.setMemo(settleDetail.getMemo());
            detailExecutionVO.setMoney(settleDetail.getAmount());
            detailExecutionVO.setTaxMoney(settleDetail.getSettlementNoTaxAmount());

            detailExecutionVO.setContractId(settleVO.getContractId());
            detailExecutionVO.setLinkUrl(totalVO.getLinkUrl());
            detailExecutionVO.setBillDate(null != settleDetail.getCreateTime() ? sdf.format(settleDetail.getCreateTime()) : sdf.format(new Date()));
//            detailExecutionVO.setContractDetailId(settleDetail.getContractDetailId());
            detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());

            detailList.add(detailExecutionVO);
        }


        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public boolean pushSettleToPool(RentMachineSettlementVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            BeanConvertorUtil.convert(settleVO, poolVO);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(settleVO, poolVO);

            poolVO.setBillCodeUrl("/ejc-proequipment-frontend/#/rentMachineSettlement/card?id=" + settleVO.getId());
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", settleVO.getId());
                return true;
            } else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}", settleVO.getId(), res.getMsg());
                throw new BusinessException("结算单推送结算池失败:"+res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算-{}推送结算池失败，", settleVO.getId(), e);
            throw new BusinessException("结算单推送结算池失败!");
        }
    }

    private void convertSettleVOToSettlePoolVO(RentMachineSettlementVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.安拆合同过程结算.getCode() : SettleSourceTypeEnum.安拆合同最终结算.getCode());
        poolVO.setSettleProperty(0);// 属性类型：支出
        poolVO.setHandleType(0);
//        poolVO.setLastTaxMny(settleVO.getLastTaxMny());// 累计结算金额（含税）
//        poolVO.setLastMny(settleVO.getLastMny());// 累计结算金额（无税）
//        poolVO.setLastTax(getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));// 累计结算税额
        poolVO.setContractType(ContractTypeEnum.安拆合同.getTypeCode());
        poolVO.setBillStateName(BillStateEnum.getEnumByStateCode(poolVO.getBillState()).getDescription());
        RentContractEntity ce = contractService.selectById(settleVO.getContractId());
        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", settleVO.getContractId());
        if (ce == null) {
            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", settleVO.getContractId());
            return;
        }
        // 主合同
        poolVO.setContractFlag(1);// 是否有合同：1-是，0-否
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setContractTypeName(ContractTypeEnum.安拆合同.getTypeName());
        poolVO.setSupplementFlag(ce.getSupplementFlag());//合同类别
        poolVO.setMemo(ce.getMemo());//合同类别
        // 甲方
        poolVO.setPartyaId(ce.getPartyId());
        poolVO.setPartyaName(ce.getPartyName());
        // 签订日期
        poolVO.setSignDate(ce.getSignedDate());
        // 创建时间和人员 使用 结算单的创建时间和人员
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void costPush(RentMachineSettlementEntity entity) {
        logger.info("开始costPush");
        List<RentMachineSettlementContentEntity> contentList = entity.getRentMachineSettlementContentList();

        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(contentList)) {
            for (RentMachineSettlementContentEntity detailEntity : contentList) {
                if (null == detailEntity.getSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }

        //ListUtil.isEmpty(feeList) &&
        if (ListUtil.isEmpty(contentList)) {
            newRelationFlag = "0";
        }

        //先删后增
        saveCost(entity,1);
        //更新是否关联
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<RentMachineSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(RentMachineSettlementEntity::getId, entity.getId());
        updateWrapper.set(RentMachineSettlementEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }


    private void saveCost(RentMachineSettlementEntity entity, Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<RentMachineSettlementContentEntity> contentList = entity.getRentMachineSettlementContentList();

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(contentList)) {
            for (RentMachineSettlementContentEntity detailEntity : contentList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getAmount());
                costDetailVO.setHappenMny(detailEntity.getSettlementNoTaxAmount());
                //TODO Type需要更改
                costDetailVO.setSourceTabType("RE_EQ_JS_SETTLE");
//                costDetailVO.setWbsId(detailEntity.getWbsIdFragmentary());
//                costDetailVO.setWbsCode(detailEntity.getWbsCodeFragmentary());
//                costDetailVO.setWbsName(detailEntity.getWbsNameFragmentary());
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getSubjectName());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName("施工机械结算");
                costDetailVO.setSourceBillUrl("/ejc-proequipment-frontend/#/rentMachineSettlement/card?id=" + entity.getId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("TEMP_EQ_JS");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("施工机械结算推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                logger.info("推送实际成本失败--------"+stringCommonResponse.getMsg());
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

}
