package com.ejianc.business.temporary.contract.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;

import java.util.List;
import java.util.Map;

/**
 * 临时设备租赁合同
 * 
 * @author generator
 * 
 */
public interface ITemporaryContractService extends IBaseService<TemporaryContractEntity> {
    /**
     * 补充协议
     * @param temporaryContractVO
     */
    public TemporaryContractVO saveOrUpdateSupplement(TemporaryContractVO temporaryContractVO);

    public TemporaryContractVO addConvertByConId(Long contractId);

    public Boolean addSupplementFlag(Long id);

    public Map<String, Object> countContractAmount(QueryParam param);

    public TemporaryContractVO querySupplementRecord(Long id);

    public Boolean delContractFile(Long contractFileId, String authority);

    /**
     * 删除
     * @param vos
     * @return
     */
    public CommonResponse<String> deleteByIds(List<TemporaryContractVO> vos);

    /**
     * 查询编码是否重复
     * @param code
     * @return
     */
    public TemporaryContractEntity selectCode(String code);
    /**
     * 推送合同池
     *
     * @param contractVO 需要推送的合同数据
     */
    void pushContract(TemporaryContractVO contractVO);

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    void pushDelContract(TemporaryContractVO contractVO);

    TemporaryContractVO insertOrUpdate(TemporaryContractVO saveOrUpdateVO, String authority, boolean isControl);

//    ParamsCheckVO targetCostCtrl(TemporaryContractVO contractVO, String authority);
//
//    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    TemporaryContractVO queryDetail(Long id);

    /**
     * 是否可以添加合同解除
     *
     * @param id
     * @return
     */
}
