package com.ejianc.business.temporary.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.ac.vo.ContractVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.rent.bean.*;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.temporary.contract.bean.*;
import com.ejianc.business.temporary.contract.mapper.TemporaryClauseMapper;
import com.ejianc.business.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.temporary.contract.mapper.TemporaryContractMapper;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 临时设备租赁合同
 * 
 * @author generator
 * 
 */
@Service("temporaryContractService")
public class TemporaryContractServiceImpl extends BaseServiceImpl<TemporaryContractMapper, TemporaryContractEntity> implements ITemporaryContractService{
    @Value("${common.env.base-host}")
    private String BaseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private TemporaryContractMapper contractMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ITemporaryContractService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "TEMPORARY_CONTRACT";//此处需要根据实际修改


    @Override
    public TemporaryContractVO saveOrUpdateSupplement(TemporaryContractVO temporaryContractVO) {
        TemporaryContractEntity entity = null;

        if(temporaryContractVO.getId() == null){

            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", temporaryContractVO.getMainContractId()));
            List<TemporaryContractEntity> supplementList =this.queryList(param,false);
            if(CollectionUtils.isNotEmpty(supplementList)){
                for (TemporaryContractEntity temporaryContract:supplementList){
                    if(!(temporaryContract.getSignatureState().equals(SignatureStatusEnum.已签章.getCode()) &&
                            (temporaryContract.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                    || temporaryContract.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                        //存在未生效的补充协议
                        throw new BusinessException("该合同已存在未生效的补充协议!");
                    }
                }
            }
            //设置补充协议编码
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }else {
                supplementNum += (supplementList.size() + 1);
            }

            //主合同
            TemporaryContractEntity mainContract = this.selectById(temporaryContractVO.getMainContractId());
            if(null == mainContract) {
                throw new BusinessException("未找到主合同，不能创建补充协议！");
            }

            entity = BeanMapper.map(mainContract, TemporaryContractEntity.class);
            clearBaseFields(entity);
            entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setCode(entity.getCode() + "2" + supplementNum);

            entity.setName(temporaryContractVO.getName());
            entity.setSignedDate(temporaryContractVO.getSignedDate());//签订日期
            entity.setPartyHandleUser(temporaryContractVO.getPartyHandleUser());
            entity.setPartyHandleUserName(temporaryContractVO.getPartyHandleUserName());
            entity.setPartyPhone(temporaryContractVO.getPartyPhone());
            entity.setSupplierHandleUser(temporaryContractVO.getSupplierHandleUser());
            entity.setSupplierPhone(temporaryContractVO.getSupplierPhone());
            entity.setContractPerformanceState(temporaryContractVO.getContractPerformanceState());

            entity.setDraftType(temporaryContractVO.getDraftType());
            //设置文件路径
            entity.setContractFile(temporaryContractVO.getContractFile());
            entity.setContractFileId(temporaryContractVO.getContractFileId());



            entity.setSupplementDescribe(temporaryContractVO.getSupplementDescribe());

            //补充金额明细
            entity.setContractTaxMny(temporaryContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : temporaryContractVO.getContractTaxMny());
            entity.setContractMny(temporaryContractVO.getContractMny() == null ? BigDecimal.ZERO : temporaryContractVO.getContractMny());
            entity.setContractTax(temporaryContractVO.getContractTax() == null ? BigDecimal.ZERO : temporaryContractVO.getContractTax());


            //子表
            entity.setTemporaryClauseList(BeanMapper.mapList(temporaryContractVO.getTemporaryClauseList(), TemporaryClauseEntity.class));
            entity.setTemporaryPaymentClauseList(BeanMapper.mapList(temporaryContractVO.getTemporaryPaymentClauseList(), TemporaryPaymentClauseEntity.class));
            entity.setTemporaryEquipmentDetailedList(BeanMapper.mapList(temporaryContractVO.getTemporaryEquipmentDetailedList(), TemporaryEquipmentDetailedEntity.class));
            entity.setTemporaryOtherList(BeanMapper.mapList(temporaryContractVO.getTemporaryOtherList(), TemporaryOtherEntity.class));

            //初始化变更字段
            entity.setChangingTax(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setContractName(mainContract.getContractName()+"——补充协议");

            //补充协议状态
            entity.setSupplementFlag(1);
            entity.setMainContractId(temporaryContractVO.getMainContractId());
            entity.setMainContractCode(temporaryContractVO.getMainContractCode());
            entity.setMainContractName(temporaryContractVO.getMainContractName());
        } else {
            entity = BeanMapper.map(temporaryContractVO, TemporaryContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getBeforeChangeMny());
        entity.setBeforeChangeTaxMny(entity.getBeforeChangeTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(temporaryContractVO.getAttachIds());

        //保存前清空主键和父主键，重新生成

        this.saveOrUpdate(entity, false);
        TemporaryContractEntity entity1= selectById(entity.getId());
        TemporaryContractVO vo = BeanMapper.map(entity1, TemporaryContractVO.class);
        return vo;
    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(TemporaryContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    @Override
    public TemporaryContractVO addConvertByConId(Long contractId) {
        TemporaryContractEntity entity = super.selectById(contractId);
        TemporaryContractVO supplementVO = new TemporaryContractVO();
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());//主合同名称
        supplementVO.setSupplementFlag(RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        /*supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());*/
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setName(entity.getContractName() + "补充协议");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setTaxRate(entity.getTaxRate());
        supplementVO.setSignedDate(new Date());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper<TemporaryContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(TemporaryContractEntity::getMainContractId, id);
        lambda.eq(TemporaryContractEntity::getSupplementFlag, RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(TemporaryContractEntity::getSignatureState, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(TemporaryContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())).or(c -> c.eq(TemporaryContractEntity::getContractPerformanceState, String.valueOf(ContractPerformanceStateEnum.已作废.getStateCode()))));
        List<TemporaryContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(contract_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public TemporaryContractVO querySupplementRecord(Long id) {
        TemporaryContractEntity contractEntity = super.selectById(id);
        TemporaryContractVO contractVO = new TemporaryContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper<TemporaryContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("contract_performance_state", ContractPerformanceStateEnum.履约中.getStateCode());
        query.orderByDesc("create_time");
        List<TemporaryContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, TemporaryContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)){
            for (TemporaryContractEntity c : supplementEntities){
                if (c.getContractTaxMny() != null){
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState())))){
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    /**
     * 删除
     * @param vos
     * @return
     */
    public CommonResponse<String> deleteByIds(List<TemporaryContractVO> vos) {
        this.removeByIds(vos.stream().map(TemporaryContractVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }


    @Override
    public TemporaryContractEntity selectCode(String code) {
        QueryWrapper<TemporaryContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", code);
        queryWrapper.eq("dr","0");
        List<TemporaryContractEntity> list =contractMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
    /**
     * 推送合同项目池
     *
     * @param contractVO 需要推送的合同数据
     */
    @Override
    public void pushContract(TemporaryContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.临时设备.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            data.setPcCardUrl("/ejc-proequipment-frontend/#/rentalTemporary/card?id="
                    + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag()
                    + "&targetType=" + contractVO.getCalibrationResultId() + "&performanceStatus="
                    + contractVO.getContractPerformanceState());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    @Override
    public void pushDelContract(TemporaryContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.临时设备.getTypeCode());
            logger.info("开始删除合同池合同>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<String> transDataResp = contractPoolApi.deleteContract(data);
            logger.info("删除合同池合同结束，删除结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public TemporaryContractVO insertOrUpdate(TemporaryContractVO saveOrUpdateVO, String authority, boolean isControl) {
        TemporaryContractEntity entity = BeanMapper.map(saveOrUpdateVO, TemporaryContractEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            if (!isControl){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
                    entity.setSupplementFlag(0);
                    entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                    entity.setMainContractCreateDate(new Date());
                    if(StringUtils.isEmpty(entity.getCode())){
                        entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    }
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else {
                entity.setId(IdWorker.getId());
                entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                entity.setMainContractCreateDate(new Date());
            }
        }else{
        }
        //设置合同初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (entity.getContractFileId() != null && !isControl) {
            if (entity.getId() != null) {
                TemporaryContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            }
        }

        TemporaryContractEntity vContractEntity =service.selectCode(entity.getCode());
        if(vContractEntity != null){
            if(saveOrUpdateVO.getId() == null){
                throw new BusinessException("合同编码不能重复:"+entity.getCode());
            }else{
                if(!saveOrUpdateVO.getId().equals(vContractEntity.getId())){
                    throw new BusinessException("合同编码不能重复:"+entity.getCode());
                }
            }
        }
        if (!isControl){
            service.saveOrUpdate(entity, false);
        }
        TemporaryContractVO vo = BeanMapper.map(entity, TemporaryContractVO.class);
        return vo;
    }
//    @Override
//    public ParamsCheckVO targetCostCtrl(TemporaryContractVO contractVO, String authority) {
//        TemporaryContractVO contractVO1 = insertOrUpdate(contractVO,authority, true);
//        ExecutionVO executionVO = targetCost(BeanMapper.map(contractVO1, PurchaseContractVO.class), BILL_TYPE, linkUrl);
//        logger.info("策划成本推送数据" + JSON.toJSONString(executionVO));
//        logger.error("ss" + JSONObject.toJSONString(executionVO));
//        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//        return response.getData();
//    }
//
//    @Override
//    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
//        TemporaryContractVO contractVO = queryDetail(id);
//        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO, PurchaseContractVO.class), BILL_TYPE, linkUrl);
//        logger.error("ss" + JSONObject.toJSONString(executionVO));
//        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//        return response.getData();
//    }

    @Override
    public TemporaryContractVO queryDetail(Long id) {
        TemporaryContractEntity entity = service.selectById(id);
        TemporaryContractVO vo = BeanMapper.map(entity, TemporaryContractVO.class);
        return vo;
    }
}
