package com.ejianc.business.temporary.useapply.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.temporary.useapply.bean.TemporaryUseApplySubEntity;
import com.ejianc.business.temporary.useapply.service.ITemporaryUseApplySubService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.temporary.useapply.bean.TemporaryUseApplyEntity;
import com.ejianc.business.temporary.useapply.service.ITemporaryUseApplyService;
import com.ejianc.business.temporary.useapply.vo.TemporaryUseApplyVO;

/**
 * 临时设备使用申请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("temporaryUseApply")
public class TemporaryUseApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LS_USE_APPLY";//此处需要根据实际修改

    @Autowired
    private ITemporaryUseApplyService service;

    @Autowired
    private ITemporaryUseApplySubService temporaryUseApplySubService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemporaryUseApplyVO> saveOrUpdate(@RequestBody TemporaryUseApplyVO saveOrUpdateVO) {
    	TemporaryUseApplyEntity entity = BeanMapper.map(saveOrUpdateVO, TemporaryUseApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setRecordFlag(2);// 是否被记录引用 1-是 2-否
    	service.saveOrUpdate(entity, false);
    	TemporaryUseApplyVO vo = BeanMapper.map(entity, TemporaryUseApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryUseApplyVO> queryDetail(Long id) {
    	TemporaryUseApplyEntity entity = service.selectById(id);
    	TemporaryUseApplyVO vo = BeanMapper.map(entity, TemporaryUseApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryUseApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TemporaryUseApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TemporaryUseApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemporaryUseApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<TemporaryUseApplyEntity> page = service.queryPage(param,false);
        IPage<TemporaryUseApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryUseApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TemporaryUseApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TemporaryUseApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTemporaryUseApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemporaryUseApplyVO>> refTemporaryUseApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("contractName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("recordFlag", new Parameter(QueryParam.EQ, 2));//未被引用的
        List<Integer> integers = new ArrayList<>();
        integers.add(1);
        integers.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, integers));//未被引用的
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String,Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }else {
                return CommonResponse.error("未传入项目id！",null);
            }
        }
        IPage<TemporaryUseApplyEntity> page = service.queryPage(param,false);
        IPage<TemporaryUseApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<TemporaryUseApplyEntity> records = page.getRecords();
        if(CollectionUtils.isNotEmpty(records)) {
            List<Long> collect = records.stream().map(t -> t.getId()).collect(Collectors.toList());
            LambdaQueryWrapper<TemporaryUseApplySubEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(TemporaryUseApplySubEntity::getPid, collect);
            List<TemporaryUseApplySubEntity> detail = temporaryUseApplySubService.list(wrapper);
            if (CollectionUtils.isNotEmpty(detail)) {
                Map<Long, List<TemporaryUseApplySubEntity>> detailMap = detail.stream().collect(Collectors.groupingBy(TemporaryUseApplySubEntity::getPid));
                for (TemporaryUseApplyEntity record : records) {
                    if(detailMap.containsKey(record.getId())){
                        record.getTemporaryUseApplySubList().addAll(detailMap.get(record.getId()));
                    }
                }
            }
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryUseApplyVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
