package com.ejianc.business.tool.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.tool.bean.BorrowContentEntity;
/**
 * 工机具借用
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_borrow")
public class BorrowEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="borrow_date")
    private Date borrowDate; // 借用日期
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="borrow_name")
    private String borrowName; // 借用人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="borrow_part")
    private String borrowPart; // 借用人部门
    @TableField(value = "bill_name")
    private String billName;
    @TableField(value="store_id")
    private Long storeId; //
    @TableField(value = "store_name")
    private String storeName;


    @TableField(exist=false)
    @SubEntity(serviceName="borrowContentService",pidName = "borrowId")
    private List<BorrowContentEntity> detailList = new ArrayList<>(); // 工机具借用子表



    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBorrowDate() {
        return borrowDate;
    }

    public void setBorrowDate(Date borrowDate) {
        this.borrowDate = borrowDate;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBorrowName() {
        return borrowName;
    }

    public void setBorrowName(String borrowName) {
        this.borrowName = borrowName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBorrowPart() {
        return borrowPart;
    }

    public void setBorrowPart(String borrowPart) {
        this.borrowPart = borrowPart;
    }
    

    public List<BorrowContentEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BorrowContentEntity> detailList) {
        this.detailList = detailList;
    }
}
