package com.ejianc.business.tool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tool.bean.RequireApplicationDetailEntity;
import com.ejianc.business.tool.bean.RequireApplicationEntity;
import com.ejianc.business.tool.service.IRequireApplicationDetailService;
import com.ejianc.business.tool.service.IRequireApplicationService;
import com.ejianc.business.tool.service.IRequireRecordDetailService;
import com.ejianc.business.tool.vo.RequireApplicationDetailVO;
import com.ejianc.business.tool.vo.RequireApplicationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工机具维修申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("requireApplication")
public class RequireApplicationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "REQUIRE-APPLICATION";//此处需要根据实际修改

    @Autowired
    private IRequireApplicationService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRequireRecordDetailService requireRecordDetailService;

    @Autowired
    private IRequireApplicationDetailService requireApplicationDetailService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RequireApplicationVO> saveOrUpdate(@RequestBody RequireApplicationVO saveOrUpdateVO) {
    	RequireApplicationEntity entity = BeanMapper.map(saveOrUpdateVO, RequireApplicationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RequireApplicationVO vo = BeanMapper.map(entity, RequireApplicationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RequireApplicationVO> queryDetail(Long id) {
    	RequireApplicationEntity entity = service.selectById(id);
    	RequireApplicationVO vo = BeanMapper.map(entity, RequireApplicationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RequireApplicationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (RequireApplicationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RequireApplicationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RequireApplicationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<RequireApplicationEntity> page = service.queryPage(param,false);
        IPage<RequireApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RequireApplicationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<RequireApplicationEntity> pageData = service.queryPage(param, false);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<RequireApplicationVO> list = BeanMapper.mapList(pageData.getRecords(), RequireApplicationVO.class);
            list.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("RequireApplication-export.xlsx", beans, response);
        }
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refApplication", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RequireApplicationVO>> refRequireApplicationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getString("projectId")));
            }
            if (condition.contains("storeId")) {
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, _con.getString("storeId")));
            }
        }
        IPage<RequireApplicationEntity> page = service.queryPage(param,false);
        List<Long> ids=new ArrayList<>();
        page.getRecords().forEach(entity -> {
            ids.add(entity.getId());
                });
        List<RequireApplicationDetailVO> requireApplicationDetailVOS = service.selectDetailList(ids);
        if (requireApplicationDetailVOS != null || requireApplicationDetailVOS.size() != 0){
            Map<Long,Integer> num=requireApplicationDetailVOS.stream().filter(s->s.getRemainderNum() != null).collect(Collectors.groupingBy(RequireApplicationDetailVO::getId,Collectors.summingInt(RequireApplicationDetailVO::getRemainderNum)));
            if (num!= null && num.size() > 0){
                ids.clear();
                Iterator<Map.Entry<Long, Integer>> iterator = num.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, Integer> entry = iterator.next();
                    if (entry.getValue()>0)
                        ids.add(entry.getKey());
                }
            }
        }
        if (ids.size() == 0){
            return CommonResponse.success("查询参照数据成功！",new Page<>());
        }else{
            param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        }
        IPage<RequireApplicationEntity> newPage = service.queryPage(param, false);
        IPage<RequireApplicationVO> pageData = new Page<>(newPage.getCurrent(), newPage.getSize(), newPage.getTotal());
        pageData.setRecords(BeanMapper.mapList(newPage.getRecords(), RequireApplicationVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/selectDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RequireApplicationDetailVO>> selectDetailList(@RequestParam ArrayList<Long> pid) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter(QueryParam.IN, pid));
        IPage<RequireApplicationDetailEntity> page = requireApplicationDetailService.queryPage(param, false);
        IPage<RequireApplicationDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RequireApplicationDetailVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
