package com.ejianc.business.tool.controller;

import java.io.Serializable;

import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.out.vo.ClaimTypeEnum;
import com.ejianc.business.promaterial.out.vo.OutStoreSubVO;
import com.ejianc.business.promaterial.out.vo.OutStoreVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.tool.service.impl.ScrapContentBpmServiceImpl;
import com.ejianc.business.tool.vo.ReturnVO;
import com.ejianc.business.tool.vo.ScrapContentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import groovy.util.logging.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tool.bean.ScrapEntity;
import com.ejianc.business.tool.service.IScrapService;
import com.ejianc.business.tool.vo.ScrapVO;

/**
 * 工机具报废
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scrap")
@Slf4j
public class ScrapController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ScrapController.class);

    //private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCRAP";//此处需要根据实际修改

    @Autowired
    private IScrapService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private ScrapContentBpmServiceImpl impl;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScrapVO> saveOrUpdate(@RequestBody ScrapVO saveOrUpdateVO) {

        if(CollectionUtils.isEmpty(saveOrUpdateVO.getDetailList())) {
            throw new BusinessException("子表数据不能为空!");
        }else{
            List<ScrapContentVO> list = new ArrayList<>();
            saveOrUpdateVO.getDetailList().forEach(e->{
                if(!"del".equals(e.getRowState())){
                    list.add(e);
                }
            });
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("子表数据不能为空!");
            }
        }

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
        ScrapEntity entity = BeanMapper.map(saveOrUpdateVO, ScrapEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

        //调用库存逻辑
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
        storeManageVO.setOutEffectiveON(false);
//        storeManageVO.setSourceIdsForRollBack();
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        //循环删除的数据
        saveOrUpdateVO.getDetailList().forEach(t->{
            if("del".equals(t.getRowState())){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
                flowVO.setStoreId(saveOrUpdateVO.getStoreId());
                flowVO.setStoreName(saveOrUpdateVO.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(saveOrUpdateVO.getEmployeeId());
                flowVO.setEmployeeName(saveOrUpdateVO.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getToolId());
                flowVO.setMaterialCode(t.getToolCode());
                flowVO.setMaterialName(t.getToolName());
                flowVO.setMaterialSpec(t.getSpecs());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setNum(t.getNum());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getScrapDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("BT220215000000004");
                flowVO.setSourceBillTypeName("领料出库");
                flowVO.setSourceType(1);//  0-自制,1-订单
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVOS.add(flowVO);
            }
        });
        //循环新增修改的数据
        entity.getDetailList().forEach(t->{
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
            flowVO.setStoreId(saveOrUpdateVO.getStoreId());
            flowVO.setStoreName(saveOrUpdateVO.getStoreName());
            flowVO.setProjectId(entity.getProjectId());
            flowVO.setProjectName(entity.getProjectName());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setParentOrgId(entity.getParentOrgId());
            flowVO.setParentOrgName(entity.getParentOrgName());
            flowVO.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            flowVO.setEmployeeName(saveOrUpdateVO.getEmployeeName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getToolId());
            flowVO.setMaterialCode(t.getToolName());
            flowVO.setMaterialName(t.getToolCode());
            flowVO.setMaterialSpec(t.getSpecs());
            flowVO.setMaterialUnitId(t.getUnitId());
            flowVO.setMaterialUnitName(t.getUnit());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setNum(t.getNum());
            flowVO.setSourceId(entity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(entity.getBillCode());
            flowVO.setSourceBillTypeCode("BT220215000000004");
            flowVO.setSourceBillTypeName("领料出库");
            flowVO.setSourceType(1);//  0-自制,1-订单
            flowVO.setSourceBillDate(entity.getScrapDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(entity.getMemo());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        //logger.debug("参数：————"+JSONObject.toJSONString(storeManageVO));
        log.info("参数：————"+JSONObject.toJSONString(storeManageVO));
        CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
        if(!response.isSuccess()) {
            throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
        }

    	ScrapVO vo = BeanMapper.map(entity, ScrapVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScrapVO> queryDetail(Long id) {
    	ScrapEntity entity = service.selectById(id);
    	ScrapVO vo = BeanMapper.map(entity, ScrapVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

//    @RequestMapping(value = "/queryDetail1", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<ScrapVO> queryDetail1() {
//        impl.afterApprovalProcessor(970707164341473317L, null, null);
//        return null;
//    }



    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScrapVO> vos) {

        Collection<ScrapEntity> list = service.listByIds(vos.stream().map(ScrapVO::getId).collect(Collectors.toList()));
        Map<Long,List<Long>> map = new HashMap<>();
        list.forEach(e->{
            if(map.containsKey(e.getStoreId())){
                map.get(e.getStoreId()).add(e.getId());
            }else{
                List<Long> idList = new ArrayList<>();
                idList.add(e.getId());
                map.put(e.getStoreId(),idList);
            }
            //删除实际成本
            if(e.getAttrFlag()!=null && e.getAttrFlag() != 2) {//仓库属性 1-自购材；2-甲供材
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(e.getId());
                //logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
        });
        map.forEach((key, value) -> {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(key);
            storeManageVO.setSourceIdsForRollBack(value);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
            storeManageVO.setOutEffectiveON(false);
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        });
        service.removeByIds(vos.stream().map(ScrapVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScrapVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","employeeName","billName"));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ScrapEntity> page = service.queryPage(param,false);
        IPage<ScrapVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScrapVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","projectName","employeeName","billName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ScrapEntity> entityList = service.queryList(param);
        List<ScrapVO> list = BeanMapper.mapList(entityList, ScrapVO.class);
        list.forEach(vo -> {
            Integer billState = vo.getBillState();
            if(billState != null){
                BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                if (billStateEnum != null) {
                    vo.setBillStateName(billStateEnum.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Scrap-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refScrapData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScrapVO>> refScrapData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScrapEntity> page = service.queryPage(param,false);
        IPage<ScrapVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScrapVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
