/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pricelib.bean.RentPriceContractEntity;
import com.ejianc.business.pricelib.bean.RentPriceGuideDetailEntity;
import com.ejianc.business.pricelib.mapper.RentPriceContractMapper;
import com.ejianc.business.pricelib.service.IRentPriceContractService;
import com.ejianc.business.pricelib.service.IRentPriceGuideDetailService;
import com.ejianc.business.pricelib.vo.PriceLibVO;
import com.ejianc.business.pricelib.vo.PriceTrendVo;
import com.ejianc.business.pricelib.vo.RentPriceContractVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.enums.OutFlagEnum;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentPriceContractService")
public class RentPriceContractServiceImpl
extends BaseServiceImpl<RentPriceContractMapper, RentPriceContractEntity>
implements IRentPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IRentPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IRentSettlementService settleService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceLibList.size());
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public void savePriceContractByTiming(Date date) {
        List<RentQuantitiesDetailedEntity> list;
        List<RentMonthDetailedEntity> monthDetailEntityList;
        List<RentContractEntity> contractEntityList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((RentPriceContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            contractEntityList = this.contractService.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty(contractEntityList)) {
            return;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList<RentPriceContractVO> detailVOList = new ArrayList<RentPriceContractVO>();
        List<RentDayDetailedEntity> dayDetailEntityList = ((RentPriceContractMapper)this.baseMapper).getDayDetailListByContractId(contractIdList);
        if (CollectionUtils.isNotEmpty(dayDetailEntityList)) {
            for (RentDayDetailedEntity rentDayDetailedEntity : dayDetailEntityList) {
                RentPriceContractVO rentPriceContractVO = new RentPriceContractVO();
                rentPriceContractVO.setContractId(rentDayDetailedEntity.getPid());
                rentPriceContractVO.setId(rentDayDetailedEntity.getId());
                rentPriceContractVO.setSourceId(rentDayDetailedEntity.getId());
                rentPriceContractVO.setContractTaxRate(rentDayDetailedEntity.getTax());
                rentPriceContractVO.setContractNum(new BigDecimal(rentDayDetailedEntity.getRentNum()));
                rentPriceContractVO.setContractPrice(rentDayDetailedEntity.getDayRentNotTaxPrice());
                rentPriceContractVO.setContractTaxPrice(rentDayDetailedEntity.getDayRentPrice());
                rentPriceContractVO.setContractMny(rentDayDetailedEntity.getRentMny());
                rentPriceContractVO.setContractTaxMny(rentDayDetailedEntity.getRentTaxMny());
                rentPriceContractVO.setMemo(rentDayDetailedEntity.getMemo());
                rentPriceContractVO.setSpec(rentDayDetailedEntity.getSpec());
                rentPriceContractVO.setManufacturer(rentDayDetailedEntity.getProductionManufactor());
                rentPriceContractVO.setDocId(rentDayDetailedEntity.getEquipmentId());
                rentPriceContractVO.setDocCode(rentDayDetailedEntity.getEquipmentCode());
                rentPriceContractVO.setDocName(rentDayDetailedEntity.getName());
                rentPriceContractVO.setDocCategoryId(rentDayDetailedEntity.getCategoryId());
                rentPriceContractVO.setDocCategoryName(rentDayDetailedEntity.getCategoryName());
                rentPriceContractVO.setUnitName(rentDayDetailedEntity.getUnitName());
                rentPriceContractVO.setRentType(Integer.valueOf(1));
                detailVOList.add(rentPriceContractVO);
            }
        }
        if (CollectionUtils.isNotEmpty(monthDetailEntityList = ((RentPriceContractMapper)this.baseMapper).getMonthDetailListByContractId(contractIdList))) {
            for (RentMonthDetailedEntity rentMonthDetailedEntity : monthDetailEntityList) {
                RentPriceContractVO contractDetailedVO = new RentPriceContractVO();
                contractDetailedVO.setContractId(rentMonthDetailedEntity.getPid());
                contractDetailedVO.setId(rentMonthDetailedEntity.getId());
                contractDetailedVO.setSourceId(rentMonthDetailedEntity.getId());
                contractDetailedVO.setContractTaxRate(rentMonthDetailedEntity.getTax());
                contractDetailedVO.setContractNum(new BigDecimal(rentMonthDetailedEntity.getRentNum()));
                contractDetailedVO.setContractPrice(rentMonthDetailedEntity.getMonthRentNotTaxPrice());
                contractDetailedVO.setContractTaxPrice(rentMonthDetailedEntity.getMonthRentPrice());
                contractDetailedVO.setContractMny(rentMonthDetailedEntity.getRentMny());
                contractDetailedVO.setContractTaxMny(rentMonthDetailedEntity.getRentTaxMny());
                contractDetailedVO.setMemo(rentMonthDetailedEntity.getMemo());
                contractDetailedVO.setSpec(rentMonthDetailedEntity.getSpec());
                contractDetailedVO.setManufacturer(rentMonthDetailedEntity.getProductionManufactor());
                contractDetailedVO.setDocId(rentMonthDetailedEntity.getEquipmentId());
                contractDetailedVO.setDocCode(rentMonthDetailedEntity.getEquipmentCode());
                contractDetailedVO.setDocName(rentMonthDetailedEntity.getName());
                contractDetailedVO.setDocCategoryId(rentMonthDetailedEntity.getCategoryId());
                contractDetailedVO.setDocCategoryName(rentMonthDetailedEntity.getCategoryName());
                contractDetailedVO.setUnitName(rentMonthDetailedEntity.getUnitName());
                contractDetailedVO.setRentType(Integer.valueOf(2));
                detailVOList.add(contractDetailedVO);
            }
        }
        if (CollectionUtils.isNotEmpty(list = ((RentPriceContractMapper)this.baseMapper).getQuantitiesDetailListByContractId(contractIdList))) {
            for (RentQuantitiesDetailedEntity quantitiesDetail : list) {
                RentPriceContractVO contractDetailedVO = new RentPriceContractVO();
                contractDetailedVO.setContractId(quantitiesDetail.getPid());
                contractDetailedVO.setId(quantitiesDetail.getId());
                contractDetailedVO.setSourceId(quantitiesDetail.getId());
                contractDetailedVO.setContractTaxRate(quantitiesDetail.getTax());
                contractDetailedVO.setContractNum(new BigDecimal(quantitiesDetail.getRentNum()));
                contractDetailedVO.setContractPrice(quantitiesDetail.getNotTaxQuantitiesPrice());
                contractDetailedVO.setContractTaxPrice(quantitiesDetail.getQuantitiesPrice());
                contractDetailedVO.setContractMny(quantitiesDetail.getRentMny());
                contractDetailedVO.setContractTaxMny(quantitiesDetail.getRentTaxMny());
                contractDetailedVO.setMemo(quantitiesDetail.getMemo());
                contractDetailedVO.setSpec(quantitiesDetail.getSpec());
                contractDetailedVO.setManufacturer(quantitiesDetail.getProductionManufactor());
                contractDetailedVO.setDocId(quantitiesDetail.getEquipmentId());
                contractDetailedVO.setDocCode(quantitiesDetail.getEquipmentCode());
                contractDetailedVO.setDocName(quantitiesDetail.getName());
                contractDetailedVO.setDocCategoryId(quantitiesDetail.getCategoryId());
                contractDetailedVO.setDocCategoryName(quantitiesDetail.getCategoryName());
                contractDetailedVO.setUnitName(quantitiesDetail.getUnitName());
                contractDetailedVO.setRentType(Integer.valueOf(3));
                detailVOList.add(contractDetailedVO);
            }
        }
        if (CollectionUtils.isEmpty(detailVOList)) {
            return;
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contract_id", new Parameter("in", contractIdList));
        queryParam2.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam2.getParams().put("settlement_type", new Parameter("eq", (Object)SettleTypeEnum.\u5b8c\u5de5.getCode()));
        List settleList = this.settleService.queryList(queryParam2);
        Map<Object, Object> settleDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settleList)) {
            settleDateMap = settleList.stream().collect(Collectors.toMap(RentSettlementEntity::getContractId, RentSettlementEntity::getSettlementDate, (key1, key2) -> key2));
        }
        List docCategoryIdList = detailVOList.stream().map(RentPriceContractVO::getDocCategoryId).distinct().collect(Collectors.toList());
        List docIs = detailVOList.stream().filter(item -> null != item.getContractNum()).map(RentPriceContractVO::getDocId).distinct().collect(Collectors.toList());
        CommonResponse equipmentDocResponse = this.shareEquipmentApi.queryCategoryListByIds(docCategoryIdList);
        Map<Object, Object> docCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)equipmentDocResponse));
        if (equipmentDocResponse.isSuccess()) {
            List equipmentDocCategoryVOList = (List)equipmentDocResponse.getData();
            docCategoryMap = equipmentDocCategoryVOList.stream().collect(Collectors.toMap(EquipmentCategoryVO::getId, EquipmentCategoryVO::getInnerCode, (key1, key2) -> key2));
            CommonResponse equipmentDocItemResponse = this.shareEquipmentApi.queryEquipmentItemByIds(docIs);
            if (equipmentDocItemResponse.isSuccess()) {
                this.logger.info("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u6e05\u5355\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)equipmentDocItemResponse.getData()));
            } else {
                this.logger.error("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)equipmentDocItemResponse));
            }
        } else {
            this.logger.error("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u4fe1\u5206\u7c7b\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)equipmentDocResponse));
        }
        List projectIdList = contractEntityList.stream().map(RentContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<RentPriceContractVO>> detailMap = detailVOList.stream().collect(Collectors.groupingBy(RentPriceContractVO::getContractId));
        ArrayList<RentPriceContractEntity> saveEntityList = new ArrayList<RentPriceContractEntity>();
        for (RentContractEntity entity : contractEntityList) {
            List<RentPriceContractVO> detailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(detailList)) continue;
            for (RentPriceContractVO rentPriceContractVO : detailList) {
                if (rentPriceContractVO.getDocId() == null) continue;
                RentPriceContractEntity rentPriceContractEntity = (RentPriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), RentPriceContractEntity.class));
                rentPriceContractEntity.setSettlementDate((Date)settleDateMap.get(entity.getId()));
                rentPriceContractEntity.setContractId(entity.getId());
                rentPriceContractEntity.setContractName(entity.getContractName());
                rentPriceContractEntity.setContractCode(entity.getContractCode());
                rentPriceContractEntity.setSignDate(entity.getSignedDate());
                rentPriceContractEntity.setPerformanceStatus(entity.getContractPerformanceState());
                rentPriceContractEntity.setPcCardUrl("/ejc-proequipment-frontend/#/leaseContract/cardList?id=" + entity.getId() + "&showTitle=true&supplementFlag=" + entity.getSupplementFlag());
                rentPriceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                rentPriceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                rentPriceContractEntity.setTargetResultId(entity.getTargetResultId());
                rentPriceContractEntity.setSourceId(rentPriceContractVO.getId());
                rentPriceContractEntity.setContractTaxRate(rentPriceContractVO.getContractTaxRate());
                rentPriceContractEntity.setContractNum(rentPriceContractVO.getContractNum());
                rentPriceContractEntity.setContractPrice(null != rentPriceContractVO.getContractPrice() ? rentPriceContractVO.getContractPrice() : BigDecimal.ZERO);
                rentPriceContractEntity.setContractTaxPrice(null != rentPriceContractVO.getContractTaxPrice() ? rentPriceContractVO.getContractTaxPrice() : BigDecimal.ZERO);
                rentPriceContractEntity.setContractMny(null != rentPriceContractVO.getContractMny() ? rentPriceContractVO.getContractMny() : BigDecimal.ZERO);
                rentPriceContractEntity.setContractTaxMny(null != rentPriceContractVO.getContractTaxMny() ? rentPriceContractVO.getContractTaxMny() : BigDecimal.ZERO);
                rentPriceContractEntity.setMemo(rentPriceContractVO.getMemo());
                rentPriceContractEntity.setSpec(rentPriceContractVO.getSpec());
                rentPriceContractEntity.setManufacturer(rentPriceContractVO.getManufacturer());
                rentPriceContractEntity.setDocId(rentPriceContractVO.getDocId());
                rentPriceContractEntity.setDocCode(rentPriceContractVO.getDocCode());
                rentPriceContractEntity.setDocName(rentPriceContractVO.getDocName());
                rentPriceContractEntity.setDocCategoryId(rentPriceContractVO.getDocCategoryId());
                rentPriceContractEntity.setDocCategoryName(rentPriceContractVO.getDocCategoryName());
                rentPriceContractEntity.setRentType(rentPriceContractVO.getRentType());
                rentPriceContractEntity.setDocInnerCode((String)docCategoryMap.get(rentPriceContractVO.getDocCategoryId()));
                rentPriceContractEntity.setUnitName(rentPriceContractVO.getUnitName());
                rentPriceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                rentPriceContractEntity.setId(null);
                rentPriceContractEntity.setCreateTime(null);
                rentPriceContractEntity.setCreateUserCode(null);
                rentPriceContractEntity.setUpdateTime(null);
                rentPriceContractEntity.setUpdateUserCode(null);
                saveEntityList.add(rentPriceContractEntity);
            }
        }
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(RentPriceContractEntity::getSourceId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(RentPriceContractEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
            for (RentPriceContractEntity entity : saveEntityList) {
                RentPriceContractEntity queryEntity = (RentPriceContractEntity)((Object)queryPriceMap.get(entity.getSourceId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
                entity.setOutFlag(queryEntity.getOutFlag());
            }
        }
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List list2 = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list2)) {
            super.removeByIds(list2, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList.get(0);
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<RentPriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<RentPriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(RentPriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<RentPriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<RentPriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                RentPriceContractEntity rentPriceContractEntity = list.get(0);
                List priceList = list.stream().map(RentPriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(RentPriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (RentPriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(rentPriceContractEntity.getContractPrice());
                vo.setContractTaxPrice(rentPriceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        RentPriceContractEntity entity = (RentPriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public IPage<RentPriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<RentPriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, RentPriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (RentPriceContractVO vo : voList) {
            if (myOrgList.contains(vo.getOrgId())) continue;
            vo.setPcCardUrl(null);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("docId")) {
            throw new BusinessException("\u67e5\u8be2\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<String, PriceLibVO> map = new HashMap<String, PriceLibVO>();
        this.queryPriceContractGroupByDocId(map, startDate, orgIdList, param);
        this.queryPriceGuide(map);
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getDocCode, Comparator.nullsLast(String::compareTo)).thenComparing(PriceLibVO::getRentType, Comparator.nullsLast(Integer::compareTo)));
        }
        return priceLibList;
    }

    private void queryPriceContractGroupByDocId(Map<String, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<RentPriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, Map<Integer, List<RentPriceContractEntity>>> priceContractGroupMap = priceContractList.stream().collect(Collectors.groupingBy(RentPriceContractEntity::getDocId, Collectors.groupingBy(RentPriceContractEntity::getRentType)));
        HashMap<String, List<RentPriceContractEntity>> priceContractMap = new HashMap<String, List<RentPriceContractEntity>>();
        for (Map.Entry<Long, Map<Integer, List<RentPriceContractEntity>>> entry : priceContractGroupMap.entrySet()) {
            Map<Integer, List<RentPriceContractEntity>> priceContractOfRentTypeMap = entry.getValue();
            for (Map.Entry<Integer, List<RentPriceContractEntity>> entryTwo : priceContractOfRentTypeMap.entrySet()) {
                if (entryTwo.getValue().size() <= 1) continue;
                if (priceContractMap.containsKey(entry.getKey() + "" + entryTwo.getValue().get(0).getRentType())) {
                    List allRentPriceContractList = (List)priceContractMap.get(entry.getKey());
                    allRentPriceContractList.addAll((Collection)entryTwo.getValue());
                    priceContractMap.put(entry.getKey() + "" + entryTwo.getValue().get(0).getRentType(), allRentPriceContractList);
                    continue;
                }
                priceContractMap.put(entry.getKey() + "" + entryTwo.getValue().get(0).getRentType(), entryTwo.getValue());
            }
        }
        for (Map.Entry<Long, Map<Integer, List<RentPriceContractEntity>>> entry : priceContractMap.entrySet()) {
            String key = (String)((Object)entry.getKey());
            List value = (List)((Object)entry.getValue());
            List priceList = value.stream().map(RentPriceContractEntity::getContractPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(RentPriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            RentPriceContractEntity priceContract = (RentPriceContractEntity)((Object)value.get(0));
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (RentPriceContractEntity entity : value) {
                num = num.add(entity.getContractNum());
                mny = mny.add(entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO = new PriceLibVO();
            priceLibVO.setDocId(priceContract.getDocId());
            priceLibVO.setDocCode(priceContract.getDocCode());
            priceLibVO.setDocName(priceContract.getDocName());
            priceLibVO.setDocCategoryId(priceContract.getDocCategoryId());
            priceLibVO.setDocCategoryName(priceContract.getDocCategoryName());
            priceLibVO.setUnitId(priceContract.getUnitId());
            priceLibVO.setUnitName(priceContract.getUnitName());
            priceLibVO.setDocInnerCode(priceContract.getDocInnerCode());
            priceLibVO.setUnitName(priceContract.getUnitName());
            priceLibVO.setSpec(priceContract.getSpec());
            priceLibVO.setRentType(priceContract.getRentType());
            if (null != priceLibVO.getRentType()) {
                switch (priceLibVO.getRentType()) {
                    case 1: {
                        priceLibVO.setRentTypeName("\u65e5\u79df");
                        break;
                    }
                    case 2: {
                        priceLibVO.setRentTypeName("\u6708\u79df");
                        break;
                    }
                    default: {
                        priceLibVO.setRentTypeName("\u5de5\u7a0b\u91cf\u79df");
                    }
                }
            }
            libMap.put(priceContract.getDocId() + "" + priceContract.getRentType(), priceLibVO);
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setId(Long.valueOf(priceLibVO.getDocId() + (long)priceLibVO.getRentType().intValue()));
        }
    }

    private List<RentPriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("docCode");
        fuzzyFields.add("docName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("area");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("performance_status", new Parameter("in", Arrays.asList(2, 5)));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("performance_status", new Parameter("in", Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter("ge", (Object)startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        return super.queryList(contractParam, false);
    }

    private List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }

    private void queryPriceGuide(Map<String, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        List list = this.priceGuideDetailService.list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        HashMap<String, RentPriceGuideDetailEntity> guideMap = new HashMap<String, RentPriceGuideDetailEntity>();
        for (RentPriceGuideDetailEntity rentPriceGuideDetailEntity : list) {
            guideMap.put(rentPriceGuideDetailEntity.getDocId() + "" + rentPriceGuideDetailEntity.getRentType(), rentPriceGuideDetailEntity);
        }
        for (Map.Entry entry : libMap.entrySet()) {
            String docIdRentType = (String)entry.getKey();
            PriceLibVO vo = (PriceLibVO)entry.getValue();
            if (!guideMap.containsKey(docIdRentType)) continue;
            RentPriceGuideDetailEntity guide = (RentPriceGuideDetailEntity)((Object)guideMap.get(docIdRentType));
            BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
            BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }
}

