/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rent.bean.RentContractChangeEntity;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.service.IRentContractChangeService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rentContractFileUpdate/"})
public class RentContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractChangeService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        this.logger.info("@@@@@@@@@@@@@", (Object)updateData.getLong("billId"));
        RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFile(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        if (contractBillTypeStr.equals(billType)) {
            RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(billId));
            Assert.notNull((Object)((Object)contract), (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u5408\u540c\u8be6\u60c5");
            cv.setContractId(contract.getId());
            cv.setContractName(contract.getContractName());
            cv.setSourceType(billType);
            cv.setBillType("BT220303000000002");
        } else {
            RentContractChangeEntity contractChange = (RentContractChangeEntity)((Object)this.changeService.selectById(billId));
            cv.setContractId(contractChange.getId());
            cv.setContractName(contractChange.getContractName());
            cv.setSourceType(billType);
            cv.setBillType("BT220303000000001");
        }
        cvs.add(cv);
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if (contractBillTypeStr.equals(billType)) {
            RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            RentContractChangeEntity contractChange = (RentContractChangeEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<RentContractVO> getBillDataJson(@RequestParam Long id) {
        this.logger.info("\u5230\u4e86\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(id));
        RentContractVO vo = (RentContractVO)BeanMapper.map((Object)((Object)contract), RentContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentDayDetailedList())) {
            vo.getRentDayDetailedList().forEach(item -> {
                item.setDayRentPriceStr(null != item.getDayRentPrice() ? priceFmt.format(item.getDayRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopRentPriceStr(null != item.getStopRentPriceStr() ? priceFmt.format(item.getStopRentPriceStr()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDayRentNotTaxPriceStr(null != item.getDayRentNotTaxPrice() ? mnyFmt.format(item.getDayRentNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setStopRentNotTaxPriceStr(null != item.getStopRentNotTaxPrice() ? priceFmt.format(item.getStopRentNotTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentMonthDetailedList())) {
            vo.getRentMonthDetailedList().forEach(item -> {
                item.setMonthRentPriceStr(null != item.getMonthRentPrice() ? priceFmt.format(item.getMonthRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setStopRentPriceStr(null != item.getStopRentPriceStr() ? priceFmt.format(item.getStopRentPriceStr()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setMonthRentNotTaxPriceStr(null != item.getMonthRentNotTaxPrice() ? mnyFmt.format(item.getMonthRentNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setInsufficientMonthNotTaxRentPriceStr(null != item.getInsufficientMonthNotTaxRentPrice() ? priceFmt.format(item.getInsufficientMonthNotTaxRentPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
                item.setNotTaxStopPriceStr(null != item.getNotTaxStopPriceStr() ? priceFmt.format(item.getNotTaxStopPriceStr()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentQuantitiesDetailedList())) {
            vo.getRentQuantitiesDetailedList().forEach(item -> {
                item.setQuantitiesPriceStr(null != item.getQuantitiesPrice() ? priceFmt.format(item.getQuantitiesPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setRentTaxMnyStr(null != item.getRentTaxMny() ? mnyFmt.format(item.getRentTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setRentMnyStr(null != item.getRentMny() ? mnyFmt.format(item.getRentMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxQuantitiesPriceStr(null != item.getNotTaxQuantitiesPrice() ? mnyFmt.format(item.getNotTaxQuantitiesPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentOtherDetailedList())) {
            vo.getRentOtherDetailedList().forEach(item -> {
                item.setPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxStr(null != item.getTax() ? mnyFmt.format(item.getTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxAmountStr(null != item.getTaxAmount() ? mnyFmt.format(item.getTaxAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxPriceStr(null != item.getNotTaxPrice() ? mnyFmt.format(item.getNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMoneyStr(null != item.getTaxMoney() ? priceFmt.format(item.getTaxMoney()) : priceFmt.format(BigDecimal.ZERO));
                item.setNotTaxAmountStr(null != item.getNotTaxAmount() ? priceFmt.format(item.getNotTaxAmount()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentContractPaymentClauseList())) {
            vo.getRentContractPaymentClauseList().forEach(item -> item.setPaymentRatioStr(null != item.getPaymentRatio() ? priceFmt.format(item.getPaymentRatio()) : priceFmt.format(BigDecimal.ZERO)));
        }
        return CommonResponse.success((Object)vo);
    }
}

