/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractRecordEntity;
import com.ejianc.business.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.rent.bean.RentDayRecordEntity;
import com.ejianc.business.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.rent.bean.RentMonthRecordEntity;
import com.ejianc.business.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.rent.bean.RentQuantitiesRecordEntity;
import com.ejianc.business.rent.bean.RentRentalDayEntity;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.bean.RentRentalMonthEntity;
import com.ejianc.business.rent.bean.RentRentalQuantitiesEntity;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.rent.mapper.RentRentalMapper;
import com.ejianc.business.rent.service.IRentContractRecordService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentDayRecordService;
import com.ejianc.business.rent.service.IRentMonthRecordService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.service.IRentQuantitiesRecordService;
import com.ejianc.business.rent.service.IRentRentalDayService;
import com.ejianc.business.rent.service.IRentRentalMonthService;
import com.ejianc.business.rent.service.IRentRentalQuantitiesService;
import com.ejianc.business.rent.service.IRentRentalService;
import com.ejianc.business.rent.vo.RentDayRecordVO;
import com.ejianc.business.rent.vo.RentMonthRecordVO;
import com.ejianc.business.rent.vo.RentParameterDetailVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.rent.vo.RentQuantitiesRecordVO;
import com.ejianc.business.rent.vo.RentRentalCacheVO;
import com.ejianc.business.rent.vo.RentRentalDayVO;
import com.ejianc.business.rent.vo.RentRentalQuantitiesVO;
import com.ejianc.business.rent.vo.RentRentalVO;
import com.ejianc.business.rent.vo.RentalSumVo;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.business.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.userecord.service.IUseRecordService;
import com.ejianc.business.userecord.service.IUseRecordSubService;
import com.ejianc.business.utils.CommonUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rentRentalService")
public class RentRentalServiceImpl
extends BaseServiceImpl<RentRentalMapper, RentRentalEntity>
implements IRentRentalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer RENT_TYPE_DAY = 1;
    private static final Integer RENT_TYPE_MONTH = 2;
    private static final Integer RENT_TYPE_QUANTITIES = 3;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IRentParameterService parameterService;
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private IRentContractRecordService contractRecordService;
    @Autowired
    private IRentDayRecordService dayRecordService;
    @Autowired
    private IRentMonthRecordService monthRecordService;
    @Autowired
    private IRentQuantitiesRecordService quantitiesRecordService;
    @Autowired
    private IUseRecordService useRecordService;
    @Autowired
    private IUseRecordSubService useRecordSubService;
    @Autowired
    private IRentRentalDayService rentRentalDayService;
    @Autowired
    private IRentRentalMonthService rentRentalMonthService;
    @Autowired
    private IRentRentalQuantitiesService rentRentalQuantitiesService;
    @Autowired
    private RentRentalMapper rentRentalMapper;
    private static final String BILL_CODE = "RENT_RENTAL";

    @Override
    public RentRentalVO saveRental(RentRentalVO vo) {
        RentRentalEntity entity;
        CommonResponse orgResponse;
        List checkList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (null != vo.getId()) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u65e0\u6cd5\u65b0\u589e\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)vo.getRentRentalDayList()) && CollectionUtils.isEmpty((Collection)vo.getRentRentalMonthList()) && CollectionUtils.isEmpty((Collection)vo.getRentRentalQuantitiesList())) {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getParentOrgCode()) && vo.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(vo.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            vo.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (RentRentalEntity)((Object)BeanMapper.map((Object)vo, RentRentalEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSettlementState(RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
        if (CollectionUtils.isNotEmpty((Collection)vo.getRentRentalQuantitiesList())) {
            List useIdList = vo.getRentRentalQuantitiesList().stream().map(RentRentalQuantitiesVO::getSourceId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, useIdList);
            updateWrapper.set(UseRecordEntity::getRentalFlag, (Object)1);
            this.useRecordService.update((Wrapper)updateWrapper);
        }
        super.saveOrUpdate((Object)entity, false);
        this.saveCost(entity, 0);
        return (RentRentalVO)BeanMapper.map((Object)((Object)entity), RentRentalVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateRentalSettlementState(List<Long> ids, Integer state) {
        this.logger.info("\u4fee\u6539\u79df\u91d1\u8ba1\u7b97\u5355\u636e\u72b6\u6001\uff0c\u5355\u636eid\uff1a{}\uff0c\u4fee\u6539\u72b6\u6001\uff1a{}", (Object)JSONObject.toJSONString(ids), (Object)state);
        if (CollectionUtils.isNotEmpty(ids)) {
            if (null == RentalSettlementStateEnum.getEnumByCode(state)) {
                throw new BusinessException("\u7ed3\u7b97\u6807\u5fd7\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u7ed3\u7b97\u6807\u5fd7");
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List saveEntityList = super.queryList(queryParam, false);
            if (CollectionUtils.isEmpty((Collection)saveEntityList)) {
                return false;
            }
            for (RentRentalEntity entity : saveEntityList) {
                entity.setSettlementState(state);
            }
            return super.saveOrUpdateBatch((Collection)saveEntityList);
        }
        return false;
    }

    @Override
    public CommonResponse<RentRentalVO> pushCost(RentRentalVO rentRentalVO) {
        RentRentalEntity entity = (RentRentalEntity)((Object)super.selectById((Serializable)rentRentalVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)rentRentalVO.getRentRentalDayList())) {
            List dayEntities = BeanMapper.mapList((Iterable)rentRentalVO.getRentRentalDayList(), RentRentalDayEntity.class);
            entity.setRentRentalDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)rentRentalVO.getRentRentalMonthList())) {
            List monthEntities = BeanMapper.mapList((Iterable)rentRentalVO.getRentRentalMonthList(), RentRentalMonthEntity.class);
            entity.setRentRentalMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)rentRentalVO.getRentRentalQuantitiesList())) {
            List quantitiesEntities = BeanMapper.mapList((Iterable)rentRentalVO.getRentRentalQuantitiesList(), RentRentalQuantitiesEntity.class);
            entity.setRentRentalQuantitiesList(quantitiesEntities);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentRentalVO.class));
    }

    @Override
    public void costPush(RentRentalEntity entity) {
        this.logger.info("\u79df\u91d1\u8ba1\u7b97\u5f00\u59cb\u63a8\u9001\u5b9e\u9645\u6210\u672ccostPush");
        List<RentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<RentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<RentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentRentalDayEntity rentRentalDayEntity : dayList) {
                if (null != rentRentalDayEntity.getSubjectId() && null != rentRentalDayEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentRentalMonthEntity rentRentalMonthEntity : monthList) {
                if (null != rentRentalMonthEntity.getSubjectId() && null != rentRentalMonthEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentRentalQuantitiesEntity rentRentalQuantitiesEntity : quantitiesList) {
                if (null != rentRentalQuantitiesEntity.getSubjectId() && null != rentRentalQuantitiesEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList)) {
            newRelationFlag = "0";
        }
        this.saveCost(entity, 1);
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentRentalEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(RentRentalEntity entity, Integer effectiveStatus) {
        CostDetailVO costDetailVO2;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<RentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<RentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<RentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (RentRentalDayEntity rentRentalDayEntity : dayList) {
                CostDetailVO costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)rentRentalDayEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(rentRentalDayEntity.getId());
                costDetailVO2.setHappenTaxMny(rentRentalDayEntity.getRentDayTaxMny());
                costDetailVO2.setHappenMny(rentRentalDayEntity.getRentDayMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_DAY");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (RentRentalMonthEntity rentRentalMonthEntity : monthList) {
                costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)rentRentalMonthEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(rentRentalMonthEntity.getId());
                costDetailVO2.setHappenTaxMny(rentRentalMonthEntity.getRentMonthTaxMny());
                costDetailVO2.setHappenMny(rentRentalMonthEntity.getRentMonthMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_MONTH");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (RentRentalQuantitiesEntity rentRentalQuantitiesEntity : quantitiesList) {
                costDetailVO2 = (CostDetailVO)BeanMapper.map((Object)((Object)rentRentalQuantitiesEntity), CostDetailVO.class);
                costDetailVO2.setSourceDetailId(rentRentalQuantitiesEntity.getId());
                costDetailVO2.setHappenTaxMny(rentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                costDetailVO2.setHappenMny(rentRentalQuantitiesEntity.getRentQuantitiesMny());
                costDetailVO2.setSourceTabType("RE_EQ_ZJ_QUANTITIES");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO2);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            String url = "/ejc-proequipment-frontend/#/rentalList/card?id=" + entity.getId();
            if ("1".equals(entity.getRentalType())) {
                url = "/ejc-proequipment-frontend/#/rentalList/automaticCard?id=" + entity.getId();
            }
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(entity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u8bbe\u5907\u79df\u91d1\u8ba1\u7b97.getTypeName());
                costDetailVO2.setSourceBillUrl(url);
                costDetailVO2.setSourceId(entity.getId());
                costDetailVO2.setHappenDate(entity.getRentalDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("TEMP_EQ_ZJ");
                costDetailVO2.setProjectId(entity.getProjectId());
                costDetailVO2.setEffectiveStatus(effectiveStatus);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public void delRental(List<RentRentalVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        for (RentRentalVO vo : vos) {
            if (CollectionUtils.isNotEmpty((Collection)vo.getRentRentalQuantitiesList())) {
                List useIdList = vo.getRentRentalQuantitiesList().stream().map(RentRentalQuantitiesVO::getSourceId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, useIdList);
                updateWrapper.set(UseRecordEntity::getRentalFlag, (Object)0);
                this.useRecordService.update((Wrapper)updateWrapper);
            }
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(vo.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (stringCommonResponse.isSuccess()) continue;
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public RentalSumVo queryRentalMnyByContractId(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = super.queryList(queryParam, false);
        BigDecimal sumRentalTaxMny = BigDecimal.ZERO;
        BigDecimal sumRentalMny = BigDecimal.ZERO;
        RentalSumVo vo = new RentalSumVo();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return vo;
        }
        for (RentRentalEntity entity : list) {
            sumRentalTaxMny = sumRentalTaxMny.add(entity.getRentTotalTaxMny());
            sumRentalMny = sumRentalMny.add(entity.getRentTotalMny());
        }
        vo.setTotalMny(sumRentalMny);
        vo.setTotalTaxMny(sumRentalTaxMny);
        return vo;
    }

    @Override
    public void delRentalById(Long id) {
        Boolean flag = this.rentRentalMapper.delRentalById(id);
        if (Boolean.FALSE.equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25!");
        }
    }

    @Override
    public ParamsCheckVO checkParams(RentRentalVO rentRentalVO) {
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(rentRentalVO);
        if (null != costCtrlVO && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(RentRentalVO vo) {
        List dayList = vo.getRentRentalDayList();
        List monthList = vo.getRentRentalMonthList();
        List quantitiesList = vo.getRentRentalQuantitiesList();
        if (CollectionUtils.isNotEmpty((Collection)dayList)) {
            BigDecimal taxMny;
            BigDecimal mny;
            CostCtrlDetailVO costCtrlDetailVO;
            BigDecimal detailTaxMny;
            BigDecimal detailMny;
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (RentRentalDayVO settlementFeeVO : dayList) {
                if (null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentDayMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentDayTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
            for (RentRentalDayVO settlementFeeVO : monthList) {
                if (null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentMonthMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentMonthTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
            for (RentRentalDayVO settlementFeeVO : quantitiesList) {
                if (null == settlementFeeVO.getSubjectId()) continue;
                detailMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentQuantitiesMny());
                detailTaxMny = CommonUtils.setBigDecimalDefaultValue(settlementFeeVO.getRentQuantitiesTaxMny());
                if (map.containsKey(settlementFeeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectId());
                    mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                    taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                    costCtrlDetailVO.setMny(mny.add(detailMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectId());
                costCtrlDetailVO.setMny(detailMny);
                costCtrlDetailVO.setTaxMny(detailTaxMny);
                map.put(settlementFeeVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && !map.isEmpty()) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    @Override
    public RentRentalVO automaticRental(RentRentalVO vo) {
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentalDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long contractId = vo.getContractId();
        Date endDate = vo.getRentalDate();
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u8bbe\u5907\u53f0\u8d26\u4fe1\u606fstart");
        List<RentParameterVO> rentParameterList = this.parameterService.getRentParameterByContractId(contractId, vo.getId(), endDate);
        HashMap<Long, RentParameterVO> rentParameterVOMap = new HashMap<Long, RentParameterVO>();
        if (CollectionUtils.isEmpty(rentParameterList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u8bbe\u5907\u9a8c\u6536\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u8bbe\u5907\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rentParameterList));
        this.logger.info(">>>>\u67e5\u8be2\u5408\u540c\u4fe1\u606fstart");
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(contractId));
        this.logger.info("\u4e3b\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        Map<Integer, Map<Long, List<RentRentalCacheVO>>> contractAllMap = this.getContractRecord(contractId, contractEntity, endDate);
        this.logger.info("<<<<\u67e5\u8be2\u5408\u540c\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(contractAllMap));
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        RentRentalEntity entity = new RentRentalEntity();
        ArrayList<RentRentalDayEntity> rentRentalDayList = new ArrayList<RentRentalDayEntity>();
        ArrayList<RentRentalMonthEntity> rentRentalMonthList = new ArrayList<RentRentalMonthEntity>();
        ArrayList<RentRentalQuantitiesEntity> rentRentalQuantitiesList = new ArrayList<RentRentalQuantitiesEntity>();
        ArrayList<RentRentalCacheVO> resultDayList = new ArrayList<RentRentalCacheVO>();
        ArrayList<RentRentalCacheVO> resultMonthList = new ArrayList<RentRentalCacheVO>();
        ArrayList resultQuantitiesList = new ArrayList();
        for (RentParameterVO parameterVO : rentParameterList) {
            rentParameterVOMap.put(parameterVO.getId(), parameterVO);
            if (RENT_TYPE_DAY.equals(parameterVO.getRentTypeId())) {
                this.packParameterDetailAndContract2(resultDayList, contractAllMap, parameterVO, RENT_TYPE_DAY, contractEntity.getMonthSettlement());
                continue;
            }
            if (!RENT_TYPE_MONTH.equals(parameterVO.getRentTypeId())) continue;
            this.packParameterDetailAndContract2(resultMonthList, contractAllMap, parameterVO, RENT_TYPE_MONTH, contractEntity.getMonthSettlement());
        }
        this.setRentalDayDetailValue(resultDayList, rentRentalDayList);
        this.setRentalMonthDetailValue(resultMonthList, rentRentalMonthList);
        this.setQuantitiesByUseRecord(rentRentalQuantitiesList, contractEntity, endDate);
        if (null == vo.getId()) {
            entity.setRentalType("1");
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            entity.setSettlementState(RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
            entity.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        }
        if (CollectionUtils.isNotEmpty(rentRentalDayList)) {
            rentRentalDayList.forEach(e -> {
                if (null != e.getSourceId() && rentParameterVOMap.containsKey(e.getSourceId())) {
                    e.setDayFactoryCode(((RentParameterVO)rentParameterVOMap.get(e.getSourceId())).getFactoryCode());
                }
            });
        }
        if (CollectionUtils.isNotEmpty(rentRentalMonthList)) {
            rentRentalMonthList.forEach(e -> {
                if (null != e.getSourceId() && rentParameterVOMap.containsKey(e.getSourceId())) {
                    e.setMonthFactoryCode(((RentParameterVO)rentParameterVOMap.get(e.getSourceId())).getFactoryCode());
                }
            });
        }
        entity.setRentRentalDayList(rentRentalDayList);
        entity.setRentRentalMonthList(rentRentalMonthList);
        entity.setRentRentalQuantitiesList(rentRentalQuantitiesList);
        this.setRentalValue(entity, contractEntity, endDate, vo);
        this.logger.info(">>>>\u4fdd\u5b58\u79df\u91d1\u8ba1\u7b97\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        this.logger.info("\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        return (RentRentalVO)BeanMapper.map((Object)((Object)entity), RentRentalVO.class);
    }

    private void setRentalDayDetailValue(List<RentRentalCacheVO> resultList, List<RentRentalDayEntity> rentRentalDayList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        for (RentRentalCacheVO vo : resultList) {
            RentDayRecordVO recordVO = vo.getRentDayRecord();
            RentRentalDayEntity dayEntity = new RentRentalDayEntity();
            dayEntity.setSourceDetailId(recordVO.getId());
            dayEntity.setSourceName("\u8bbe\u5907\u79df\u8d41\u65e5\u79df-" + recordVO.getEquipmentCode());
            dayEntity.setSourceType(2);
            dayEntity.setSourceCode(recordVO.getCode());
            dayEntity.setEquipmentName(recordVO.getName());
            dayEntity.setDayFactoryCode(recordVO.getDayFactoryCode());
            dayEntity.setCategoryId(recordVO.getCategoryId());
            dayEntity.setCategoryName(recordVO.getCategoryName());
            dayEntity.setSpec(recordVO.getSpec());
            dayEntity.setUnitName(recordVO.getUnitName());
            dayEntity.setDayRentPrice(recordVO.getDayRentPrice());
            dayEntity.setStopRentPrice(recordVO.getStopRentPrice());
            dayEntity.setRentNum(1);
            dayEntity.setTax(recordVO.getTax());
            dayEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            dayEntity.setStopRentNotTaxPrice(recordVO.getStopRentNotTaxPrice());
            dayEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            dayEntity.setPlanOutDate(recordVO.getPlanOutDate());
            dayEntity.setProductionManufactor(recordVO.getProductionManufactor());
            dayEntity.setEquipmentCode(recordVO.getEquipmentCode());
            dayEntity.setEquipmentId(recordVO.getEquipmentId());
            dayEntity.setSourceId(vo.getParameterId());
            dayEntity.setChargingStartDate(vo.getStartDate());
            dayEntity.setChargingEndDate(vo.getEndDate());
            dayEntity.setRentDayDate(this.daysBetween(this.calculationDay(vo.getStartDate(), -1), vo.getEndDate()));
            if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getDayRentNotTaxPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getDayRentPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
            } else if (RentEquipmentStateEnum.\u505c\u7528.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getStopRentNotTaxPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getStopRentPrice(), dayEntity.getRentDayDate(), dayEntity.getRentNum()));
            }
            dayEntity.setRentDayTax(dayEntity.getRentDayTaxMny().subtract(dayEntity.getRentDayMny()));
            dayEntity.setEquipmentState(vo.getEquipmentState());
            dayEntity.setRowState("add");
            dayEntity.setId(IdWorker.getId());
            rentRentalDayList.add(dayEntity);
        }
        if (CollectionUtils.isNotEmpty(rentRentalDayList)) {
            rentRentalDayList.sort(Comparator.comparing(RentRentalDayEntity::getSourceId).thenComparing(RentRentalDayEntity::getChargingStartDate));
        }
    }

    private void setRentalMonthDetailValue(List<RentRentalCacheVO> resultList, List<RentRentalMonthEntity> rentRentalMonthList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        ArrayList<RentRentalMonthEntity> rstList = new ArrayList<RentRentalMonthEntity>();
        for (RentRentalCacheVO vo : resultList) {
            RentMonthRecordVO recordVO = vo.getRentMonthRecord();
            RentRentalMonthEntity monthEntity = new RentRentalMonthEntity();
            monthEntity.setSourceDetailId(recordVO.getId());
            monthEntity.setSourceName("\u8bbe\u5907\u79df\u8d41\u6708\u79df-" + recordVO.getEquipmentCode());
            monthEntity.setSourceType(2);
            monthEntity.setSourceCode(recordVO.getCode());
            monthEntity.setEquipmentName(recordVO.getName());
            monthEntity.setMonthFactoryCode(recordVO.getMonthFactoryCode());
            monthEntity.setCategoryId(recordVO.getCategoryId());
            monthEntity.setCategoryName(recordVO.getCategoryName());
            monthEntity.setSpec(recordVO.getSpec());
            monthEntity.setUnitName(recordVO.getUnitName());
            monthEntity.setMonthRentPrice(recordVO.getMonthRentPrice());
            monthEntity.setInsufficientMonthDayRentPrice(recordVO.getInsufficientMonthDayRentPrice());
            monthEntity.setStopRentPrice(recordVO.getStopRentPrice());
            monthEntity.setRentNum(1);
            monthEntity.setTax(recordVO.getTax());
            monthEntity.setMonthRentNotTaxPrice(recordVO.getMonthRentNotTaxPrice());
            monthEntity.setInsufficientMonthNotTaxRentPrice(recordVO.getInsufficientMonthNotTaxRentPrice());
            monthEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            monthEntity.setPlanOutDate(recordVO.getPlanOutDate());
            monthEntity.setProductionManufactor(recordVO.getProductionManufactor());
            monthEntity.setEquipmentCode(recordVO.getEquipmentCode());
            monthEntity.setEquipmentId(recordVO.getEquipmentId());
            monthEntity.setDayTaxPrice(recordVO.getDayTaxPrice());
            monthEntity.setTaxMny(recordVO.getTaxMny());
            monthEntity.setNotTaxMonthPrice(recordVO.getNotTaxMonthPrice());
            monthEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            monthEntity.setNotTaxStopPrice(recordVO.getNotTaxStopPrice());
            monthEntity.setSourceId(vo.getParameterId());
            monthEntity.setChargingStartDate(vo.getStartDate());
            monthEntity.setChargingEndDate(vo.getEndDate());
            if (RentEquipmentStateEnum.\u505c\u7528.getCode().equals(vo.getEquipmentState())) {
                Integer days = this.daysBetween(this.calculationDay(vo.getStartDate(), -1), vo.getEndDate());
                monthEntity.setRentMonthMny(this.getMny(monthEntity.getNotTaxStopPrice(), days, monthEntity.getRentNum()));
                monthEntity.setRentMonthTaxMny(this.getMny(monthEntity.getStopRentPrice(), days, monthEntity.getRentNum()));
                monthEntity.setRentDayDate(days);
            } else {
                this.monthSum(monthEntity, vo);
            }
            monthEntity.setRentMonthTax(monthEntity.getRentMonthTaxMny().subtract(monthEntity.getRentMonthMny()));
            monthEntity.setEquipmentState(vo.getEquipmentState());
            monthEntity.setRowState("add");
            monthEntity.setId(IdWorker.getId());
            rstList.add(monthEntity);
        }
        rstList.sort(Comparator.comparing(RentRentalMonthEntity::getChargingStartDate));
        this.logger.info("\u5408\u5e76\u524d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(rstList));
        rentRentalMonthList.addAll(rstList);
        if (CollectionUtils.isNotEmpty(rentRentalMonthList)) {
            rentRentalMonthList.sort(Comparator.comparing(RentRentalMonthEntity::getSourceId).thenComparing(RentRentalMonthEntity::getChargingStartDate));
        }
    }

    private void setQuantitiesByUseRecord(List<RentRentalQuantitiesEntity> rentRentalQuantitiesList, RentContractEntity contractEntity, Date endDate) {
        this.logger.info(">>>>\u5f00\u59cb\u8ba1\u7b97\u5de5\u7a0b\u91cf\u79df");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("endDate", new Parameter("lt", (Object)this.dayAddOne(endDate)));
        queryParam.getParams().put("rentalFlag", new Parameter("ne", (Object)1));
        List useRecordEntityList = this.useRecordService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)useRecordEntityList)) {
            return;
        }
        List useIdList = useRecordEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter("in", useIdList));
        List useDetailList = this.useRecordSubService.queryList(detailParam, false);
        HashMap map = new HashMap();
        for (UseRecordSubEntity detailEntity : useDetailList) {
            if (map.containsKey(detailEntity.getPid())) {
                ((List)map.get(detailEntity.getPid())).add(detailEntity);
                continue;
            }
            ArrayList<UseRecordSubEntity> packList = new ArrayList<UseRecordSubEntity>();
            packList.add(detailEntity);
            map.put(detailEntity.getPid(), packList);
        }
        for (UseRecordEntity use : useRecordEntityList) {
            List detailList = (List)map.get(use.getId());
            for (UseRecordSubEntity detail : detailList) {
                RentRentalQuantitiesEntity entity = new RentRentalQuantitiesEntity();
                entity.setSourceDetailId(detail.getId());
                entity.setSourceName("\u8bbe\u5907\u79df\u8d41\u5de5\u7a0b\u91cf\u79df-" + detail.getEquipmentId());
                entity.setSourceType(2);
                entity.setSourceId(use.getId());
                entity.setEquipmentName(detail.getEquipmentName());
                entity.setQuantitiesFactoryCode(detail.getEquipmentExitCode());
                entity.setCategoryId(detail.getEquipmentTypeId());
                entity.setCategoryName(detail.getEquipmentType());
                entity.setSpec(detail.getSpec());
                entity.setUnitName(detail.getUnit());
                entity.setQuantitiesNum(detail.getBillingWorkload());
                entity.setQuantitiesPrice(detail.getContractTaxPrice());
                entity.setRentNum(1);
                entity.setTax(contractEntity.getContractTax());
                entity.setEquipmentId(detail.getEquipmentId());
                entity.setNotTaxQuantitiesPrice(detail.getContractPrice());
                entity.setBillingUnitName(detail.getBillingUnit());
                entity.setChargingStartDate(use.getStartDate());
                entity.setChargingEndDate(use.getEndDate());
                entity.setRentQuantitiesMny(detail.getMny());
                entity.setRentQuantitiesTaxMny(detail.getTaxMny());
                entity.setRentQuantitiesTax(detail.getTax());
                entity.setRowState("add");
                entity.setId(IdWorker.getId());
                rentRentalQuantitiesList.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(rentRentalQuantitiesList)) {
            rentRentalQuantitiesList.sort(Comparator.comparing(RentRentalQuantitiesEntity::getEquipmentId).thenComparing(RentRentalQuantitiesEntity::getChargingStartDate));
        }
        this.logger.info("<<<<\u8ba1\u7b97\u5de5\u7a0b\u91cf\u79df\u7ed3\u675f\uff0c\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rentRentalQuantitiesList));
    }

    private void monthSum(RentRentalMonthEntity monthEntity, RentRentalCacheVO vo) {
        Date endDate = monthEntity.getChargingEndDate();
        endDate = this.calculationDay(endDate, 1);
        int[] mo = this.dayCompare(monthEntity.getChargingStartDate(), endDate);
        int month = mo[0];
        int day = mo[1];
        Integer rentNum = monthEntity.getRentNum();
        BigDecimal monthMny = this.getMny(monthEntity.getMonthRentNotTaxPrice(), month, rentNum);
        BigDecimal monthTaxMny = this.getMny(monthEntity.getMonthRentPrice(), month, rentNum);
        BigDecimal dayMny = this.getMny(monthEntity.getInsufficientMonthNotTaxRentPrice(), day, rentNum);
        BigDecimal dayTaxMny = this.getMny(monthEntity.getInsufficientMonthDayRentPrice(), day, rentNum);
        monthEntity.setRentMonthMny(monthMny.add(dayMny));
        monthEntity.setRentMonthTaxMny(monthTaxMny.add(dayTaxMny));
        monthEntity.setRentMonthDate(month);
        monthEntity.setRentDayDate(day);
    }

    private void setRentalValue(RentRentalEntity entity, RentContractEntity contractEntity, Date date, RentRentalVO vo) {
        entity.setProjectId(vo.getProjectId());
        entity.setProjectCode(vo.getProjectCode());
        entity.setProjectName(vo.getProjectName());
        entity.setOrgId(vo.getOrgId());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setParentOrgId(vo.getParentOrgId());
        entity.setParentOrgCode(vo.getParentOrgCode());
        entity.setParentOrgName(vo.getParentOrgName());
        entity.setContractId(contractEntity.getId());
        entity.setContractName(contractEntity.getContractName());
        entity.setContractCode(contractEntity.getContractCode());
        entity.setSupplierId(contractEntity.getSupplierId());
        entity.setSupplierName(contractEntity.getSupplierName());
        entity.setRentalDate(date);
        entity.setEmployeeId(vo.getEmployeeId());
        entity.setEmployeeName(vo.getEmployeeName());
        entity.setMeterRentType(contractEntity.getMeterRentType());
        entity.setMeterRentTypeName(contractEntity.getMeterRentTypeName());
        BigDecimal rentTotalMny = BigDecimal.ZERO;
        BigDecimal rentTotalTaxMny = BigDecimal.ZERO;
        BigDecimal rentTotalTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getRentRentalDayList())) {
            for (RentRentalDayEntity rentRentalDayEntity : entity.getRentRentalDayList()) {
                if (this.isDetailDel(rentRentalDayEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(rentRentalDayEntity.getRentDayMny());
                rentTotalTaxMny = rentTotalTaxMny.add(rentRentalDayEntity.getRentDayTaxMny());
                rentTotalTax = rentTotalTax.add(rentRentalDayEntity.getRentDayTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalMonthList())) {
            for (RentRentalMonthEntity rentRentalMonthEntity : entity.getRentRentalMonthList()) {
                if (this.isDetailDel(rentRentalMonthEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(rentRentalMonthEntity.getRentMonthMny());
                rentTotalTaxMny = rentTotalTaxMny.add(rentRentalMonthEntity.getRentMonthTaxMny());
                rentTotalTax = rentTotalTax.add(rentRentalMonthEntity.getRentMonthTax());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalQuantitiesList())) {
            for (RentRentalQuantitiesEntity rentRentalQuantitiesEntity : entity.getRentRentalQuantitiesList()) {
                if (this.isDetailDel(rentRentalQuantitiesEntity.getRowState())) continue;
                rentTotalMny = rentTotalMny.add(rentRentalQuantitiesEntity.getRentQuantitiesMny());
                rentTotalTaxMny = rentTotalTaxMny.add(rentRentalQuantitiesEntity.getRentQuantitiesTaxMny());
                rentTotalTax = rentTotalTax.add(rentRentalQuantitiesEntity.getRentQuantitiesTax());
            }
        }
        entity.setRentTotalMny(rentTotalMny);
        entity.setRentTotalTaxMny(rentTotalTaxMny);
        entity.setRentTotalTax(rentTotalTax);
    }

    private void packParameterDetailAndContract(List<RentRentalCacheVO> resultList, Map<Integer, Map<Long, List<RentRentalCacheVO>>> contractAllMap, RentParameterVO parameterVO, Integer rentType, String monthSettlement) {
        Map<Long, List<RentRentalCacheVO>> map = contractAllMap.get(rentType);
        List<RentRentalCacheVO> cacheList = map.get(parameterVO.getEquipmentId());
        cacheList.sort(Comparator.comparing(RentRentalCacheVO::getStartDate));
        List parameterDetailList = parameterVO.getRentParameterDetailList();
        List<RentRentalCacheVO> resultList2 = new ArrayList<RentRentalCacheVO>();
        parameterDetailList.sort(Comparator.comparing(RentParameterDetailVO::getOperationDate));
        for (RentRentalCacheVO cacheVO : cacheList) {
            if (parameterDetailList.size() == 1) {
                RentParameterDetailVO detailVO = (RentParameterDetailVO)parameterDetailList.get(0);
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    RentRentalCacheVO rstVo = new RentRentalCacheVO();
                    this.setRecordByRentType(cacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO.getEquipmentState())) continue;
                    RentRentalCacheVO rstvo2 = new RentRentalCacheVO();
                    rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                    rstvo2.setEndDate(cacheVO.getEndDate());
                    rstvo2.setEquipmentState(detailVO.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    if (!this.checkCacheVoIsMerge(rstVo, rstvo2)) continue;
                    resultList2.add(rstvo2);
                    continue;
                }
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate()) || detailVO.getOperationDate().after(cacheVO.getEndDate())) continue;
                RentRentalCacheVO rstVo = new RentRentalCacheVO();
                this.setRecordByRentType(cacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEndDate(cacheVO.getEndDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                resultList2.add(rstVo);
                continue;
            }
            int parameterListLength = parameterDetailList.size() - 1;
            for (int i = 0; i < parameterListLength; ++i) {
                RentRentalCacheVO rstvo2;
                RentParameterDetailVO detailVO = (RentParameterDetailVO)parameterDetailList.get(i);
                RentParameterDetailVO detailVO1 = (RentParameterDetailVO)parameterDetailList.get(i + 1);
                this.logger.info("cacheVo:\u3010{}\u3011\uff0cdetail:\u3010{}\u3011\uff0cdetail1\uff1a\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)cacheVO), JSONObject.toJSONString((Object)detailVO), JSONObject.toJSONString((Object)detailVO1)});
                RentRentalCacheVO rstVo = new RentRentalCacheVO();
                this.setRecordByRentType(cacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO.getEquipmentState())) continue;
                    rstvo2 = new RentRentalCacheVO();
                    rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                    rstvo2.setEndDate(cacheVO.getEndDate());
                    rstvo2.setEquipmentState(detailVO.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    if (!this.checkCacheVoIsMerge(rstVo, rstvo2)) continue;
                    resultList2.add(rstvo2);
                    continue;
                }
                if (!detailVO.getOperationDate().before(cacheVO.getStartDate()) && !detailVO1.getOperationDate().after(cacheVO.getEndDate())) {
                    Date detailStartDate = detailVO.getOperationDate();
                    rstVo.setStartDate(detailStartDate);
                    rstVo.setEndDate(detailVO1.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(detailVO1.getEquipmentState()) || i != parameterListLength - 1) continue;
                    RentRentalCacheVO rstvo22 = new RentRentalCacheVO();
                    rstvo22.setStartDate(this.dayAddOne(detailVO1.getOperationDate()));
                    rstvo22.setEndDate(cacheVO.getEndDate());
                    rstvo22.setEquipmentState(detailVO1.getEquipmentState());
                    rstvo22.setRentType(rentType);
                    rstvo22.setParameterId(parameterVO.getId());
                    rstvo22.setParameterType(detailVO1.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo22, rentType);
                    resultList2.add(rstvo22);
                    continue;
                }
                if (!detailVO.getOperationDate().before(cacheVO.getStartDate()) && !detailVO1.getOperationDate().before(cacheVO.getEndDate())) {
                    if (i != 0) {
                        RentRentalCacheVO rstvo1 = new RentRentalCacheVO();
                        rstvo1.setStartDate(cacheVO.getStartDate());
                        rstvo1.setEndDate(detailVO.getOperationDate());
                        rstvo1.setEquipmentState(detailVO.getEquipmentState());
                        rstvo1.setRentType(rentType);
                        rstvo1.setParameterId(parameterVO.getId());
                        rstvo1.setParameterType(detailVO.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo1, rentType);
                        resultList2.add(rstvo1);
                    }
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getEndDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    rstvo2 = new RentRentalCacheVO();
                    rstvo2.setStartDate(cacheVO.getEndDate());
                    rstvo2.setEndDate(detailVO1.getOperationDate());
                    rstvo2.setEquipmentState(detailVO1.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO1.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    resultList2.add(rstvo2);
                    continue;
                }
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEndDate(detailVO1.getOperationDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                resultList2.add(rstVo);
            }
        }
        resultList2 = this.packResultCacheVo(resultList2, monthSettlement);
        resultList.addAll(resultList2);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private void packParameterDetailAndContract2(List<RentRentalCacheVO> resultList, Map<Integer, Map<Long, List<RentRentalCacheVO>>> contractAllMap, RentParameterVO parameterVO, Integer rentType, String monthSettlement) {
        RentParameterDetailVO detailVO;
        Map<Long, List<RentRentalCacheVO>> map = contractAllMap.get(rentType);
        List<RentRentalCacheVO> cacheList = map.get(parameterVO.getEquipmentId());
        int size = cacheList.size();
        cacheList.sort(Comparator.comparing(RentRentalCacheVO::getStartDate));
        List parameterDetailList = parameterVO.getRentParameterDetailList();
        int num = parameterDetailList.size();
        if (num > 0) {
            RentParameterDetailVO rentParameterDetailVO = (RentParameterDetailVO)parameterDetailList.get(num - 1);
            RentRentalCacheVO rentRentalCacheVO = cacheList.get(size - 1);
            if (RentEquipmentStateEnum.\u9000\u573a.getCode().equals(rentParameterDetailVO.getEquipmentState()) && !rentParameterDetailVO.getOperationDate().before(rentRentalCacheVO.getEndDate())) {
                ((RentParameterDetailVO)parameterDetailList.get(num - 1)).setOperationDate(rentRentalCacheVO.getEndDate());
            } else if (!RentEquipmentStateEnum.\u9000\u573a.getCode().equals(rentParameterDetailVO.getEquipmentState()) || !rentParameterDetailVO.getOperationDate().before(rentRentalCacheVO.getEndDate())) {
                RentParameterDetailVO endRentParameterDetailVO = new RentParameterDetailVO();
                endRentParameterDetailVO.setOperationDate(rentRentalCacheVO.getEndDate());
                endRentParameterDetailVO.setEquipmentState(rentParameterDetailVO.getEquipmentState());
                endRentParameterDetailVO.setSourceType("2");
                parameterDetailList.add(endRentParameterDetailVO);
            }
        }
        ArrayList<RentRentalCacheVO> newResultList = new ArrayList<RentRentalCacheVO>();
        List<RentRentalCacheVO> resultList2 = new ArrayList<RentRentalCacheVO>();
        parameterDetailList.sort(Comparator.comparing(RentParameterDetailVO::getOperationDate));
        if (CollectionUtils.isNotEmpty(cacheList) && cacheList.size() == 1) {
            for (int i = 0; i < parameterDetailList.size(); ++i) {
                RentParameterDetailVO detailVO2 = (RentParameterDetailVO)parameterDetailList.get(i);
                RentRentalCacheVO rstVo = new RentRentalCacheVO();
                this.setRecordByRentType(cacheList.get(0), rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO2.getOperationDate());
                rstVo.setEquipmentState(detailVO2.getEquipmentState());
                rstVo.setParameterType(detailVO2.getSourceType());
                newResultList.add(rstVo);
            }
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                cacheList.get(0).setStartDate(dateFormat.parse("2000-01-01 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < parameterDetailList.size(); ++i) {
                detailVO = (RentParameterDetailVO)parameterDetailList.get(i);
                RentRentalCacheVO conCacheVO = cacheList.get(0);
                if (0 == i) {
                    for (int k = 0; k < cacheList.size(); ++k) {
                        Date conStartDate = cacheList.get(k).getStartDate();
                        Date c1 = detailVO.getOperationDate();
                        if (!c1.after(conStartDate)) continue;
                        conCacheVO = cacheList.get(k);
                    }
                    RentRentalCacheVO rstVo = new RentRentalCacheVO();
                    this.setRecordByRentType(conCacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    newResultList.add(rstVo);
                    continue;
                }
                RentParameterDetailVO detailVOLast = (RentParameterDetailVO)parameterDetailList.get(i - 1);
                for (int k = 0; k < cacheList.size(); ++k) {
                    Date conStartDate = cacheList.get(k).getStartDate();
                    Date c1 = detailVO.getOperationDate();
                    Date c2 = detailVOLast.getOperationDate();
                    if (!c1.after(conStartDate)) continue;
                    conCacheVO = cacheList.get(k);
                    if (!c2.before(conStartDate)) continue;
                    RentRentalCacheVO rstVo = new RentRentalCacheVO();
                    this.setRecordByRentType(cacheList.get(k), rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(cacheList.get(k).getStartDate());
                    rstVo.setEquipmentState(detailVOLast.getEquipmentState());
                    rstVo.setParameterType("-1");
                    newResultList.add(rstVo);
                }
                RentRentalCacheVO rstVo = new RentRentalCacheVO();
                this.setRecordByRentType(conCacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                rstVo.setStartDate(detailVO.getOperationDate());
                rstVo.setEquipmentState(detailVO.getEquipmentState());
                rstVo.setParameterType(detailVO.getSourceType());
                newResultList.add(rstVo);
            }
        }
        if (CollectionUtils.isNotEmpty(newResultList)) {
            for (int i = 1; i < newResultList.size(); ++i) {
                RentRentalCacheVO detailVOLast = (RentRentalCacheVO)newResultList.get(i - 1);
                detailVO = (RentRentalCacheVO)newResultList.get(i);
                if (i == newResultList.size() - 1) {
                    detailVOLast.setEndDate(detailVO.getStartDate());
                } else {
                    detailVOLast.setEndDate(this.daySubOne(detailVO.getStartDate()));
                }
                if (detailVOLast.getEndDate().before(detailVOLast.getStartDate())) continue;
                resultList2.add(detailVOLast);
            }
        }
        resultList2 = this.packResultCacheVo(resultList2, monthSettlement);
        resultList.addAll(resultList2);
        this.logger.info("\u79df\u8d41\u65b9\u5f0f\uff1a{}\uff0c\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)rentType, (Object)JSONObject.toJSONString(resultList));
    }

    private boolean checkCacheVoIsMerge(RentRentalCacheVO vo1, RentRentalCacheVO vo2) {
        BigDecimal price2;
        BigDecimal price1;
        if (!vo1.getEquipmentState().equals(vo2.getEquipmentState())) {
            return true;
        }
        if (RENT_TYPE_DAY.equals(vo1.getRentType())) {
            if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentDayRecord().getDayRentPrice();
                price2 = vo2.getRentDayRecord().getDayRentPrice();
            } else {
                price1 = vo1.getRentDayRecord().getStopRentPrice();
                price2 = vo2.getRentDayRecord().getStopRentPrice();
            }
        } else if (RENT_TYPE_MONTH.equals(vo1.getRentType())) {
            if (RentEquipmentStateEnum.\u542f\u7528.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentMonthRecord().getMonthRentPrice();
                price2 = vo2.getRentMonthRecord().getMonthRentPrice();
            } else {
                price1 = vo1.getRentMonthRecord().getStopRentPrice();
                price2 = vo2.getRentMonthRecord().getStopRentPrice();
            }
        } else if (RENT_TYPE_QUANTITIES.equals(vo1.getRentType())) {
            price1 = vo1.getRentQuantitiesRecord().getQuantitiesPrice();
            price2 = vo2.getRentQuantitiesRecord().getQuantitiesPrice();
        } else {
            return true;
        }
        if (price1.equals(price2)) {
            vo1.setEndDate(vo2.getEndDate());
            return false;
        }
        return true;
    }

    private List<RentRentalCacheVO> packResultCacheVo(List<RentRentalCacheVO> resultList, String monthSettlement) {
        ArrayList<RentRentalCacheVO> rtnList = new ArrayList<RentRentalCacheVO>();
        for (RentRentalCacheVO vo : resultList) {
            if (RENT_TYPE_MONTH.equals(vo.getRentType())) {
                Date ed;
                Date endUpDate;
                Date startBeginDate = this.monthDay(vo.getStartDate(), monthSettlement);
                Date startEndDate = this.monthDay(this.monthAddOne(vo.getStartDate()), monthSettlement);
                Date endBeginDate = this.monthDay(vo.getEndDate(), monthSettlement);
                Date endEndDate = this.monthDay(this.monthAddOne(vo.getEndDate()), monthSettlement);
                if (!vo.getStartDate().after(startBeginDate)) {
                    if (!vo.getEndDate().after(startBeginDate)) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (!vo.getEndDate().before(startBeginDate) && !vo.getEndDate().after(startEndDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        this.setRstValue(this.dayAddOne(startBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        if (endUpDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startBeginDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        } else {
                            this.setRstValue(this.dayAddOne(startBeginDate), startEndDate, vo, rtnList);
                            ed = startEndDate;
                        }
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        if (!endBeginDate.before(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startBeginDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                if (vo.getStartDate().after(startBeginDate)) {
                    if (!vo.getEndDate().after(startEndDate)) {
                        rtnList.add(vo);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        if (endUpDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startEndDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        } else {
                            ed = startEndDate;
                        }
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        if (endBeginDate.after(startEndDate)) {
                            this.setRstValue(this.dayAddOne(startEndDate), endBeginDate, vo, rtnList);
                        }
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                        continue;
                    }
                    rtnList.add(vo);
                    continue;
                }
                rtnList.add(vo);
                continue;
            }
            rtnList.add(vo);
        }
        rtnList.sort(Comparator.comparing(RentRentalCacheVO::getStartDate));
        return rtnList;
    }

    private void setRstValue(Date start, Date end, RentRentalCacheVO vo, List<RentRentalCacheVO> rtnList) {
        RentRentalCacheVO rstvo1 = new RentRentalCacheVO();
        rstvo1.setStartDate(start);
        rstvo1.setEndDate(end);
        rstvo1.setEquipmentState(vo.getEquipmentState());
        rstvo1.setRentType(vo.getRentType());
        rstvo1.setRentMonthRecord(vo.getRentMonthRecord());
        rstvo1.setParameterId(vo.getParameterId());
        rstvo1.setParameterType(vo.getParameterType());
        rtnList.add(rstvo1);
    }

    private void setRecordByRentType(RentRentalCacheVO cacheVO, RentRentalCacheVO rstVo, Integer rentType) {
        if (RENT_TYPE_DAY.equals(rentType)) {
            rstVo.setRentDayRecord(cacheVO.getRentDayRecord());
        } else if (RENT_TYPE_MONTH.equals(rentType)) {
            rstVo.setRentMonthRecord(cacheVO.getRentMonthRecord());
        } else if (RENT_TYPE_QUANTITIES.equals(rentType)) {
            rstVo.setRentQuantitiesRecord(cacheVO.getRentQuantitiesRecord());
        }
    }

    private Map<Integer, Map<Long, List<RentRentalCacheVO>>> getContractRecord(Long contractId, RentContractEntity contractEntity, Date endDate) {
        HashMap<Integer, Map<Long, List<RentRentalCacheVO>>> rtnMap = new HashMap<Integer, Map<Long, List<RentRentalCacheVO>>>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("changeDate", new Parameter("le", (Object)endDate));
        queryParam.getOrderMap().put("changeDate", "asc");
        List recordList = this.contractRecordService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            this.packContractMap(contractEntity, rtnMap, contractEntity.getSignedDate(), endDate);
            this.logger.info("\u5408\u540c\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u8bb0\u5f55\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
            return rtnMap;
        }
        List recordIdList = recordList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("recordId", new Parameter("in", recordIdList));
        List dayRecordEntityList = this.dayRecordService.queryList(detailParam, false);
        List monthRecordEntityList = this.monthRecordService.queryList(detailParam, false);
        List quantitiesRecordEntityList = this.quantitiesRecordService.queryList(detailParam, false);
        HashMap dayMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dayRecordEntityList)) {
            for (Object dayRecordEntity : dayRecordEntityList) {
                if (dayMap.containsKey(dayRecordEntity.getRecordId())) {
                    ((List)dayMap.get(dayRecordEntity.getRecordId())).add(dayRecordEntity);
                    continue;
                }
                ArrayList<Object> packList = new ArrayList<Object>();
                packList.add(dayRecordEntity);
                dayMap.put(dayRecordEntity.getRecordId(), packList);
            }
        }
        HashMap monthMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)monthRecordEntityList)) {
            for (Object monthRecordEntity : monthRecordEntityList) {
                if (monthMap.containsKey(monthRecordEntity.getRecordId())) {
                    ((List)monthMap.get(monthRecordEntity.getRecordId())).add(monthRecordEntity);
                    continue;
                }
                ArrayList<Object> packList = new ArrayList<Object>();
                packList.add(monthRecordEntity);
                monthMap.put(monthRecordEntity.getRecordId(), packList);
            }
        }
        HashMap quantitiesMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)quantitiesRecordEntityList)) {
            for (RentQuantitiesRecordEntity quantitiesRecordEntity : quantitiesRecordEntityList) {
                if (quantitiesMap.containsKey(quantitiesRecordEntity.getRecordId())) {
                    ((List)quantitiesMap.get(quantitiesRecordEntity.getRecordId())).add(quantitiesRecordEntity);
                    continue;
                }
                ArrayList<RentQuantitiesRecordEntity> packList = new ArrayList<RentQuantitiesRecordEntity>();
                packList.add(quantitiesRecordEntity);
                quantitiesMap.put(quantitiesRecordEntity.getRecordId(), packList);
            }
        }
        Date startDate = null;
        Date recordEndDate = null;
        for (int i = 0; i < recordList.size(); ++i) {
            Map<Long, List<Object>> detailMap;
            RentRentalCacheVO cacheVO;
            RentContractRecordEntity recordEntity = (RentContractRecordEntity)((Object)recordList.get(i));
            recordEntity.setRentDayDetailedList((List)dayMap.get(recordEntity.getId()));
            recordEntity.setRentMonthDetailedList((List)monthMap.get(recordEntity.getId()));
            recordEntity.setRentQuantitiesDetailedList((List)quantitiesMap.get(recordEntity.getId()));
            if (startDate == null) {
                startDate = recordEntity.getSignedDate();
            }
            if (startDate.after(recordEndDate = recordEntity.getChangeDate())) continue;
            if (CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())) {
                HashMap<Long, List<RentRentalCacheVO>> recordDayMap = (HashMap<Long, List<RentRentalCacheVO>>)rtnMap.get(RENT_TYPE_DAY);
                if (recordDayMap == null) {
                    recordDayMap = new HashMap<Long, List<RentRentalCacheVO>>();
                }
                for (RentDayRecordEntity rentDayRecordEntity : recordEntity.getRentDayDetailedList()) {
                    cacheVO = new RentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_DAY);
                    cacheVO.setEquipmentId(rentDayRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentDayRecord((RentDayRecordVO)BeanMapper.map((Object)((Object)rentDayRecordEntity), RentDayRecordVO.class));
                    this.packCacheMap(cacheVO, recordDayMap);
                }
                rtnMap.put(RENT_TYPE_DAY, recordDayMap);
            }
            if (CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())) {
                detailMap = (HashMap<Long, List<RentRentalCacheVO>>)rtnMap.get(RENT_TYPE_MONTH);
                if (detailMap == null) {
                    detailMap = new HashMap<Long, List<RentRentalCacheVO>>();
                }
                for (RentMonthRecordEntity rentMonthRecordEntity : recordEntity.getRentMonthDetailedList()) {
                    cacheVO = new RentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_MONTH);
                    cacheVO.setEquipmentId(rentMonthRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentMonthRecord((RentMonthRecordVO)BeanMapper.map((Object)((Object)rentMonthRecordEntity), RentMonthRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_MONTH, detailMap);
            }
            if (CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())) {
                detailMap = (Map)rtnMap.get(RENT_TYPE_QUANTITIES);
                if (detailMap == null) {
                    detailMap = new HashMap();
                }
                for (RentQuantitiesRecordEntity rentQuantitiesRecordEntity : recordEntity.getRentQuantitiesDetailedList()) {
                    cacheVO = new RentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                    cacheVO.setEquipmentId(rentQuantitiesRecordEntity.getEquipmentId());
                    cacheVO.setStartDate(startDate);
                    cacheVO.setEndDate(this.daySubOne(recordEndDate));
                    cacheVO.setContractType(Integer.valueOf(1));
                    cacheVO.setRentQuantitiesRecord((RentQuantitiesRecordVO)BeanMapper.map((Object)((Object)rentQuantitiesRecordEntity), RentQuantitiesRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
            }
            startDate = recordEntity.getChangeDate();
        }
        this.packContractMap(contractEntity, rtnMap, recordEndDate, endDate);
        this.logger.info("\u5904\u7406\u5408\u540c\u4fe1\u606f\u7ed3\u675f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnMap));
        return rtnMap;
    }

    private void packCacheMap(RentRentalCacheVO cacheVO, Map<Long, List<RentRentalCacheVO>> map) {
        if (map == null) {
            map = new HashMap<Long, List<RentRentalCacheVO>>();
        }
        if (map.containsKey(cacheVO.getEquipmentId())) {
            map.get(cacheVO.getEquipmentId()).add(cacheVO);
        } else {
            ArrayList<RentRentalCacheVO> packList = new ArrayList<RentRentalCacheVO>();
            packList.add(cacheVO);
            map.put(cacheVO.getEquipmentId(), packList);
        }
    }

    private void packContractMap(RentContractEntity contractEntity, Map<Integer, Map<Long, List<RentRentalCacheVO>>> rtnMap, Date startDate, Date endDate) {
        RentRentalCacheVO cacheVO;
        Map<Long, List<RentRentalCacheVO>> detailMap;
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_DAY);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<RentRentalCacheVO>>();
            }
            for (RentDayDetailedEntity rentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                cacheVO = new RentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_DAY);
                cacheVO.setEquipmentId(rentDayDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentDayRecord((RentDayRecordVO)BeanMapper.map((Object)((Object)rentDayDetailedEntity), RentDayRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_DAY, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_MONTH);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<RentRentalCacheVO>>();
            }
            for (RentMonthDetailedEntity rentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                cacheVO = new RentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_MONTH);
                cacheVO.setEquipmentId(rentMonthDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentMonthRecord((RentMonthRecordVO)BeanMapper.map((Object)((Object)rentMonthDetailedEntity), RentMonthRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_MONTH, detailMap);
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            detailMap = rtnMap.get(RENT_TYPE_QUANTITIES);
            if (detailMap == null) {
                detailMap = new HashMap<Long, List<RentRentalCacheVO>>();
            }
            for (RentQuantitiesDetailedEntity rentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                cacheVO = new RentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                cacheVO.setEquipmentId(rentQuantitiesDetailedEntity.getEquipmentId());
                cacheVO.setStartDate(startDate);
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(Integer.valueOf(0));
                cacheVO.setRentQuantitiesRecord((RentQuantitiesRecordVO)BeanMapper.map((Object)((Object)rentQuantitiesDetailedEntity), RentQuantitiesRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
        }
    }

    private Integer daysBetween(Date smdate, Date bdate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u671f\u8ba1\u7b97\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private Date monthDay(Date date, String monthSettlement) {
        Calendar from = Calendar.getInstance();
        from.setTime(date);
        int fromYear = from.get(1);
        int fromMonth = from.get(2);
        if ("29".equals(monthSettlement)) {
            if (0 == fromMonth) {
                monthSettlement = "31";
            } else if (1 == fromMonth) {
                monthSettlement = "28";
            } else if (2 == fromMonth) {
                monthSettlement = "31";
            } else if (3 == fromMonth) {
                monthSettlement = "30";
            } else if (4 == fromMonth) {
                monthSettlement = "31";
            } else if (5 == fromMonth) {
                monthSettlement = "30";
            } else if (6 == fromMonth) {
                monthSettlement = "31";
            } else if (7 == fromMonth) {
                monthSettlement = "31";
            } else if (8 == fromMonth) {
                monthSettlement = "30";
            } else if (9 == fromMonth) {
                monthSettlement = "31";
            } else if (10 == fromMonth) {
                monthSettlement = "30";
            } else if (11 == fromMonth) {
                monthSettlement = "31";
            }
        }
        int settlement = Integer.parseInt(monthSettlement);
        GregorianCalendar myCalendar = new GregorianCalendar(fromYear, fromMonth, settlement);
        return myCalendar.getTime();
    }

    private Date dayAddOne(Date date) {
        return this.calculationDay(date, 1);
    }

    private Date daySubOne(Date date) {
        return this.calculationDay(date, -1);
    }

    private Date calculationDay(Date date, Integer days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    private Date monthAddOne(Date date) {
        return this.calculationMonth(date, 1);
    }

    private Date calculationMonth(Date date, Integer month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    private BigDecimal getMny(BigDecimal bigDecimal, Integer days, Integer nums) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.multiply(new BigDecimal(days)).multiply(new BigDecimal(nums));
    }

    public int[] dayCompare(Date fromDate, Date toDate) {
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }

    private boolean isDetailDel(String rowState) {
        return "del".equals(rowState);
    }
}

