/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.purchaseApply.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyDetailedRefVO;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyDetailedVO;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.business.proequipmentcorppur.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseApply"})
public class PurchaseApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PURCHASE_PLAN";
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IPurchaseApplyService service;
    @Autowired
    private IPurchaseApplyDetailedService purchaseApplyDetailedService;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseApplyVO> saveOrUpdate(@RequestBody PurchaseApplyVO saveOrUpdateVO) {
        PurchaseApplyEntity entity = (PurchaseApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchaseApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else if (this.service.checkSameBillCode((PurchaseApplyVO)BeanMapper.map((Object)((Object)entity), PurchaseApplyVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        this.service.saveOrUpdates(entity);
        PurchaseApplyVO vo = (PurchaseApplyVO)BeanMapper.map((Object)((Object)entity), PurchaseApplyVO.class);
        vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseApplyVO> queryDetail(Long id) {
        PurchaseApplyEntity entity = (PurchaseApplyEntity)((Object)this.service.selectById(id));
        PurchaseApplyVO vo = (PurchaseApplyVO)BeanMapper.map((Object)((Object)entity), PurchaseApplyVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getDetailList())) {
            vo.setDetailList(TreeNodeBUtil.buildTree((List)vo.getDetailList()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, PurchaseApplyVO.class);
            for (PurchaseApplyVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("purchaseApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PurchaseApplyVO> refPurchaseApplyData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject _con;
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && (projectId = (_con = JSONObject.parseObject((String)condition)).getLong("projectId")) == null) {
            throw new BusinessException("\u9879\u76eeid\u5fc5\u987b\u4f20\uff01");
        }
        List<PurchaseApplyVO> dataList = this.service.queryApplyList(projectId);
        return dataList;
    }

    @RequestMapping(value={"/refPurchaseApplyDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyVO>> refPurchaseApplyDataByProjectId(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam params = new QueryParam();
        params.setPageSize(pageSize.intValue());
        params.setPageIndex(pageNumber.intValue());
        params.setSearchText(searchText);
        params.setSearchObject(searchObject);
        Long projectId = null;
        Long orgId = null;
        params.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
        }
        params.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        params.getParams().put("planState", new Parameter("eq", (Object)0));
        if (projectId != null) {
            CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
            if (!projectResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            params.getParams().put("projectId", new Parameter("in", projectResponse.getData()));
        }
        if (orgId != null) {
            CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
            OrgVO orgVO = (OrgVO)orgResp.getData();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                params.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                params.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(params, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseApplyVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List batApplyVOList = pageData.getRecords();
            List idList = batApplyVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter("in", idList));
            detailParam.getParams().put("doc_id", new Parameter("ne", null));
            List detailEntityList = this.purchaseApplyDetailedService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, PurchaseApplyDetailedVO.class);
            HashMap detailMap = new HashMap();
            for (PurchaseApplyDetailedVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getApplyId())) {
                    ((List)detailMap.get(vo.getApplyId())).add(vo);
                    continue;
                }
                ArrayList<PurchaseApplyDetailedVO> mapList = new ArrayList<PurchaseApplyDetailedVO>();
                mapList.add(vo);
                detailMap.put(vo.getApplyId(), mapList);
            }
            batApplyVOList.forEach(batApplyVO -> batApplyVO.setDetailList((List)detailMap.get(batApplyVO.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchaseApplyDetailedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyDetailedRefVO>> refPurchaseApplyDetailedData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentType");
        fuzzyFields.add("equipmentName");
        Long planId = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            planId = Long.parseLong(relyCondition.split("=")[1]);
        }
        if (planId != null) {
            param.getParams().put("planId", new Parameter("eq", (Object)planId));
            param.getParams().put("leafFlag", new Parameter("eq", (Object)false));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.purchaseApplyDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseApplyDetailedRefVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

