/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractRelieveEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractRelieveService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractRelieveVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRelieve")
public class ContractRelieveBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            if (entity.getDraftType() == 2) {
                entity.setSignatureStatus("4");
                entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()));
                entity.setEffectiveDate(new Date());
                this.service.saveOrUpdate((Object)entity, false);
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter("eq", (Object)entity.getContractId()));
                List contractEntities = this.contractService.queryList(param, false);
                ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
                this.contractService.saveOrUpdate(contractEntities.get(0), false);
                this.contractService.pushContract((ContractVO)((Object)BeanMapper.map(contractEntities.get(0), ContractVO.class)));
            } else if (entity.getDraftType() == 1) {
                entity.setSignatureStatus("1");
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u521d\u59cb\u5316\u6210\u672a\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                this.service.saveOrUpdate((Object)entity, false);
            }
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/contractRelieve/card?id=" + entity.getId();
        ExecutionVO executionVO = this.service.targetCost((ContractRelieveVO)((Object)BeanMapper.map((Object)((Object)entity), ContractRelieveVO.class)), linkUrl, contractEntity.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u5904\u7406\u6210\u529f!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
            return CommonResponse.error((String)("\u5408\u540c\u89e3\u9664" + (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus()) ? "\u5df2\u751f\u6548" : "\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b") + "\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!"));
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus())) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode()));
            this.service.saveOrUpdate((Object)entity, false);
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.contractService.pushContract((ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)));
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

