/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.order.bean.RentOrderEntity;
import com.ejianc.business.proequipmentcorprent.order.service.IRentOrderService;
import com.ejianc.business.proequipmentcorprent.order.vo.RentOrderExportVO;
import com.ejianc.business.proequipmentcorprent.order.vo.RentOrderVO;
import com.ejianc.business.proequipmentcorprent.order.vo.SupRentOrderVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentOrder"})
@Api(value="\u79df\u8d41\u8ba2\u5355", tags={"\u79df\u8d41\u8ba2\u5355"})
public class RentOrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String BILL_CODE = "CORP_RENT_ORDER";
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private final String billTypeCode = "EJCBT202210000012";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipment/card";
    @Autowired
    private IRentOrderService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentOrderVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentOrderVO saveOrUpdateVO) {
        RentOrderVO vo = this.service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentOrderVO> queryDetail(@RequestParam Long id) {
        RentOrderVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateOrderFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateOrderFlag(@RequestBody RentOrderVO vo) {
        return this.service.updateOrderFlag(vo);
    }

    @RequestMapping(value={"/updateReceived"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentOrderVO> updateReceived(@RequestBody SupRentOrderVO saveorUpdateVO) {
        return this.service.updateReceived(saveorUpdateVO);
    }

    @RequestMapping(value={"/updateDeliverState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentOrderVO> updateDeliverState(@RequestBody SupRentOrderVO saveorUpdateVO) {
        return this.service.updateDeliverState(saveorUpdateVO);
    }

    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        RentOrderEntity entity = (RentOrderEntity)((Object)this.service.selectById(id));
        return this.shareCooperateApi.getShareLink(id, "EJCBT202210000012", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proEquipment/card", null);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentOrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RentOrderVO rentOrderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentOrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList<RentOrderExportVO> voList = new ArrayList<RentOrderExportVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RentOrderEntity orderEntity : list) {
                RentOrderExportVO map = (RentOrderExportVO)BeanMapper.map((Object)((Object)orderEntity), RentOrderExportVO.class);
                map.setBillState(BillStateEnum.getEnumByStateCode((Integer)orderEntity.getBillState()).getDescription());
                if (null != orderEntity.getReceiveState()) {
                    switch (orderEntity.getReceiveState()) {
                        case 0: {
                            map.setReceiveState("\u5f85\u63a5\u6536");
                            break;
                        }
                        case 2: {
                            map.setReceiveState("\u90e8\u5206\u63a5\u6536");
                            break;
                        }
                        case 1: {
                            map.setReceiveState("\u5168\u90e8\u63a5\u6536");
                            break;
                        }
                        case 3: {
                            map.setReceiveState("\u4e0d\u4e88\u63a5\u6536");
                        }
                    }
                }
                if (null != orderEntity.getDeliverState()) {
                    switch (orderEntity.getDeliverState()) {
                        case 0: {
                            map.setDeliverState("\u5f85\u9001\u8d27");
                            break;
                        }
                        case 1: {
                            map.setDeliverState("\u90e8\u5206\u9001\u8d27");
                            break;
                        }
                        case 2: {
                            map.setDeliverState("\u5df2\u9001\u8d27");
                        }
                    }
                }
                if (null != orderEntity.getOrderFlag()) {
                    switch (orderEntity.getOrderFlag()) {
                        case 0: {
                            map.setOrderFlag("\u6b63\u5e38");
                            break;
                        }
                        case 1: {
                            map.setOrderFlag("\u5df2\u5173\u95ed");
                        }
                    }
                }
                voList.add(map);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("RentOrder-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refRentOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentOrderVO>> refRentOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

