/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentAcceptanceMapper;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentAcceptanceSubMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceSubService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryDetailEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryDetailService;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="rentAcceptanceService")
public class RentAcceptanceServiceImpl
extends BaseServiceImpl<RentAcceptanceMapper, RentAcceptanceEntity>
implements IRentAcceptanceService {
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentAcceptanceSubService rentAcceptanceSubService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String OPERATE = "CORP_RENT_CHECK";
    private static final String BILL_TYPE_CODE = "EJCBT202210000025";
    @Autowired
    private RentAcceptanceMapper acceptanceMapper;
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IRentEquipmentStopService rentEquipmentStopService;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private RentAcceptanceSubMapper rentAcceptanceSubMapper;
    @Autowired
    private IRentDeliveryService rentDeliveryService;
    @Autowired
    private IRentDeliveryDetailService rentDeliveryDetailService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentDelivery/saveEquipmentDeliveryState";

    @Override
    public void saveOrUpdates(RentAcceptanceEntity entity) {
        this.valiDataSave(entity);
    }

    public void valiDataSave(RentAcceptanceEntity entity) {
        if (DateUtil.compareDate((Date)entity.getRentDate(), (Date)entity.getAcceptanceDate()) == -1) {
            throw new BusinessException("\u8ba1\u79df\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9a8c\u6536\u65e5\u671f");
        }
        RentAcceptanceEntity validaAcceptanceEntity = this.selectByContractId(entity.getContractId());
        if (validaAcceptanceEntity != null && entity.getId() == null) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e");
        }
        if (validaAcceptanceEntity != null && entity.getId() != null && entity.getId() != null && !entity.getId().equals(validaAcceptanceEntity.getId())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e");
        }
        RentEquipmentStartEntity vStartEntity = this.rentEquipmentStartService.selectByContractIdEquipmentStart(entity.getContractId());
        if (vStartEntity != null && vStartEntity.getContractId() != entity.getContractId()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8bbe\u5907\u542f\u7528\u5355\u636e");
        }
        RentEquipmentStopEntity vStopEntity = this.rentEquipmentStopService.selectByEquipmentStop(entity.getContractId());
        if (vStopEntity != null && vStopEntity.getContractId() != entity.getContractId()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8bbe\u5907\u505c\u7528\u5355\u636e");
        }
        CommonResponse<String> commonResponse = this.rentParameterService.selectValidationNewDate(entity.getContractId(), entity.getAcceptanceDate(), entity.getId());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        if (CollectionUtils.isNotEmpty(entity.getRentAcceptanceSubList())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List<RentAcceptanceSubEntity> subList = entity.getRentAcceptanceSubList();
            EquipmentNewDateVO subDate = this.rentParameterService.selectValidationNewDateSub(entity.getContractId());
            for (int i = 0; i < subList.size(); ++i) {
                RentAcceptanceSubEntity sub = entity.getRentAcceptanceSubList().get(i);
                if (subDate != null && DateUtil.compareDate((Date)sub.getMeterRentDate(), (Date)subDate.getPerformDate()) == -1) {
                    throw new BusinessException("\u8bbe\u5907\u6e05\u5355\u65e5\u671f\u4e0d\u662f\u6700\u65b0\u65e5\u671f,\u6700\u65b0\u65e5\u671f:" + sdf.format(subDate.getPerformDate()));
                }
                if (StringUtils.isEmpty((CharSequence)sub.getFactoryCode())) {
                    sub.setFactoryCode(RentAcceptanceServiceImpl.randomCode() + "");
                }
                for (int j = i + 1; j < subList.size(); ++j) {
                    RentAcceptanceSubEntity subEntity = (RentAcceptanceSubEntity)((Object)subList.get(j));
                    if (!sub.getFactoryCode().equals(subEntity.getFactoryCode())) continue;
                    throw new BusinessException("\u8bbe\u5907\u51fa\u573a\u7f16\u7801\u91cd\u590d" + subEntity.getFactoryCode());
                }
                RentAcceptanceSubEntity rentAcceptanceSubEntity = this.selectFactoryCode(sub.getFactoryCode());
                if (rentAcceptanceSubEntity != null && sub.getId() != null && !rentAcceptanceSubEntity.getId().equals(sub.getId())) {
                    throw new BusinessException("\u8bbe\u5907\u51fa\u573a\u7f16\u7801\u91cd\u590d" + rentAcceptanceSubEntity.getFactoryCode());
                }
                if (sub.getId() != null || rentAcceptanceSubEntity == null) continue;
                throw new BusinessException("\u8bbe\u5907\u51fa\u573a\u7f16\u7801\u91cd\u590d" + rentAcceptanceSubEntity.getFactoryCode());
            }
        }
        List<RentAcceptanceSubEntity> rentAcceptanceSubList = entity.getRentAcceptanceSubList();
        for (RentAcceptanceSubEntity rentAcceptanceSubEntity : rentAcceptanceSubList) {
            rentAcceptanceSubEntity.setNum(1);
        }
        this.saveOrUpdate((Object)entity, false);
        if (entity.getAcceptanceSourceId() == 2) {
            CommonResponse ejcCloudSystemCode;
            Integer checkStatus = 0;
            RentDeliveryEntity deliveryEntity = (RentDeliveryEntity)((Object)this.rentDeliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaCheckDetail = Wrappers.lambdaQuery();
            lambdaCheckDetail.eq(RentAcceptanceSubEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.rentAcceptanceSubService.list((Wrapper)lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<RentAcceptanceSubEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(RentAcceptanceSubEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(RentDeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.rentDeliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<RentAcceptanceSubEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        Integer checkNum = checkAllDetailEntityList.stream().mapToInt(RentAcceptanceSubEntity::getNum).sum();
                        deliveryDetailEntity.setCheckNum(BigDecimal.valueOf(checkNum.intValue()));
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                deliveryEntity.setCheckStatus(checkStatus);
                this.rentDeliveryService.updateById((Object)deliveryEntity);
                this.rentDeliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
            if (!(ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode()).isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", deliveryEntity.getSourceId());
            map.put("checkStatus", checkStatus);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentDeliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/equipmentDelivery/saveEquipmentDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "CORP_RENT_CHECK", BILL_TYPE_CODE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    public RentAcceptanceEntity selectByContractId(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"bill_state", (Object)"0");
        List list = this.acceptanceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)list.get(0));
            return entity;
        }
        return null;
    }

    @Override
    public void deletes(List<RentAcceptanceVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        RentAcceptanceVO checkVO = vos.get(0);
        RentAcceptanceEntity checkEntity = (RentAcceptanceEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        List<RentAcceptanceSubEntity> checkDetailList = checkEntity.getRentAcceptanceSubList();
        RentDeliveryEntity deliveryEntity = (RentDeliveryEntity)((Object)this.rentDeliveryService.selectById(checkEntity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<RentDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(RentAcceptanceSubEntity::getDeliveryDetailId, Function.identity()));
            for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                RentAcceptanceSubEntity checkDetailEntity = (RentAcceptanceSubEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(BigDecimal.valueOf(checkDetailEntity.getNum().intValue())));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
            Integer checkStatus = 0;
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckStatus(checkStatus);
            this.rentDeliveryService.updateById((Object)deliveryEntity);
            this.rentDeliveryDetailService.updateBatchById(deliveryDetailList);
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", deliveryEntity.getSourceId());
            map.put("checkStatus", checkStatus);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentDeliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/equipmentDelivery/saveEquipmentDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "CORP_RENT_CHECK", BILL_TYPE_CODE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        RentAcceptanceEntity checkEntity = (RentAcceptanceEntity)((Object)super.selectById((Serializable)((Object)billId)));
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "EJCBT202210000025::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"CORP_RENT_CHECK", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "CORP_RENT_CHECK");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE_CODE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "CORP_RENT_CHECK");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        this.logger.info("dataInfo" + datInfo);
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"CORP_RENT_CHECK", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "CORP_RENT_CHECK");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", datInfo);
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)supplierId, (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId.toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, sourceId, billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{sourceId, supplierId, syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceId, (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{sourceId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "CORP_RENT_CHECK");
        }
        return syncFlag;
    }

    public RentAcceptanceSubEntity selectFactoryCode(String factoryCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"factory_code", (Object)factoryCode);
        List list = this.rentAcceptanceSubMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            RentAcceptanceSubEntity entity = (RentAcceptanceSubEntity)((Object)list.get(0));
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    private static Long randomCode() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        secureRandom.setSeed(1000000L);
        return (long)secureRandom.nextInt(10000) + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(RentAcceptanceEntity::getProjectId, (Object)projectId)).eq(RentAcceptanceEntity::getAcceptanceDate, (Object)checkDate);
        return super.count((Wrapper)lambdaQuery);
    }
}

