/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalDayEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalMonthEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentRental")
public class RentRentalBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentRentalService service;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IRentParameterService parameterService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentRentalEntity entity = (RentRentalEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        this.service.costPush(entity);
        if ("1".equals(entity.getRentalType())) {
            List<RentParameterVO> rentParameterList = this.parameterService.getRentParameterByContractId(entity.getContractId(), entity.getId(), entity.getRentalDate());
            ArrayList<RentParameterEntity> parameterEntityList = new ArrayList<RentParameterEntity>();
            for (RentParameterVO rentParameterVO : rentParameterList) {
                RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)BeanMapper.map((Object)rentParameterVO, RentParameterEntity.class));
                rentParameterEntity.setOperationDate(entity.getRentalDate());
                ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode());
                detailEntity.setSourceId(entity.getId());
                detailEntity.setOperationDate(entity.getRentalDate());
                detailEntity.setEquipmentState(rentParameterEntity.getEquipmentState());
                detailEntity.setParameterId(rentParameterEntity.getId());
                parameterDetailList.add(detailEntity);
                rentParameterEntity.setRentParameterDetailList(parameterDetailList);
                parameterEntityList.add(rentParameterEntity);
            }
            this.parameterService.changeParameter(parameterEntityList, RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        RentRentalEntity entity = (RentRentalEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(RentRentalEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        if ("1".equals(entity.getRentalType())) {
            List sourceIdList;
            ArrayList<Long> parameterIdList = new ArrayList<Long>();
            List<RentRentalDayEntity> dayList = entity.getRentRentalDayList();
            List<RentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
            List<RentRentalQuantitiesEntity> qList = entity.getRentRentalQuantitiesList();
            if (CollectionUtils.isNotEmpty(dayList)) {
                sourceIdList = dayList.stream().map(RentRentalDayEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(monthList)) {
                sourceIdList = monthList.stream().map(RentRentalMonthEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            if (CollectionUtils.isNotEmpty(qList)) {
                sourceIdList = qList.stream().map(RentRentalQuantitiesEntity::getSourceId).collect(Collectors.toList());
                parameterIdList.addAll(sourceIdList);
            }
            this.parameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u79df\u91d1\u8ba1\u7b97.getCode(), entity.getId());
        }
        return CommonResponse.success();
    }
}

