/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rentdelivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryDetailEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.mapper.RentDeliveryMapper;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryService;
import com.ejianc.business.proequipmentcorprent.rentdelivery.vo.RentDeliveryVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deliveryService")
public class RentDeliveryServiceImpl
extends BaseServiceImpl<RentDeliveryMapper, RentDeliveryEntity>
implements IRentDeliveryService {
    @Autowired
    private IRentDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentDelivery/saveEquipmentDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "RENT-DELIVERY";
    private final String OPERATE = "RENT-DELIVERY";
    private static final String BILL_TYPE_CODE = "EJCBT202210000024";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public RentAcceptanceVO queryDetailToCheck(Long id) {
        RentDeliveryEntity deliveryEntity = (RentDeliveryEntity)((Object)this.deliveryService.selectById(id));
        RentAcceptanceVO checkVO = new RentAcceptanceVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(Integer.valueOf(0));
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setProjectDepartmentId(deliveryEntity.getOrgId());
        checkVO.setProjectDepartmentName(deliveryEntity.getOrgName());
        checkVO.setCarCode(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setSourceType(Integer.valueOf(1));
        checkVO.setCompanyName(deliveryEntity.getOrgName());
        checkVO.setCompanyId(deliveryEntity.getOrgId());
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(deliveryEntity.getContractId()));
        List<RentDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)) {
            ArrayList<RentAcceptanceSubVO> checkDetailVOS = new ArrayList<RentAcceptanceSubVO>();
            for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                RentAcceptanceSubVO checkDetailVO = new RentAcceptanceSubVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setEquipmentId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setEquipmentCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setCategoryId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setCategoryName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setUnitName(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpecs(deliveryDetailEntity.getSpec());
                checkDetailVO.setRentTypeId(deliveryDetailEntity.getRentType());
                checkDetailVO.setRentTypeName(deliveryDetailEntity.getRentTypeName());
                checkDetailVO.setNum(Integer.valueOf(1));
                checkDetailVO.setRowState("add");
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setRentAcceptanceSubList(checkDetailVOS);
        }
        return checkVO;
    }

    @Override
    @Transactional
    public RentDeliveryVO closeDelivery(Long id) {
        RentDeliveryEntity deliveryEntity = (RentDeliveryEntity)((Object)super.selectById((Serializable)id));
        deliveryEntity.setCloseFlag(1);
        super.updateById((Object)deliveryEntity);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", deliveryEntity.getSourceId());
        map.put("closeFlag", 1);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/equipmentDelivery/saveEquipmentDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), BILL_CODE, BILL_TYPE_CODE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        return (RentDeliveryVO)BeanMapper.map((Object)((Object)deliveryEntity), RentDeliveryVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public RentDeliveryVO saveOrUpdates(RentDeliveryVO saveOrUpdateVO) {
        RentDeliveryEntity entity = (RentDeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentDeliveryEntity.class));
        List materialDeliveryDetailList = saveOrUpdateVO.getEquipmentDeliveryDetailList();
        List deliveryDetailEntityList = BeanMapper.mapList((Iterable)materialDeliveryDetailList, RentDeliveryDetailEntity.class);
        entity.setDeliveryDetailList(deliveryDetailEntityList);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        super.saveOrUpdate((Object)entity, false);
        RentDeliveryVO vo = (RentDeliveryVO)BeanMapper.map((Object)((Object)entity), RentDeliveryVO.class);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

