package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorppur.acceptance.mapper.PurchaseAcceptanceMapper;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;

import java.util.Date;
import java.util.List;

/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
@Service("purchaseAcceptanceService")
public class PurchaseAcceptanceServiceImpl extends BaseServiceImpl<PurchaseAcceptanceMapper, PurchaseAcceptanceEntity> implements IPurchaseAcceptanceService{

    @Override
    public IPage<PurchaseAcceptanceVO> refPurchaseAcceptanceData(QueryParam param, Long contractId, Integer pageNumber, Integer pageSize) {
        IPage<PurchaseAcceptanceVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PurchaseAcceptanceVO> list = baseMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param),contractId, page);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }


    /**
     * 根据项目id、验收日期查询设备采购单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Integer
     */
    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper<PurchaseAcceptanceEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(PurchaseAcceptanceEntity::getProjectId, projectId)
                .eq(PurchaseAcceptanceEntity::getAcceptanceDate, checkDate);
        return super.count(lambdaQuery);
    }
}
