package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotOutService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAllotInVO;
import com.ejianc.business.proequipmentcorppur.consts.AllocatEnum;
import com.ejianc.business.proequipmentcorppur.consts.AllocationState;
import com.ejianc.business.proequipmentcorppur.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetAllotInMapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotInEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotInService;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 固定资产调入表
 *
 * @author generator
 */
@Service("assetAllotInService")
public class AssetAllotInServiceImpl extends BaseServiceImpl<AssetAllotInMapper, AssetAllotInEntity> implements IAssetAllotInService {

    @Autowired
    private IAssetAllotInService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAssetAllotOutService assetAllotOutService;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
/** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentNames");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AssetAllotInEntity> list = service.queryList(param);
        List<AssetAllotInVO> allotInVos = BeanMapper.mapList(list, AssetAllotInVO.class);
        allotInVos.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotInVos);
        ExcelExport.getInstance().export("AssetAllotIn-export.xlsx", beans, response);
    }

    @Override
    public CommonResponse<String> sureToReceive(AssetAllotInVO vo) {
        AssetAllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        LambdaUpdateWrapper<AssetAllotInEntity> allotinWrapper = new LambdaUpdateWrapper<>();
        allotinWrapper.eq(AssetAllotInEntity::getId, vo.getId());
        allotinWrapper.set(AssetAllotInEntity::getReceiveDate, vo.getReceiveDate());
        allotinWrapper.set(AssetAllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        allotinWrapper.set(AssetAllotInEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
        allotinWrapper.set(AssetAllotInEntity::getPassDate, vo.getPassDate());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        boolean b = service.update(allotinWrapper);
        //会写调拨出库
        if (b) {
            LambdaUpdateWrapper<AssetAllotOutEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(AssetAllotOutEntity::getId, entity.getAllocatOutId());
            wrapper.set(AssetAllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
            wrapper.set(AssetAllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            wrapper.set(AssetAllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            wrapper.set(AssetAllotOutEntity::getReceiveDate, vo.getReceiveDate());
            assetAllotOutService.update(wrapper);
            //调入后，回写资产卡片里的使用项目为当前调入项目 begin
            entity.getAssetAllotInDetailList().forEach(item -> {
                LambdaUpdateWrapper<AssetEntity> assetWrapper = new LambdaUpdateWrapper<>();
                assetWrapper.eq(AssetEntity::getId, item.getAssetId());
                //上次摊销日期清空，收料日期变为验收日期
                assetWrapper.set(AssetEntity::getLastAmortizeDate, null);
                assetWrapper.set(AssetEntity::getCheckDate, vo.getReceiveDate());
                assetWrapper.set(AssetEntity::getProjectId, entity.getProjectId());
                assetWrapper.set(AssetEntity::getProjectName, entity.getProjectName());
                assetWrapper.set(AssetEntity::getOrgId, entity.getOrgId());
                assetWrapper.set(AssetEntity::getOrgName, entity.getOrgName());
                assetWrapper.set(AssetEntity::getOrgCode, entity.getOrgCode());
                assetWrapper.set(AssetEntity::getParentOrgId, entity.getParentOrgId());
                assetWrapper.set(AssetEntity::getParentOrgName, entity.getParentOrgName());
                assetWrapper.set(AssetEntity::getParentOrgCode, entity.getParentOrgCode());
                assetWrapper.set(AssetEntity::getManageCompanyId, entity.getParentOrgId()); //管理单位 是调入的项目部上级组织
                assetWrapper.set(AssetEntity::getManageCompany, entity.getParentOrgName());
                //调入后，资产净值 = 调拨金额
                assetWrapper.set(AssetEntity::getNetWorthTax, item.getAllocatTaxMny());
                assetWrapper.set(AssetEntity::getNetWorth, item.getAllocatMny());
                assetService.update(assetWrapper);
            });
            //调入后，回写资产卡片里的使用项目为当前调入项目 end
            //生成设备流转记录
            AssetAllotInVO allotInVO = BeanMapper.map(entity, AssetAllotInVO.class);
            assetRecordService.saveRecord(allotInVO);
        }
        return CommonResponse.success("确认收料成功！");
    }

    @Override
    public CommonResponse<String> sureToReturn(AssetAllotInVO vo) {
        AssetAllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        LambdaUpdateWrapper<AssetAllotInEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AssetAllotInEntity::getId, entity.getId());
        wrapper.set(AssetAllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        wrapper.set(AssetAllotInEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
        wrapper.set(AssetAllotInEntity::getReceiveDate, vo.getReceiveDate());
        wrapper.set(AssetAllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        wrapper.set(AssetAllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        wrapper.set(AssetAllotInEntity::getReturnReason, vo.getReturnReason());

        boolean update = service.update(wrapper);
        if (update) {
            //会写调拨出库 设置为自由态
            LambdaUpdateWrapper<AssetAllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
            allotOutWrapper.eq(AssetAllotOutEntity::getId, entity.getAllocatOutId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
            allotOutWrapper.set(AssetAllotOutEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            allotOutWrapper.set(AssetAllotOutEntity::getReturnReason, vo.getReturnReason());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            allotOutWrapper.set(AssetAllotOutEntity::getRelationFlag, 0);//(1:是，0：否)
            assetAllotOutService.update(allotOutWrapper);
            //删除设备流转记录
            assetRecordService.delRecord(entity.getId());
        }
        return CommonResponse.success("确认收料成功！");
    }


    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
