package com.ejianc.business.proequipmentcorppur.purchaseApply.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyDetailedRefVO;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyDetailedVO;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.business.proequipmentcorppur.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设备采购申请-控制器
 *
 * @author generator
 */
@Controller
@RequestMapping("purchaseApply")
public class PurchaseApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PURCHASE_PLAN";

    @Autowired
    private IProjectPoolApi projectPoolApi;


    @Autowired
    private IPurchaseApplyService service;

    @Autowired
    private IPurchaseApplyDetailedService purchaseApplyDetailedService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseApplyVO> saveOrUpdate(@RequestBody PurchaseApplyVO saveOrUpdateVO) {
        PurchaseApplyEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseApplyEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            if (StringUtils.isBlank(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else{
                //验证编码是否唯一
                if (service.checkSameBillCode(BeanMapper.map(entity, PurchaseApplyVO.class))){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }
        service.saveOrUpdates(entity);
        PurchaseApplyVO vo = BeanMapper.map(entity, PurchaseApplyVO.class);
        vo.setDetailList(TreeNodeBUtil.buildTree(vo.getDetailList()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseApplyVO> queryDetail(Long id) {
        PurchaseApplyEntity entity = service.selectById(id);
        PurchaseApplyVO vo = BeanMapper.map(entity, PurchaseApplyVO.class);
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            vo.setDetailList(TreeNodeBUtil.buildTree(vo.getDetailList()));
        }
        return CommonResponse.success("查询详情数据成功！", vo);

    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseApplyVO> vos) {
        service.removeByIds(vos.stream().map(PurchaseApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }
            else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                }
                else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<PurchaseApplyEntity> page = service.queryPage(param, false);
        IPage<PurchaseApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseApplyVO.class));
//        pageData.getRecords().forEach(t->t.setApplyStateName(PurchaseApplyEnum.getDescriptionByStateCode(t.getApplyState())));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseApplyEntity> list = service.queryList(param);
        List<PurchaseApplyVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list, PurchaseApplyVO.class);
            for (PurchaseApplyVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("purchaseApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseApplyData", method = RequestMethod.GET)
    @ResponseBody
    public List<PurchaseApplyVO> refPurchaseApplyData(@RequestParam(required = false) String searchText,
                                                    @RequestParam(required = false) String condition) {
        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
            if (projectId == null) {
                throw new BusinessException("项目id必须传！");
            }
        }
        List<PurchaseApplyVO> dataList = service.queryApplyList(projectId);

        //TODO  wait handle
//        SimpleDateFormat sim  = new SimpleDateFormat("yyyy-MM-dd");
//        if (CollectionUtil.isNotEmpty(dataList)) {
//            for (PurchaseApplyVO vo : dataList) {
//                vo.setName(vo.getBillCode() + "-" + vo.getEmployee()+"-"+sim.format(vo.getApplyUseDate()));
//            }
//        }
        return dataList;
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseApplyDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyVO>> refPurchaseApplyDataByProjectId(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                String condition,
                                                                                String searchObject,
                                                                                String searchText) {
        QueryParam params = new QueryParam();
        params.setPageSize(pageSize);
        params.setPageIndex(pageNumber);
        params.setSearchText(searchText);
        params.setSearchObject(searchObject);
        /** 租户隔离 */
        Long projectId = null;
        Long orgId = null;
        params.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
        }
        params.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        params.getParams().put("planState", new Parameter(QueryParam.EQ, 0));
        if (projectId != null) {
//            params.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
            if (!projectResponse.isSuccess()) {
                throw new BusinessException("查询项目信息失败！");
            }
            params.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
        }
        if (orgId !=null){
            CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
            OrgVO orgVO = orgResp.getData();
            /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                params.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }
            else {
                params.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi
                        .findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId)
                        .collect(Collectors.toList())));
            }
        }
        IPage<PurchaseApplyEntity> page = service.queryPage(params, false);
        IPage<PurchaseApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseApplyVO.class));
        // 查询采购清单
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<PurchaseApplyVO> batApplyVOList = pageData.getRecords();
            List<String> idList = batApplyVOList.stream().map(PurchaseApplyVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter(QueryParam.IN, idList));
            detailParam.getParams().put("doc_id",new Parameter(QueryParam.NE,null));
            List<PurchaseApplyDetailedEntity> detailEntityList = purchaseApplyDetailedService.queryList(detailParam);
            List<PurchaseApplyDetailedVO> detailVOList = BeanMapper.mapList(detailEntityList, PurchaseApplyDetailedVO.class);
            Map<Long, List<PurchaseApplyDetailedVO>> detailMap = new HashMap<>();
            List<PurchaseApplyDetailedVO> mapList;
            // 按照planID对子表结果分组
            for (PurchaseApplyDetailedVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getApplyId())) {
                    detailMap.get(vo.getApplyId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getApplyId(), mapList);
                }
            }
            // 将采购计划清单添加到采购计划中
            batApplyVOList.forEach(batApplyVO -> {
                batApplyVO.setDetailList(detailMap.get(batApplyVO.getId()));
            });
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseApplyDetailedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseApplyDetailedRefVO>> refPurchaseApplyDetailedData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                                          @RequestParam(defaultValue = "10") int pageSize,
                                                                                          @RequestParam(required = false) String relyCondition,
                                                                                          @RequestParam(required = false) String relyNode,
                                                                                          @RequestParam(required = false) String searchText,
                                                                                          @RequestParam(required = false) String condition,
                                                                                          @RequestParam(required = false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentType");
        fuzzyFields.add("equipmentName");
        Long planId = null;
        if (StringUtils.isNotEmpty(relyCondition)) {
            planId = Long.parseLong(relyCondition.split("=")[1]);
        }

        if (planId != null) {
            param.getParams().put("planId", new Parameter(QueryParam.EQ, planId));
            param.getParams().put("leafFlag", new Parameter(QueryParam.EQ, false));
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PurchaseApplyDetailedEntity> page = purchaseApplyDetailedService.queryPage(param, false);
        IPage<PurchaseApplyDetailedRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseApplyDetailedRefVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
