package com.ejianc.business.proequipmentcorppur.purchaseApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.mapper.PurchaseApplyMapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备采购-采购申请
 *
 * @author generator
 */
@Service("purchaseApplyService")
public class PurchaseApplyServiceImpl extends BaseServiceImpl<PurchaseApplyMapper, PurchaseApplyEntity> implements IPurchaseApplyService {
    @Autowired
    private PurchaseApplyMapper mapper;

    @Override
    public void saveOrUpdates(PurchaseApplyEntity entity) {
        List<PurchaseApplyDetailedEntity> listbs = entity.getDetailList();
        if(CollectionUtil.isNotEmpty(listbs)){
            Map<Long, Long> idMap = new HashMap<>();
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null == cdEntity.getParentId()) {
                    idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
                }
            }
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
            }
        }

        super.saveOrUpdate(entity, false);
    }

    @Override
    public List<PurchaseApplyVO> queryApplyList(Long projectId) {
        List<PurchaseApplyVO> list = mapper.queryList(projectId);
        return list;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    @Override
    public Boolean checkSameBillCode(PurchaseApplyVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseApplyEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseApplyEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseApplyEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseApplyEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void updateBatApplyByQuoteType(List<String> idList, Integer planState) {
        //TODO  待修改逻辑

        /*
        if (StringUtils.isEmpty(PurchaseApplyEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<PurchaseApplyEntity> entityList = (List<PurchaseApplyEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (PurchaseApplyEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatApplyEnum.PLAN_STATE_OVER.getApplyState().equals(entity.getPlanState())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】已采购完成！");
                    }
                    entity.setPlanState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }*/
    }

}
