package com.ejianc.business.proequipmentcorppur.purchaseplan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备采购-采购总计划实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_purchase_plan")
public class PurchasePlanEntity extends BaseEntity {

    private static final long serialVersionUID = -697128152142091664L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 计划编号
    @TableField(value="plan_year")
    private Date planYear; // 计划年度
    @TableField(value="plan_total_mny")
    private BigDecimal planTotalMny; // 计划总金额
    @TableField(value="employee")
    private String employee; // 经办人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 采购组织Id
    @TableField(value="org_name")
    private String orgName; // 采购组织名称
    @TableField(value="org_code")
    private String orgCode; // 采购组织编码
    @TableField(value = "plan_name")
    private String planName; //计划名称
    @TableField(value = "handle_date")
    private Date handleDate; //办理日期

    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码\
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编号
    @TableField(value = "project_id")
    private Long projectId; // 项目id

    /**
     * 采购计划-计划清单明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "purchasePlanDetailedService", pidName = "planId")
    private List<PurchasePlanDetailedEntity> detailList = new ArrayList<>();

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getPlanTotalMny() {
        return planTotalMny;
    }

    public void setPlanTotalMny(BigDecimal planTotalMny) {
        this.planTotalMny = planTotalMny;
    }
    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<PurchasePlanDetailedEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchasePlanDetailedEntity> detailList) {
        this.detailList = detailList;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }

    public Date getPlanYear() {
        return planYear;
    }

    public void setPlanYear(Date planYear) {
        this.planYear = planYear;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
}
