package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IChangeService changeService;

	@Autowired
	private IContractService contractService;

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ChangeEntity changeEntity = changeService.selectById(billId);
		//如果当前变更合同的主合同的合同状态不是履约中（冻结、解除、封账），则变更的合同不能进行提交
		ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		if (null != contractEntity && !contractEntity.getPerformanceStatus().equals(PerformanceStatusEnum.履约中.getCode())){
			return CommonResponse.error("当前变更合同所属的主合同状态不是履约中，该变更合同不能进行提交操作！");
		}

		Boolean commitState = false;
		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			commitState = true;
			//直审设置单据提交人信息
			changeEntity.setCommitDate(new Date());
			changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		}
		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			//调用生效回写服务
			CommonResponse<String> response = changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
			if (!response.isSuccess()) {
				logger.info("合同生效回写失败！失败原因：{}" ,JSONObject.toJSONString(response));
				throw new BusinessException("合同审核失败！");
			}
		}else {
			//变更单更新
			if (commitState){
				changeService.saveOrUpdate(changeEntity);
			}
			//回写主合同信息
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(contractEntity, false);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}
		// 生成水印
		changeService.asyncWatermarkById(billId);
		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		// 更新合同池数据的累计变更金额（含税、无税、税额）、累计变更比例
		ChangeEntity changeEntity = changeService.selectById(billId);
		changeService.updateTotalChangeDataByContractId(changeEntity, "back");
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		ChangeEntity contractChangeEntity = changeService.selectById(billId);
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if (!DraftTypeEnum.线下签订.getCode().toString().equals(contractChangeEntity.getChangeDraftType())
				&& !statusList.contains(contractChangeEntity.getSignatureStatus())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
			contractChangeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}
		// 合同变更 线下签订不适用电子签章，已生效的不允许撤回
		if (DraftTypeEnum.线下签订.getCode().toString().equals(contractChangeEntity.getChangeDraftType())
				&& SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
			return CommonResponse.error("合同变更已生效，不能撤回!");
		}
		contractChangeEntity.setCommitDate(null);
		contractChangeEntity.setCommitUserCode(null);
		contractChangeEntity.setCommitUserName(null);
		changeService.saveOrUpdate(contractChangeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractChangeEntity));

		ContractEntity contractEntity = contractService.selectById(contractChangeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);

		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
