package com.ejianc.business.proequipmentcorprent.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorprent.order.vo.RentOrderDetailVO;
import com.ejianc.business.proequipmentcorprent.order.vo.RentOrderVO;
import com.ejianc.business.proequipmentcorprent.order.vo.SupRentOrderDetailVO;
import com.ejianc.business.proequipmentcorprent.order.vo.SupRentOrderVO;
import com.ejianc.business.proequipmentcorprent.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.order.mapper.RentOrderMapper;
import com.ejianc.business.proequipmentcorprent.order.bean.RentOrderEntity;
import com.ejianc.business.proequipmentcorprent.order.service.IRentOrderService;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
@Service("rentOrderService")
public class RentOrderServiceImpl extends BaseServiceImpl<RentOrderMapper, RentOrderEntity> implements IRentOrderService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private final String OPERATE = "CORP_RENT_ORDER_CODE_SYNC";
    // 订单接收：/ejc-supbusiness-web/openapi/equipmentOrder/saveOrUpdate
    //订单关闭：/ejc-supbusiness-web/openapi/equipmentOrder/updateOrderCloseFlag
    //订单撤回：/ejc-supbusiness-web/openapi/equipmentOrder/deleteOrder
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentOrder/saveOrUpdate";
    private final String UPDATE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/equipmentOrder/updateOrderCloseFlag";

    private static final String BILL_CODE = "CORP_RENT_ORDER";//此处需要根据实际修改

    @Override
    public RentOrderVO queryDetail(Long id) {
        RentOrderEntity entity = super.selectById(id);
        RentOrderVO vo = BeanMapper.map(entity, RentOrderVO.class);
        return vo;
    }

    @Override
    public RentOrderVO saveOrUpdates(RentOrderVO saveOrUpdateVO) {
        List<RentOrderDetailVO> concreteOrderDetailList = saveOrUpdateVO.getRentOrderDetailList();
//        List<ConcreteOrderAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteOrderAdmixtureEntity>();
        StringBuffer equipmentName = new StringBuffer();
        if (CollectionUtils.isNotEmpty(concreteOrderDetailList)){
            for (RentOrderDetailVO RentOrderDetailVO : concreteOrderDetailList){
                if(!"del".equals(RentOrderDetailVO.getRowState())){
                    equipmentName.append(RentOrderDetailVO.getEquipmentName()+",");
                }
            }
        }

        RentOrderEntity entity = BeanMapper.map(saveOrUpdateVO, RentOrderEntity.class);
        entity.setOrderFlag(0);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        String equipmentNames = equipmentName.length()>0?equipmentName.substring(0, equipmentName.length() - 1):"";
        entity.setEquipmentName(equipmentNames);
        super.saveOrUpdate(entity, false);
        RentOrderVO vo = BeanMapper.map(entity, RentOrderVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> updateOrderFlag(RentOrderVO orderVO) {
        RentOrderEntity orderEntity = super.getById(orderVO.getId());
        CommonResponse<String> res = updatePushBill(orderEntity,"EJCBT202205000003",UPDATE_BILL_SERVER_URL);
        orderEntity.setOrderFlag(1);
        super.updateById(orderEntity);
        return  CommonResponse.success("关闭成功");
    }

    @Override
    public CommonResponse<RentOrderVO> updateReceived(SupRentOrderVO orderVO) {
        logger.info("供方订单数据------"+JSONObject.toJSONString(orderVO));
        RentOrderEntity orderEntity = super.selectById(orderVO.getId()) ;
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>0&&4!=orderVO.getReceiveState()){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"ejc-promaterial-frontend/#/concreteOrder/card?id="+orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+ DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            orderEntity.getRentOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }else if(2==orderVO.getReceiveState()){
            //部分接收
            orderEntity.setReceiveState(2);//部分接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(orderVO.getRentOrderDetailList())){
                //拆分接收数量
                Map<Long, BigDecimal> map = orderVO.getRentOrderDetailList().stream().collect(Collectors.toMap(SupRentOrderDetailVO::getId,SupRentOrderDetailVO::getReceiveNumsSum));
                logger.debug("map------"+map);
                orderEntity.getRentOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------"+vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
            //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getEquipmentName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            //拆分接收数量
            orderEntity.getRentOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        logger.debug("-----主键"+orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }

    @Override
    public CommonResponse<RentOrderVO> updateDeliverState(SupRentOrderVO orderVO) {
        RentOrderEntity orderEntity = super.getById(orderVO.getId());
        if(null==orderEntity){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }else{
            orderEntity.setDeliverState(orderVO.getDeliverState());
            super.updateById(orderEntity);
            return CommonResponse.success("操作成功");
        }
    }

    @Override
    public boolean pushBillToSupCenter(RentOrderEntity RentOrderEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + RentOrderEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", RentOrderEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        RentOrderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(BeanMapper.map(RentOrderEntity,SupRentOrderVO.class)));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(RentOrderEntity.getId(), "EJCBT202205000003", "equipment-order-attaches", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", RentOrderEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        RentOrderEntity.getSupplierId().toString(),
                        files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
//                if (syncReqResp.isSuccess()) {
//                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                    if (billPushResp.isSuccess()) {
//                        syncFlag = true;
//                    } else {
//                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", RentOrderEntity.getSupplierId(), RentOrderEntity.getId(), billPushResp.getMsg());
//                    }
//                } else {
//                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", RentOrderEntity.getId(), RentOrderEntity.getSupplierId(), syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", RentOrderEntity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", RentOrderEntity.getId(), RentOrderEntity.getSupplierId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    @Override
    public CommonResponse<String> updatePushBill(RentOrderEntity RentOrderEntity, String billTypeCode,String url) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + RentOrderEntity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", RentOrderEntity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        RentOrderEntity.setSystemId(ejcCloudSystemCode.getData());
        CommonResponse<String> syncReqResp = null;
        CommonResponse<String> supHandleResp = null;
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", RentOrderEntity.getId().toString());
            paramMap.put("systemId", RentOrderEntity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", RentOrderEntity.getSupplierId(), RentOrderEntity.getId());

            //推送单据到指定的供方
            syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    RentOrderEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return CommonResponse.success();
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", RentOrderEntity.getSupplierId(), RentOrderEntity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", RentOrderEntity.getSupplierId(), RentOrderEntity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error(syncReqResp.getMsg()+"////////"+supHandleResp.getMsg());
            logger.error("通知供方单据id-{}作废异常，", RentOrderEntity.getId(), e);
            throw new BusinessException(supHandleResp.getMsg());
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,RentOrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


//        if (messageType.contains("wjy")) {
//            JSONObject wjyMsgParams  = new JSONObject();
//            wjyMsgParams.put("appid", appid);
//            wjyMsgParams.put("from", "供方平台");
//            wjyMsgParams.put("msg", subject);
//            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
//            parameter.setWjyMsgParams(wjyMsgParams);
//        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
}
