package com.ejianc.business.proequipmentcorprent.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentOtherDetailedEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractClauseEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractPaymentClauseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 租赁合同
 *
 * @author generator
 *
 */
@TableName("ejc_proequipmentcorp_rent_contract")
public class RentContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 合同名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="rent_type")
    private Integer rentType; // 租赁方式
    @TableField(value="rent_type_name")
    private String rentTypeName; // 租赁方式名称
    @TableField(value="calibration_result_id")
    private Long calibrationResultId; // 定标结果id
    @TableField(value="calibration_result_name")
    private String calibrationResultName; // 定标结果名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="company_id")
    private Long companyId; // 所属单位
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="contract_type")
    private Long contractType; // 合同类别
    @TableField(value="contract_type_name")
    private String contractTypeName; // 合同类别名称
    @TableField(value="party_id")
    private Long partyId; // 甲方
    @TableField(value="party_name")
    private String partyName; // 甲方名称
    @TableField(value="party_user")
    private Long partyUser; // 甲方负责人
    @TableField(value="party_user_name")
    private String partyUserName; // 甲方负责人名称
    @TableField(value="party_handle_user")
    private Long partyHandleUser; // 甲方经办人
    @TableField(value="party_handle_user_name")
    private String partyHandleUserName; // 甲方经办人名称
    @TableField(value="party_phone")
    private Long partyPhone; // 甲方电话
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="supplier_handle_user")
    private Long supplierHandleUser; // 乙方经办人id
    @TableField(value="supplier_handle_user_name")
    private String supplierHandleUserName; // 乙方经办人名称
    @TableField(value="supplier_phone")
    private String supplierPhone; // 乙方电话
    @TableField(value="supplier_address")
    private String supplierAddress; // 乙方地址
    @TableField(value="signed_date")
    private Date signedDate; // 签订日期
    @TableField(value="meter_rent_type")
    private String meterRentType; // 计租方式 day
    //--日租，month--月租,engineering--工程量,other--其它费用
    @TableField(value="meter_rent_type_name")
    private String meterRentTypeName; // 计租方式名称
    @TableField(value="month_settlement")
    private String monthSettlement; // 月结算日
    @TableField(value="meter_date")
    private Date meterDate; // 计租日期
    @TableField(value="prevent_date")
    private Date preventDate; // 止租时间
    @TableField(value="supply_place")
    private String supplyPlace; // 供货地点
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税率
    @TableField(value="contract_performance_state")
    private String contractPerformanceState; // 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；   默认为未签定
    @TableField(value="contract_performance_name")
    private String contractPerformanceName; // 合同履约状态名称
    @TableField(value="draft_type")
    private String draftType; // 起草方式:1--线上起草,2-----合同上传，3---线下
    @TableField(value="draft_type_name")
    private String draftTypeName; // 起草方式名称
    @TableField(value="contract_file")
    private String contractFile; // 合同附件

    @TableField("contract_file_id")//合同附件id
    private Long contractFileId;

    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税)

    @TableField(value="contract_state")
    private Integer contractState; // 合同状态:1--未签订,2--履约中,3-已终止,4-已作废,5-已冻结,6-已结束,
    @TableField(value="signature_state")
    private String signatureState; // 1---未签章,2---待乙方签章,3-待甲方签章,4-已签章
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="after_change_mny")
    private BigDecimal afterChangeMny;
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更后金额
    @TableField(value="changing_item")
    private String changingItem; // 变更项
    @TableField(value="changing_ratio")
    private BigDecimal changingRatio; // 变更比例
    @TableField(value="changing_tax")
    private BigDecimal changingTax; // 本次变更税额
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField("change_draft_type")
    private String changeDraftType;
    @TableField(value="add_type")
    private Integer addType; // 1----直接添加----2---定标结果
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="supplement_describe")
    private String supplementDescribe; // 补充协议补充项描述
    @TableField(value="supplement_code")
    private String supplementCode; // 补充协议编号
    @TableField(value="supplement_name")
    private String supplementName; // 补充协议名称
    @TableField(value="supplement_state")
    private Integer supplementState; // 补充协议状态:1-未签订,2-履约中,3-已终止,4-已作废
    @TableField(value="supplement_file")
    private String supplementFile; // 协议附件
    @TableField(value="change_file")
    private String changeFile; // 变更附件
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField("effective_date")
    private Date effectiveDate;

    @TableField("change_contract_signature_status")
    private Integer changeContractSignatureStatus;
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="contract_name")
    private String contractName;//合同名称
    @TableField(value="base_mny")
    private BigDecimal baseMny; // 初始版本金额
    @TableField(value="base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本(含税)金额
    @TableField(value="main_contract_create_date")
    private Date mainContractCreateDate; // 主合同创建日期（用于合同、补充协议排序）
    /**
     * 定标结果Id
     */
    @TableField("target_result_id")
    private Long targetResultId;

    /**
     * 定标结果名称
     */
    @TableField("target_result_name")
    private String targetResultName;
    @TableField("target_type")
    private Boolean targetType;
    @TableField("rent_harbor_type")
    private String rentHarborType;//租赁港式
    @TableField("contract_amount_tax")
    private BigDecimal contractAmountTax;
    @TableField(value="signed_file_id")
    private Long signedFileId; // 签章完成合同文件Id

    @TableField(value="org_id")
    private Long orgId; // orgId
    @TableField(value="org_name")
    private String orgName; // 上级组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="change_contract_name")
    private String changeContractName; // 变更合同名称
    @TableField("watermark_contract_file_id")
    private Long watermarkContractFileId;
    @TableField(value="change_file_id")
    private Long changeFileId; // 变更附件Id
    /**
     * 发票类型Id
     */
    @TableField(value = "invoice_type_id")
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    @TableField(value = "invoice_type_name")
    private String invoiceTypeName;
    @TableField(exist=false)
    @SubEntity(serviceName="rentDayDetailedService")
    private List<RentDayDetailedEntity> rentDayDetailedList = new ArrayList<>(); // 租赁日租明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentMonthDetailedService")
    private List<RentMonthDetailedEntity> rentMonthDetailedList = new ArrayList<>(); // 租赁月租明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentQuantitiesDetailedService")
    private List<RentQuantitiesDetailedEntity> rentQuantitiesDetailedList = new ArrayList<>(); // 租赁工程量明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentOtherDetailedService")
    private List<RentOtherDetailedEntity> rentOtherDetailedList = new ArrayList<>(); // 租赁其它费用明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentContractClauseService")
    private List<RentContractClauseEntity> rentContractClauseList = new ArrayList<>(); // 租赁合同条款
    @TableField(exist=false)
    @SubEntity(serviceName="rentContractPaymentClauseService")
    private List<RentContractPaymentClauseEntity> rentContractPaymentClauseList = new ArrayList<>(); // 租赁合同支付条款
    /**
     * 线上起草合同，审批中修改的合同是否已重新进行合同编辑
     */
    @TableField(value = "contract_file_sync_flag")
    private Boolean contractFileSyncFlag = true;
    @TableField(value="org_code")
    private String orgCode;
    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否
    @TableField("filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    @TableField("list_mny")
    private BigDecimal listMny;
    @TableField("list_tax_mny")
    private BigDecimal listTaxMny;
    @TableField("list_tax")
    private BigDecimal listTax;
    @TableField("other_mny")
    private BigDecimal otherMny;
    @TableField("other_tax_mny")
    private BigDecimal otherTaxMny;
    @TableField("other_tax")
    private BigDecimal otherTax;
    @TableField(value="purchase_type")
    private Integer purchaseType;//采购方式(0-项目采购,1-单位采购)
    @TableField(value="target_tax_mny")
    private BigDecimal targetTaxMny;//采购方式(0-项目采购,1-单位采购)

    public BigDecimal getTargetTaxMny() {
        return targetTaxMny;
    }

    public void setTargetTaxMny(BigDecimal targetTaxMny) {
        this.targetTaxMny = targetTaxMny;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public BigDecimal getListMny() {
        return listMny;
    }

    public void setListMny(BigDecimal listMny) {
        this.listMny = listMny;
    }

    public BigDecimal getListTaxMny() {
        return listTaxMny;
    }

    public void setListTaxMny(BigDecimal listTaxMny) {
        this.listTaxMny = listTaxMny;
    }

    public BigDecimal getListTax() {
        return listTax;
    }

    public void setListTax(BigDecimal listTax) {
        this.listTax = listTax;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }
    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public Long getCalibrationResultId() {
        return calibrationResultId;
    }

    public void setCalibrationResultId(Long calibrationResultId) {
        this.calibrationResultId = calibrationResultId;
    }
    public String getCalibrationResultName() {
        return calibrationResultName;
    }

    public void setCalibrationResultName(String calibrationResultName) {
        this.calibrationResultName = calibrationResultName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public Long getPartyId() {
        return partyId;
    }

    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }
    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }
    public Long getPartyUser() {
        return partyUser;
    }

    public void setPartyUser(Long partyUser) {
        this.partyUser = partyUser;
    }
    public String getPartyUserName() {
        return partyUserName;
    }

    public void setPartyUserName(String partyUserName) {
        this.partyUserName = partyUserName;
    }
    public Long getPartyHandleUser() {
        return partyHandleUser;
    }

    public void setPartyHandleUser(Long partyHandleUser) {
        this.partyHandleUser = partyHandleUser;
    }
    public String getPartyHandleUserName() {
        return partyHandleUserName;
    }

    public void setPartyHandleUserName(String partyHandleUserName) {
        this.partyHandleUserName = partyHandleUserName;
    }
    public Long getPartyPhone() {
        return partyPhone;
    }

    public void setPartyPhone(Long partyPhone) {
        this.partyPhone = partyPhone;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierHandleUser() {
        return supplierHandleUser;
    }

    public void setSupplierHandleUser(Long supplierHandleUser) {
        this.supplierHandleUser = supplierHandleUser;
    }
    public String getSupplierHandleUserName() {
        return supplierHandleUserName;
    }

    public void setSupplierHandleUserName(String supplierHandleUserName) {
        this.supplierHandleUserName = supplierHandleUserName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }
    public Date getSignedDate() {
        return signedDate;
    }

    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }

    public String getMeterRentType() {
        return meterRentType;
    }

    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }
    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    public String getMonthSettlement() {
        return monthSettlement;
    }

    public void setMonthSettlement(String monthSettlement) {
        this.monthSettlement = monthSettlement;
    }
    public Date getMeterDate() {
        return meterDate;
    }

    public void setMeterDate(Date meterDate) {
        this.meterDate = meterDate;
    }
    public Date getPreventDate() {
        return preventDate;
    }

    public void setPreventDate(Date preventDate) {
        this.preventDate = preventDate;
    }
    public String getSupplyPlace() {
        return supplyPlace;
    }

    public void setSupplyPlace(String supplyPlace) {
        this.supplyPlace = supplyPlace;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public String getContractPerformanceState() {
        return contractPerformanceState;
    }

    public void setContractPerformanceState(String contractPerformanceState) {
        this.contractPerformanceState = contractPerformanceState;
    }

    public String getContractPerformanceName() {
        return contractPerformanceName;
    }

    public void setContractPerformanceName(String contractPerformanceName) {
        this.contractPerformanceName = contractPerformanceName;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getDraftTypeName() {
        return draftTypeName;
    }

    public void setDraftTypeName(String draftTypeName) {
        this.draftTypeName = draftTypeName;
    }
    public String getContractFile() {
        return contractFile;
    }

    public void setContractFile(String contractFile) {
        this.contractFile = contractFile;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Integer getContractState() {
        return contractState;
    }

    public void setContractState(Integer contractState) {
        this.contractState = contractState;
    }
    public String getSignatureState() {
        return signatureState;
    }

    public void setSignatureState(String signatureState) {
        this.signatureState = signatureState;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public String getChangingItem() {
        return changingItem;
    }

    public void setChangingItem(String changingItem) {
        this.changingItem = changingItem;
    }
    public BigDecimal getChangingRatio() {
        return changingRatio;
    }

    public void setChangingRatio(BigDecimal changingRatio) {
        this.changingRatio = changingRatio;
    }
    public BigDecimal getChangingTax() {
        return changingTax;
    }

    public void setChangingTax(BigDecimal changingTax) {
        this.changingTax = changingTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public String getSupplementCode() {
        return supplementCode;
    }

    public void setSupplementCode(String supplementCode) {
        this.supplementCode = supplementCode;
    }
    public String getSupplementName() {
        return supplementName;
    }

    public void setSupplementName(String supplementName) {
        this.supplementName = supplementName;
    }
    public Integer getSupplementState() {
        return supplementState;
    }

    public void setSupplementState(Integer supplementState) {
        this.supplementState = supplementState;
    }
    public String getSupplementFile() {
        return supplementFile;
    }

    public void setSupplementFile(String supplementFile) {
        this.supplementFile = supplementFile;
    }
    public String getChangeFile() {
        return changeFile;
    }

    public void setChangeFile(String changeFile) {
        this.changeFile = changeFile;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }


    public List<RentDayDetailedEntity> getRentDayDetailedList() {
        return rentDayDetailedList;
    }

    public void setRentDayDetailedList(List<RentDayDetailedEntity> rentDayDetailedList) {
        this.rentDayDetailedList = rentDayDetailedList;
    }

    public List<RentMonthDetailedEntity> getRentMonthDetailedList() {
        return rentMonthDetailedList;
    }

    public void setRentMonthDetailedList(List<RentMonthDetailedEntity> rentMonthDetailedList) {
        this.rentMonthDetailedList = rentMonthDetailedList;
    }

    public List<RentQuantitiesDetailedEntity> getRentQuantitiesDetailedList() {
        return rentQuantitiesDetailedList;
    }

    public void setRentQuantitiesDetailedList(List<RentQuantitiesDetailedEntity> rentQuantitiesDetailedList) {
        this.rentQuantitiesDetailedList = rentQuantitiesDetailedList;
    }

    public List<RentOtherDetailedEntity> getRentOtherDetailedList() {
        return rentOtherDetailedList;
    }

    public void setRentOtherDetailedList(List<RentOtherDetailedEntity> rentOtherDetailedList) {
        this.rentOtherDetailedList = rentOtherDetailedList;
    }

    public List<RentContractClauseEntity> getRentContractClauseList() {
        return rentContractClauseList;
    }

    public void setRentContractClauseList(List<RentContractClauseEntity> rentContractClauseList) {
        this.rentContractClauseList = rentContractClauseList;
    }

    public List<RentContractPaymentClauseEntity> getRentContractPaymentClauseList() {
        return rentContractPaymentClauseList;
    }

    public void setRentContractPaymentClauseList(List<RentContractPaymentClauseEntity> rentContractPaymentClauseList) {
        this.rentContractPaymentClauseList = rentContractPaymentClauseList;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public BigDecimal getAfterChangeMny() {
        return afterChangeMny;
    }

    public void setAfterChangeMny(BigDecimal afterChangeMny) {
        this.afterChangeMny = afterChangeMny;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Boolean getTargetType() {
        return targetType;
    }

    public void setTargetType(Boolean targetType) {
        this.targetType = targetType;
    }

    public String getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(String rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public BigDecimal getContractAmountTax() {
        return contractAmountTax;
    }

    public void setContractAmountTax(BigDecimal contractAmountTax) {
        this.contractAmountTax = contractAmountTax;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
