package com.ejianc.business.proequipmentcorprent.rent.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractChangeService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractChangeVO;

/**
 * 租赁合同变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentContractChange")
public class RentContractChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRentContractChangeService service;
    @Autowired
    private IRentContractService contractService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Value("${common.env.base-host}")
    private String BaseHost;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentContractChangeVO> saveOrUpdate(@RequestBody RentContractChangeVO saveOrUpdateVO) {
        RentContractChangeVO vo = service.saveOrUpdate(saveOrUpdateVO,false);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractChangeVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentContractChangeVO> vos) {
            //目标成本推送
            //删除数据
        RentContractChangeEntity entity =service.selectById(vos.get(0).getId());
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        List<RentContractEntity> contractEntityList = new ArrayList<>();
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, RentContractChangeVO.class),null);
        totalExecutionVOList.add(executionVO.getTotalVO());
        RentContractEntity rentContractEntity = contractService.selectById(entity.getContractId());
        logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        //推送上一版数据
        //目标成本推送
        ExecutionVO executionVO1;
        String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + rentContractEntity.getId();
        executionVO1 = contractService.targetCost(BeanMapper.map(rentContractEntity, RentContractVO.class), linkUrl);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO1));
        CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
        if (!response1.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return service.deleteById(vos.get(0).getId());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentContractChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RentContractChangeEntity> page = service.queryPage(param,false);
        IPage<RentContractChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentContractChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentContractChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RentContractChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRentContractChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentContractChangeVO>> refRentContractChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RentContractChangeEntity> page = service.queryPage(param,false);
        IPage<RentContractChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentContractChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractChangeVO> addConvertByConId(Long contractId, Long changeId) {
        RentContractChangeVO vo = service.addConvertByConId(contractId, changeId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Description queryDetailRecord 查询当前合同下变更列表
     * @param id
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractChangeVO> queryDetailRecord(Long id) {
        RentContractChangeVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetails(Long id) {
        CommonResponse<String> vo = service.effectiveSaveWriteContract(id,null,null);
        return CommonResponse.success("查询详情数据成功！");
    }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody RentContractChangeVO changeVO) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(changeVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }

    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map returnMap = service.queryChangeCompare(id);
        return CommonResponse.success("查询转换数据成功！", returnMap);
    }

}
