package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractAsyncService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

@Service("rentContract") 
public class RentContractBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentContractService rentContractService;

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IParamConfigApi paramConfigApi;
	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
	@Autowired
	ISignatureCommonApi signatureCommonApi;
	@Autowired
	private IRentContractAsyncService rentContractAsyncService;
    @Autowired
    private IInstoreApi iInstoreApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		RentContractEntity e = rentContractService.selectById(billId);

		if(DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) {
			if(null == e.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
			if(!e.getContractFileSyncFlag()) {
				return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
			}
		}



		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		rentContractService.saveOrUpdate(e,false);

		return CommonResponse.success("合同审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		//TODO
		RentContractEntity contractEntitiy = rentContractService.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureState()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		RentContractEntity e = rentContractService.selectById(billId);
		logger.info("审批节点审批中时节点审批前回调:  当前数据-{}", JSONObject.toJSONString(e));
		//线上起草且文件未同步
		if((DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) && !e.getContractFileSyncFlag()) {
			return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
		}

		return CommonResponse.success("审批处理成功！");
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentContractEntity contractEntity = rentContractService.selectById(billId);
		if (contractEntity != null){

			if((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
				//线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
				contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
             // 线上起草不使用电子签章，并且已经编辑过合同，审批通过后变为已签章履约中
			}else if (DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())
					&& contractEntity.getContractFileId() != null && contractEntity.getContractFileSyncFlag()) {
				//线上起草不使用电子签章合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线上起草不使用电子签章直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
				contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
			}
		if(DraftTypeEnum.线上起草.getCode().toString().equals(contractEntity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())) {
			if(null == contractEntity.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
			if(!contractEntity.getContractFileSyncFlag()) {
				return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
			}
		}
		}

		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			contractEntity.setCommitDate(new Date());
			contractEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			contractEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		}
		// 合同水印
		rentContractService.asyncWatermarkById(billId);
		// 推送项目池
		rentContractService.pushContract(BeanMapper.map(contractEntity, RentContractVO.class));
		rentContractService.saveOrUpdate(contractEntity);




		return CommonResponse.success("合同审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentContractEntity contractEntitiy = rentContractService.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureState()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		// 允许撤回后，删除合同池中数据
		rentContractService.pushDelContract(BeanMapper.map(contractEntitiy, RentContractVO.class));
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		/*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		RentContractEntity contractEntity = rentContractService.selectById(billId);

		//使用电子签章且已有签章流程则不允许撤回
		if(DraftTypeEnum.线上起草.getCode().equals(contractEntity.getDraftType()) || DraftTypeEnum.上传合同.getCode().equals(contractEntity.getDraftType())) {
			if (!statusList.contains(contractEntity.getSignatureState())){
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}
		} else if(SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())) {
			contractEntity.setSignatureState(SignatureStatusEnum.未签章.getCode());
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		//从合同池删除数据
		rentContractService.pushDelContract(BeanMapper.map(contractEntity,RentContractVO.class));
//		contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		contractEntity.setContractPerformanceState(PerformanceStatusEnum.未签订.getCode());

		// 删除文件中心水印文件
		if(contractEntity.getWatermarkContractFileId() != null) {
			boolean delWatermarkflag = rentContractService.delWatermarkContractFile(contractEntity.getWatermarkContractFileId());
			if (delWatermarkflag) {
				contractEntity.setWatermarkContractFileId(null);
			}
		}
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()) ||
				BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())) {
			//若合同属于已提交 并且自动归档的，则将其归档状态改为未归档
			if(DraftTypeEnum.线上起草.getCode().equals(contractEntity.getDraftType()) || DraftTypeEnum.上传合同.equals(contractEntity.getDraftType())) {
				contractEntity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
			}

		}
		rentContractService.saveOrUpdate(contractEntity, false);

		return CommonResponse.success("弃审/撤回前校验回调成功！");

	}
}
