package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.ejianc.business.proequipmentcorprent.rent.vo.RentPlanEnum;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.rent.mapper.RentEquipmentPlanMapper;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentPlanService;

import java.util.List;

/**
 * 租赁设备租赁计划
 * 
 * @author generator
 * 
 */
@Service("rentEquipmentPlanService")
public class RentEquipmentPlanServiceImpl extends BaseServiceImpl<RentEquipmentPlanMapper, RentEquipmentPlanEntity> implements IRentEquipmentPlanService{

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(RentPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<RentEquipmentPlanEntity> entityList = (List<RentEquipmentPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (RentEquipmentPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (RentPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getBiddingState())) {
                        throw new BusinessException("采购计划编码【" + entity.getCode() + "】已采购完成！");
                    }
                    entity.setBiddingState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }
}
