package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.PushRentEquipmentStartSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.PushRentEquipmentStartVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;

@Service("rentEquipmentStart")
public class RentEquipmentStartBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentEquipmentStartService rentEquipmentStartService;
	@Autowired
	private IRentParameterService rentParameterService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IRentParameterDetailService rentParameterDetailService;
	@Autowired
	private IProSupplierApi proSupplierApi;
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_TYPE = "BT220221000000003";//已调整
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";

	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
	private final String OPERATE = "RENT-PROEQUIPMENT-START";

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentEquipmentStartEntity entity =rentEquipmentStartService.selectById(billId);
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			//推送供方
			//对单据进行加锁
			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
			if (!ejcCloudSystemCode.isSuccess()) {
				throw new BusinessException("获取当前系统编码失败！");
			}
			Map<String,Object> map = new HashMap<>();
			map.put("sourceId",billId);
			map.put("systemId",ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(map);
			Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
					entity.getSupplierId().toString(),OPERATE,BILL_TYPE);
			if (!updateSupplierStatus){
				throw new BusinessException("单据推送失败！");
			}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			rentEquipmentStartService.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentEquipmentStartEntity startEntity = rentEquipmentStartService.selectById(billId);
		List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
		List<RentParameterEntity> parameterList = new ArrayList<>();
		for (RentEquipmentStartSubEntity subEntity : subEntityList) {
			// 主表赋值
			RentParameterEntity parameterEntity = new RentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setStartDate(startEntity.getTypeDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());//启动状态
			// 处理子表
			List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
			RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
			detailEntity.setSourceType(RentParameterTypeEnum.启用单.getCode());
			detailEntity.setSourceId(startEntity.getId());
			detailEntity.setOperationDate(startEntity.getTypeDate());
			detailEntity.setEquipmentState(RentEquipmentStateEnum.启用.getCode());
			detailEntity.setParameterId(subEntity.getSourceId());
			parameterDetailList.add(detailEntity);

			parameterEntity.setRentParameterDetailList(parameterDetailList);
			parameterList.add(parameterEntity);
		}
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.启用单.getCode());

		//推送供方验收单处理
		PushRentEquipmentStartVO supplierPushCheckVO = BeanMapper.map(startEntity, PushRentEquipmentStartVO.class);
		supplierPushCheckVO.setSourceId(startEntity.getId());
		List<PushRentEquipmentStartSubVO> pushRentEquipmentStartSubVOS = BeanMapper.mapList(startEntity.getRentEquipmentStartSubList(), PushRentEquipmentStartSubVO.class);

		for (PushRentEquipmentStartSubVO supplierPushCheckDetailVO : pushRentEquipmentStartSubVOS){
			supplierPushCheckDetailVO.setSourceId(startEntity.getId());
			supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
			supplierPushCheckDetailVO.setId(null);
		}
		supplierPushCheckVO.setEquipmentStartDetailList(pushRentEquipmentStartSubVOS);
		//设置单据当前系统信息
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
//			throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
		}
		else {
			//设置当前系统ID
			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
			if (!cooperateResp.isSuccess()) {
				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
			}
			else {
				boolean b = rentAcceptanceService.pushBillToSupCenter(dataInfo, startEntity.getSupplierId(),
						startEntity.getId(), BILL_TYPE, cooperateResp.getData(), PUSH_SAVE_URL);
				if (!b) {
					logger.error("推送供方失败！单据信息：{}", dataInfo);
				}
				else {
					startEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
				}
			}
		}

		rentEquipmentStartService.updateById(startEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentEquipmentStartEntity startEntity =rentEquipmentStartService.selectById(billId);
		EquipmentNewDateVO equipmentNewDateVO =rentParameterService.selectAbandonDate(startEntity.getContractId(),startEntity.getTypeDate());
		if(equipmentNewDateVO != null){
			if(!startEntity.getId().equals(equipmentNewDateVO.getId())){
				return CommonResponse.error("弃审失败:请先弃审设备" + equipmentNewDateVO.getType() + "单据在弃审本单据");
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//反向操作
		RentEquipmentStartEntity startEntity = rentEquipmentStartService.selectById(billId);
		List<RentEquipmentStartSubEntity> subEntityList = startEntity.getRentEquipmentStartSubList();
//		List<RentParameterEntity> parameterList = new ArrayList<>();
		List<Long> parameterIdList = new ArrayList<>();
		for (RentEquipmentStartSubEntity subEntity : subEntityList) {
//			RentParameterEntity parameterEntity =rentParameterService.selectById(subEntity.getSourceId());//来源
//			parameterEntity.setStartDate(subEntity.getTypeDate());
//			parameterEntity.setOperationDate(new Date());
//			parameterEntity.setEquipmentState(3);//启动停用
//			parameterList.add(parameterEntity);
			parameterIdList.add(subEntity.getSourceId());
		}
//		rentParameterService.saveOrUpdateBatch(parameterList);
		rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.启用单.getCode(),
				startEntity.getId());


		//推送供方
		//对单据进行加锁
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
			throw new BusinessException("获取当前系统编码失败！");
		}
		Map<String,Object> map = new HashMap<>();
		map.put("sourceId",billId);
		map.put("systemId",ejcCloudSystemCode.getData());
		String dataInfo = JSONObject.toJSONString(map);
		Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
				startEntity.getSupplierId().toString(),OPERATE,BILL_TYPE);
		if (!updateSupplierStatus){
			throw new BusinessException("单据推送失败！");
		}
		startEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		rentEquipmentStartService.saveOrUpdate(startEntity,false);

		return CommonResponse.success();
	}

}
