/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AmortizeSetEntity;
import com.ejianc.business.proequipmentcorppur.asset.mapper.AmortizeSetMapper;
import com.ejianc.business.proequipmentcorppur.asset.service.IAmortizeSetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AmortizeSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="amortizeSetService")
public class AmortizeSetServiceImpl
extends BaseServiceImpl<AmortizeSetMapper, AmortizeSetEntity>
implements IAmortizeSetService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IShareEquipmentApi shareEquipmentApi;

    @Override
    public AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getEnabled() == 1) {
            Integer typeFlag = saveOrUpdateVO.getTypeFlag();
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(AmortizeSetEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
            lambd.eq(AmortizeSetEntity::getTypeFlag, (Object)typeFlag);
            if (typeFlag == 1) {
                lambd.eq(AmortizeSetEntity::getEquipmentTypeId, (Object)saveOrUpdateVO.getEquipmentTypeId());
            } else {
                lambd.eq(AmortizeSetEntity::getEquipmentId, (Object)saveOrUpdateVO.getEquipmentId());
            }
            lambd.ne(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            int count = super.count((Wrapper)lambd);
            if (count > 0) {
                if (typeFlag == 1) {
                    throw new BusinessException("\u8bbe\u5907\u5206\u7c7b\u3010" + saveOrUpdateVO.getEquipmentTypeName() + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
                }
                throw new BusinessException("\u8bbe\u5907\u3010\u540d\u79f0\uff1a" + saveOrUpdateVO.getEquipmentName() + (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getSpec()) ? "\uff0c\u89c4\u683c\uff1a" + saveOrUpdateVO.getSpec() : "") + "\u3011\u644a\u9500\u8bbe\u7f6e\u5df2\u5b58\u5728");
            }
        }
        AmortizeSetEntity entity = (AmortizeSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AmortizeSetEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return (AmortizeSetVO)BeanMapper.map((Object)((Object)entity), AmortizeSetVO.class);
    }

    @Override
    public String turnSwitch(AmortizeSetVO vo) {
        LambdaUpdateWrapper lambdUpdate = new LambdaUpdateWrapper();
        lambdUpdate.set(AmortizeSetEntity::getEnabled, (Object)vo.getEnabled());
        lambdUpdate.eq(BaseEntity::getId, (Object)vo.getId());
        boolean update = super.update((Wrapper)lambdUpdate);
        return update ? "\u64cd\u4f5c\u6210\u529f\uff01" : "\u64cd\u4f5c\u5931\u8d25\uff01";
    }

    @Override
    public Map<Long, AmortizeSetEntity> getSet(Map<Long, Long> equipments, Long orgId) {
        CommonResponse listCommonResponse = this.shareEquipmentApi.queryCategoryListByIds(new ArrayList<Long>(equipments.values()));
        HashMap<Long, List<Long>> equipTypeMap = new HashMap<Long, List<Long>>();
        HashSet<Long> materialTypeIds = new HashSet<Long>();
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            List data = (List)listCommonResponse.getData();
            for (EquipmentCategoryVO categoryVO : data) {
                Long categoryVOId = categoryVO.getId();
                String innerCode = categoryVO.getInnerCode();
                String[] innerCodeArr = innerCode.split("\\|");
                for (int i = innerCodeArr.length - 1; i >= 0; --i) {
                    ArrayList<Long> pIds = (ArrayList<Long>)equipTypeMap.get(categoryVOId);
                    Long pId = Long.valueOf(innerCodeArr[i]);
                    if (pIds == null) {
                        pIds = new ArrayList<Long>();
                        pIds.add(pId);
                        equipTypeMap.put(categoryVOId, pIds);
                    } else {
                        pIds.add(pId);
                    }
                    materialTypeIds.add(pId);
                }
            }
        }
        CommonResponse orgRes = this.iOrgApi.getOneById(orgId);
        OrgVO orgVO = (OrgVO)orgRes.getData();
        String orgIdsStr = orgVO.getInnerCode();
        List<String> orgIds = Arrays.asList(orgIdsStr.split("\\|"));
        LambdaQueryWrapper lambdQuery = new LambdaQueryWrapper();
        lambdQuery.in(AmortizeSetEntity::getOrgId, orgIds);
        lambdQuery.and(wrapper -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(AmortizeSetEntity::getEquipmentId, equipments.keySet())).or()).in(AmortizeSetEntity::getEquipmentTypeId, (Collection)materialTypeIds));
        lambdQuery.eq(AmortizeSetEntity::getEnabled, (Object)1);
        List list = this.list((Wrapper)lambdQuery);
        HashMap<Long, AmortizeSetEntity> resSetMap = new HashMap<Long, AmortizeSetEntity>();
        Map<Long, List<AmortizeSetEntity>> orgSetMaps = list.stream().collect(Collectors.groupingBy(AmortizeSetEntity::getOrgId));
        Collections.reverse(orgIds);
        for (String id : orgIds) {
            List<AmortizeSetEntity> amortizeSetEntities = orgSetMaps.get(Long.valueOf(id));
            if (!MapUtils.isNotEmpty(equipments) || !CollectionUtils.isNotEmpty(amortizeSetEntities)) continue;
            Map<Long, AmortizeSetEntity> orgSetMap = amortizeSetEntities.stream().collect(Collectors.toMap(k -> k.getEquipmentId() != null ? k.getEquipmentId() : k.getEquipmentTypeId(), v -> v, (p1, p2) -> p1));
            this.getAmortizeSet(equipments, orgSetMap, equipTypeMap, resSetMap);
        }
        return resSetMap;
    }

    private void getAmortizeSet(Map<Long, Long> equipments, Map<Long, AmortizeSetEntity> orgSetMap, HashMap<Long, List<Long>> equipTypeMap, Map<Long, AmortizeSetEntity> resSetMap) {
        for (Long equipmentId : equipments.keySet()) {
            AmortizeSetEntity am = resSetMap.get(equipmentId);
            if (am != null) continue;
            Long equipmentTypeId = equipments.get(equipmentId);
            AmortizeSetEntity amortizeSetEntity = orgSetMap.get(equipmentId);
            if (amortizeSetEntity == null && (amortizeSetEntity = orgSetMap.get(equipmentTypeId)) == null) {
                Long pId;
                List<Long> pIds = equipTypeMap.get(equipmentTypeId);
                Iterator<Long> iterator = pIds.iterator();
                while (iterator.hasNext() && (amortizeSetEntity = orgSetMap.get(pId = iterator.next())) == null) {
                }
            }
            if (amortizeSetEntity != null) {
                equipments.remove((Object)amortizeSetEntity);
            }
            resSetMap.put(equipmentId, amortizeSetEntity);
        }
    }
}

