/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotInDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotInEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotOutDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.AssetAllotInMessageService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotInService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotOutDetailService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotOutService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAllotInVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAllotOutVO;
import com.ejianc.business.proequipmentcorppur.consts.AllocationState;
import com.ejianc.business.proequipmentcorppur.consts.NoticeEnum;
import com.ejianc.business.proequipmentcorppur.decorator.IAssetRecord;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="assetAllotOut")
public class AssetAllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetAllotOutService service;
    @Autowired
    private IAssetAllotOutDetailService assetAllotOutDetailService;
    @Autowired
    private IAssetAllotInService assetAllotInService;
    @Autowired
    private AssetAllotInMessageService allotInMessageService;
    @Autowired
    private IAssetRecordService assetRecordService;
    private static final String BILL_CODE = "ASSET_ALLOT_IN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        block7: {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAssetAllotIn", (int)1000);
            this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
            try {
                if (locked) {
                    break block7;
                }
                CommonResponse commonResponse = CommonResponse.success((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return commonResponse;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAssetAllotIn");
                }
                jedis.close();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AssetAllotOutEntity assetAllotOutEntity = (AssetAllotOutEntity)((Object)this.service.selectById(billId));
        if (!Objects.isNull((Object)assetAllotOutEntity)) {
            if (CollectionUtils.isNotEmpty(assetAllotOutEntity.getAssetAllotOutDetailList())) {
                List longs = assetAllotOutEntity.getAssetAllotOutDetailList().stream().map(AssetAllotOutDetailEntity::getAssetId).collect(Collectors.toList());
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.in((Object)"asset_id", longs);
                detailWrapper.ne((Object)"allocat_id", (Object)assetAllotOutEntity.getId());
                detailWrapper.eq((Object)"dr", (Object)0);
                List list = this.assetAllotOutDetailService.list((Wrapper)detailWrapper);
                if (list.size() > 0) {
                    return CommonResponse.error((String)"\u8bbe\u5907\u4fe1\u606f\u4e2d\u5b58\u5728\u8bbe\u5907\u5df2\u7ecf\u88ab\u8c03\u51fa\u4e0d\u80fd\u518d\u88ab\u8c03\u51fa!");
                }
            }
            if (assetAllotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))) {
                LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
                allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
                allotOutWrapper.set(AssetAllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
                allotOutWrapper.set(AssetAllotOutEntity::getReturnReason, null);
                allotOutWrapper.set(AssetAllotOutEntity::getReceiverPersonId, null);
                allotOutWrapper.set(AssetAllotOutEntity::getReceiverPerson, null);
                this.service.update((Wrapper)allotOutWrapper);
            }
            AssetAllotInEntity assetAllotInEntity = new AssetAllotInEntity();
            assetAllotInEntity.setOutAllocatRange(assetAllotOutEntity.getAllocatRange());
            assetAllotInEntity.setAllocatRange(assetAllotOutEntity.getInAllocatRange());
            assetAllotInEntity.setOutProjectId(assetAllotOutEntity.getProjectId());
            assetAllotInEntity.setOutProjectName(assetAllotOutEntity.getProjectName());
            assetAllotInEntity.setOutOrgId(assetAllotOutEntity.getOrgId());
            assetAllotInEntity.setOutOrgName(assetAllotOutEntity.getOrgName());
            assetAllotInEntity.setOutOrgCode(assetAllotOutEntity.getOrgCode());
            assetAllotInEntity.setOutParentOrgId(assetAllotOutEntity.getParentOrgId());
            assetAllotInEntity.setOutParentOrgName(assetAllotOutEntity.getParentOrgName());
            assetAllotInEntity.setOutParentOrgCode(assetAllotOutEntity.getParentOrgCode());
            assetAllotInEntity.setOutTaxMny(assetAllotOutEntity.getOutTaxMny());
            assetAllotInEntity.setProjectId(assetAllotOutEntity.getInProjectId());
            assetAllotInEntity.setProjectName(assetAllotOutEntity.getInProjectName());
            assetAllotInEntity.setParentOrgId(assetAllotOutEntity.getInParentOrgId());
            assetAllotInEntity.setParentOrgName(assetAllotOutEntity.getInParentOrgName());
            assetAllotInEntity.setParentOrgCode(assetAllotOutEntity.getInParentOrgCode());
            assetAllotInEntity.setOrgId(assetAllotOutEntity.getInOrgId());
            assetAllotInEntity.setOrgCode(assetAllotOutEntity.getInOrgCode());
            assetAllotInEntity.setOrgName(assetAllotOutEntity.getInOrgName());
            assetAllotInEntity.setChangeCompany(assetAllotInEntity.getChangeCompany());
            assetAllotInEntity.setAllocatOutId(assetAllotOutEntity.getId());
            assetAllotInEntity.setOutMny(assetAllotOutEntity.getOutMny());
            assetAllotInEntity.setOutDate(assetAllotOutEntity.getOutDate());
            assetAllotInEntity.setEmployeeId(assetAllotOutEntity.getEmployeeId());
            assetAllotInEntity.setEmployeeName(assetAllotOutEntity.getEmployeeName());
            assetAllotInEntity.setDepartmentId(assetAllotOutEntity.getDepartmentId());
            assetAllotInEntity.setDepartmentName(assetAllotOutEntity.getDepartmentName());
            assetAllotInEntity.setNotifyReceiverId(assetAllotOutEntity.getReceiverId());
            assetAllotInEntity.setReceiverName(assetAllotOutEntity.getReceiverName());
            assetAllotInEntity.setAllocatType(assetAllotOutEntity.getAllocatType());
            assetAllotInEntity.setMemo(assetAllotOutEntity.getMemo());
            assetAllotInEntity.setEquipmentNames(assetAllotOutEntity.getEquipmentNames());
            assetAllotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
            long id = IdWorker.getId();
            if (CollectionUtils.isNotEmpty(assetAllotOutEntity.getAssetAllotOutDetailList())) {
                List inDetailEntities = BeanMapper.mapList(assetAllotOutEntity.getAssetAllotOutDetailList(), AssetAllotInDetailEntity.class);
                inDetailEntities.forEach(item -> {
                    item.setId(null);
                    item.setAllocatId(id);
                });
                assetAllotInEntity.setAssetAllotInDetailList(inDetailEntities);
                this.logger.info("\u5b50\u8868\u4fe1\u606f\uff1a" + inDetailEntities.toString());
            }
            AssetAllotInVO vo = (AssetAllotInVO)BeanMapper.map((Object)((Object)assetAllotInEntity), AssetAllotInVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            assetAllotInEntity.setBillCode((String)billCode.getData());
            assetAllotInEntity.setId(id);
            boolean b = this.assetAllotInService.saveOrUpdate((Object)assetAllotInEntity, false);
            if (b) {
                AssetAllotInEntity allot = (AssetAllotInEntity)((Object)this.assetAllotInService.selectById(Long.valueOf(id)));
                if (allot != null && allot.getNotifyReceiverId() != null) {
                    String[] notifyReceive = new String[]{String.valueOf(allot.getNotifyReceiverId())};
                    this.allotInMessageService.sendMsg(allot, notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
                }
                AssetAllotOutVO allotOutVO = (AssetAllotOutVO)BeanMapper.map((Object)((Object)assetAllotOutEntity), AssetAllotOutVO.class);
                this.assetRecordService.saveRecord((IAssetRecord)allotOutVO);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.assetRecordService.delRecord(billId);
        return CommonResponse.success();
    }
}

