/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotOutDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAmortizeDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetHandleDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetScrapDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAllotOutDetailService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAmortizeService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetScrapDetailService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.service.IHandleDetailService;
import com.ejianc.business.proequipmentcorppur.utils.DateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortize")
public class AssetAmortizeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IAssetAmortizeService assetAmortizeService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetAllotOutDetailService assetAllotOutDetailService;
    @Autowired
    private IAssetScrapDetailService assetScrapDetailService;
    @Autowired
    private IHandleDetailService handleDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Date amortizeDate = assetAmortizeEntity.getAmortizeDate();
            Long projectId = assetAmortizeEntity.getProjectId();
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(assetId));
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeAdd((BigDecimal)amortizeMnyTax, (BigDecimal)assetEntity.getLastAmortizeTaxMny());
                BigDecimal sumAmortizeMny = ComputeUtil.safeAdd((BigDecimal)amortizeMny, (BigDecimal)assetEntity.getLastAmortizeMny());
                BigDecimal netWorthTax = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValueTax(), (BigDecimal)sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValue(), (BigDecimal)sumAmortizeMny);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)assetId);
                wrapper.eq(AssetEntity::getProjectId, (Object)projectId);
                wrapper.set(AssetEntity::getLastAmortizeDate, (Object)amortizeDate);
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, (Object)sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, (Object)sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, (Object)netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, (Object)netWorth);
                this.assetService.update((Wrapper)wrapper);
            }
            this.logger.info("\u63a8\u9001\u6210\u672c---");
            AssetAmortizeEntity assetAmortizeEntity1 = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
            this.assetAmortizeService.costPush(assetAmortizeEntity1);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        Date createTime = assetAmortizeEntity.getCreateTime();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List assetIds = detailList.stream().map(AssetAmortizeDetailEntity::getAssetId).collect(Collectors.toList());
            LambdaQueryWrapper outQuery = new LambdaQueryWrapper();
            outQuery.in(AssetAllotOutDetailEntity::getAssetId, assetIds);
            outQuery.ge(BaseEntity::getCreateTime, (Object)createTime);
            int count = this.assetAllotOutDetailService.count((Wrapper)outQuery);
            if (count > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u660e\u7ec6\u5b58\u5728\u540e\u7eed\u8c03\u51fa\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
            }
            LambdaQueryWrapper scrapQuery = new LambdaQueryWrapper();
            scrapQuery.in(AssetScrapDetailEntity::getAssetId, assetIds);
            scrapQuery.ge(BaseEntity::getCreateTime, (Object)createTime);
            int c = this.assetScrapDetailService.count((Wrapper)scrapQuery);
            if (c > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u660e\u7ec6\u5b58\u5728\u540e\u7eed\u62a5\u5e9f\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
            }
            LambdaQueryWrapper handQuery = new LambdaQueryWrapper();
            handQuery.in(AssetHandleDetailEntity::getAssetId, assetIds);
            handQuery.ge(BaseEntity::getCreateTime, (Object)createTime);
            int ct = this.handleDetailService.count((Wrapper)handQuery);
            if (ct > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u660e\u7ec6\u5b58\u5728\u540e\u7eed\u5904\u7f6e\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
            }
        }
        Long orgId = assetAmortizeEntity.getOrgId();
        Date amortizeDate = assetAmortizeEntity.getAmortizeDate();
        LambdaQueryWrapper qu = new LambdaQueryWrapper();
        qu.eq(AssetAmortizeEntity::getOrgId, (Object)orgId);
        qu.gt(AssetAmortizeEntity::getAmortizeDate, (Object)DateUtil.format(amortizeDate, "yyyy-MM-dd"));
        int count = this.assetAmortizeService.count((Wrapper)qu);
        if (count > 0) {
            return CommonResponse.error((String)"\u8be5\u644a\u9500\u5355\u4f4d\u5df2\u6709\u540e\u7eed\u7684\u644a\u9500\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5904\u7f6eId---{}", (Object)assetAmortizeEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(assetAmortizeEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{assetAmortizeEntity.getId()});
        updateWrapper.set(AssetAmortizeEntity::getRelationFlag, (Object)0);
        this.assetAmortizeService.update((Wrapper)updateWrapper);
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                Long projectId = assetAmortizeEntity.getProjectId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(assetId));
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeSub((BigDecimal)assetEntity.getLastAmortizeTaxMny(), (BigDecimal)amortizeMnyTax);
                BigDecimal sumAmortizeMny = ComputeUtil.safeSub((BigDecimal)assetEntity.getLastAmortizeMny(), (BigDecimal)amortizeMny);
                BigDecimal netWorthTax = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValueTax(), (BigDecimal)sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValue(), (BigDecimal)sumAmortizeMny);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)assetId);
                wrapper.eq(AssetEntity::getProjectId, (Object)projectId);
                wrapper.set(AssetEntity::getLastAmortizeDate, (Object)entity.getLastAmortizeDate());
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, (Object)sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, (Object)sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, (Object)netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, (Object)netWorth);
                this.assetService.update((Wrapper)wrapper);
            }
        }
        return CommonResponse.success();
    }
}

