/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.purchaseApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.mapper.PurchaseApplyMapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseApplyService")
public class PurchaseApplyServiceImpl
extends BaseServiceImpl<PurchaseApplyMapper, PurchaseApplyEntity>
implements IPurchaseApplyService {
    @Autowired
    private PurchaseApplyMapper mapper;

    @Override
    public void saveOrUpdates(PurchaseApplyEntity entity) {
        List<PurchaseApplyDetailedEntity> listbs = entity.getDetailList();
        if (CollectionUtil.isNotEmpty(listbs)) {
            StringBuilder equipmentTypes = new StringBuilder();
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (!"del".equals(cdEntity.getRowState())) {
                    equipmentTypes.append(cdEntity.getEquipmentName()).append(",");
                }
                if (null != cdEntity.getParentId()) continue;
                idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
            }
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                    continue;
                }
                cdEntity.setTid(cdEntity.getId());
            }
            entity.setEquipmentTypes(equipmentTypes.substring(0, equipmentTypes.length() - 1));
        }
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public List<PurchaseApplyVO> queryApplyListByOrgId(Long orgId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        List entities = super.list((Wrapper)query);
        return BeanMapper.mapList((Iterable)entities, PurchaseApplyVO.class);
    }

    @Override
    public Boolean checkSameBillCode(PurchaseApplyVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseApplyEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void updateBatApplyByQuoteType(List<String> idList, Integer planState) {
    }
}

