/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentPlanEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentPlanService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentPlanSubService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentEquipmentPlanSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentEquipmentPlanVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentPlanEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentEquipmentPlan"})
public class RentEquipmentPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "IN_RENT_PLAN";
    @Autowired
    private IRentEquipmentPlanService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentEquipmentPlanSubService rentEquipmentPlanSubService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentEquipmentPlanVO> saveOrUpdate(@RequestBody RentEquipmentPlanVO saveOrUpdateVO) {
        RentEquipmentPlanEntity entity = (RentEquipmentPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentEquipmentPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getBiddingState() == null) {
            entity.setBiddingState(RentPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        this.service.saveOrUpdate((Object)entity, false);
        RentEquipmentPlanVO vo = (RentEquipmentPlanVO)BeanMapper.map((Object)((Object)entity), RentEquipmentPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentEquipmentPlanVO> queryDetail(Long id) {
        RentEquipmentPlanEntity entity = (RentEquipmentPlanEntity)((Object)this.service.selectById(id));
        RentEquipmentPlanVO vo = (RentEquipmentPlanVO)BeanMapper.map((Object)((Object)entity), RentEquipmentPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentEquipmentPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RentEquipmentPlanVO rentEquipmentPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            voList = BeanMapper.mapList((Iterable)page.getRecords(), RentEquipmentPlanVO.class);
            for (RentEquipmentPlanVO vo : voList) {
                vo.setBiddingStateName(RentPlanEnum.getDescriptionByStateCode((Integer)vo.getBiddingState()));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, RentEquipmentPlanVO.class);
            for (RentEquipmentPlanVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("rentEquipmentPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentEquipmentPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanSubVO>> refRentEquipmentPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Object projectId = null;
        List list = new ArrayList();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            QueryParam params = new QueryParam();
            params.getParams().put("projectId", new Parameter("eq", projectId));
            list = this.service.queryList(params);
            param.getParams().put("leafFlag", new Parameter("eq", (Object)false));
            param.getParams().put("pid", new Parameter("in", list.stream().map(BaseEntity::getId).collect(Collectors.toList())));
        }
        IPage page = this.rentEquipmentPlanSubService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentEquipmentPlanSubVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanVO>> refRentPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam params = new QueryParam();
        params.setPageSize(pageSize.intValue());
        params.setPageIndex(pageNumber.intValue());
        params.setSearchText(searchText);
        params.setSearchObject(searchObject);
        Long projectId = null;
        Long orgId = null;
        params.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
        }
        params.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        params.getParams().put("biddingState", new Parameter("eq", (Object)1));
        if (projectId != null) {
            CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
            if (!projectResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            params.getParams().put("projectId", new Parameter("in", projectResponse.getData()));
        }
        if (orgId != null) {
            CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
            OrgVO orgVO = (OrgVO)orgResp.getData();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                params.getParams().put("companyId", new Parameter("eq", (Object)orgId));
            } else {
                params.getParams().put("companyId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(params, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentEquipmentPlanVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List batPlanVOList = pageData.getRecords();
            List idList = batPlanVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("pid", new Parameter("in", idList));
            detailParam.getParams().put("equipment_id", new Parameter("ne", null));
            List detailEntityList = this.rentEquipmentPlanSubService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, RentEquipmentPlanSubVO.class);
            HashMap detailMap = new HashMap();
            for (RentEquipmentPlanSubVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPid())) {
                    ((List)detailMap.get(vo.getPid())).add(vo);
                    continue;
                }
                ArrayList<RentEquipmentPlanSubVO> mapList = new ArrayList<RentEquipmentPlanSubVO>();
                mapList.add(vo);
                detailMap.put(vo.getPid(), mapList);
            }
            batPlanVOList.forEach(batPlanVO -> batPlanVO.setRentEquipmentPlanSubList((List)detailMap.get(batPlanVO.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentEquipmentPlanContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentEquipmentPlanSubVO>> refRentEquipmentPlanContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        ArrayList list = new ArrayList();
        Long id = null;
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            id = Long.parseLong(relyCondition.split("=")[1]);
        }
        this.logger.info("#############{}", id);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (id != null) {
            param.getParams().put("pid", new Parameter("eq", (Object)id));
        }
        IPage page = this.rentEquipmentPlanSubService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentEquipmentPlanSubVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

