package com.ejianc.business.proequipmentcorppur.purchaseApply.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备采购-采购申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_purchase_apply")
public class PurchaseApplyEntity extends BaseEntity {

    private static final long serialVersionUID = -697128152142091664L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 计划编号
    @TableField(value="apply_total_mny")
    private BigDecimal applyTotalMny; // 申请总金额
    @TableField(value="employee")
    private String employee; // 申请人
    @TableField(value="employee_id")
    private Long employeeId; // 申请人id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 采购组织Id
    @TableField(value="org_name")
    private String orgName; // 采购组织名称
    @TableField(value="org_code")
    private String orgCode; // 采购组织编码
    @TableField(value = "plan_name")
    private String planName; //计划名称
    @TableField(value = "apply_date")
    private Date applyDate; //申请日期

    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码

    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编号
    @TableField(value = "project_id")
    private Long projectId; // 项目id
    @TableField(value="plan_state")
    private Integer planState; // 招标状态（采购状态）（0-待采购,1-采购中,2-采购完成）
    @TableField(value = "bid_status")
    private String bidStatus; // 招标状态:待招标、招标中、已招标（招标业务返回对应状态）

    @TableField(value = "apply_org_id")
    private Long applyOrgId; //申请组织Id

    @TableField(value = "apply_org_name")
    private String applyOrgName; //申请组织名称

    @TableField(value = "apply_org_code")
    private String applyOrgCode; //申请组织编码

    @TableField(value="equipment_types")
    private String equipmentTypes; // 设备类别名称，多个逗号分隔

    /**
     * 采购申请-计划清单明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseApplyDetailedService", pidName = "applyId")
    private List<PurchaseApplyDetailedEntity> detailList = new ArrayList<>();

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public List<PurchaseApplyDetailedEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchaseApplyDetailedEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getApplyTotalMny() {
        return applyTotalMny;
    }

    public void setApplyTotalMny(BigDecimal applyTotalMny) {
        this.applyTotalMny = applyTotalMny;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }


    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getBidStatus() {
        return bidStatus;
    }

    public void setBidStatus(String bidStatus) {
        this.bidStatus = bidStatus;
    }

    public String getEquipmentTypes() {
        return equipmentTypes;
    }

    public void setEquipmentTypes(String equipmentTypes) {
        this.equipmentTypes = equipmentTypes;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getApplyOrgCode() {
        return applyOrgCode;
    }

    public void setApplyOrgCode(String applyOrgCode) {
        this.applyOrgCode = applyOrgCode;
    }
}
