package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentAcceptanceMapper;
import com.ejianc.business.proequipmentcorprent.rent.mapper.RentAcceptanceSubMapper;
import com.ejianc.business.proequipmentcorprent.rent.service.*;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractEquipmentAllVO;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryDetailEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryDetailService;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryService;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租赁设备验收
 * 
 * @author generator
 * 
 */
@Service("rentAcceptanceService")
public class RentAcceptanceServiceImpl extends BaseServiceImpl<RentAcceptanceMapper, RentAcceptanceEntity> implements IRentAcceptanceService{
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentAcceptanceSubService rentAcceptanceSubService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String OPERATE = "CORP_RENT_CHECK";
    private static final String BILL_TYPE_CODE = "EJCBT202210000025";//此处需要根据实际修改

    @Autowired
    private RentAcceptanceMapper acceptanceMapper;
    @Autowired
    private IRentEquipmentStartService rentEquipmentStartService;
    @Autowired
    private IRentEquipmentStopService rentEquipmentStopService;
    @Autowired
    private IRentParameterService rentParameterService;

    @Autowired
    private RentAcceptanceSubMapper rentAcceptanceSubMapper;
    @Autowired
    private IRentDeliveryService rentDeliveryService;
    @Autowired
    private IRentDeliveryDetailService rentDeliveryDetailService;


    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/corpRentDelivery/saveEquipmentDeliveryState";


    /**
     * 保存验收
     * @param entity
     */
    @Override
    public void saveOrUpdates(RentAcceptanceEntity entity) {
        this.valiDataSave(entity);
    }

    /**
     * 保存前检验
     * @param entity
     */
    public void valiDataSave(RentAcceptanceEntity entity){

        if( DateUtil.compareDate(entity.getRentDate(),entity.getAcceptanceDate()) == -1){
            throw new BusinessException("计租日期必须大于等于验收日期");
        }

        RentAcceptanceEntity validaAcceptanceEntity =this.selectByContractId(entity.getContractId());
        if(validaAcceptanceEntity != null && entity.getId() ==null){
            throw new BusinessException("该合同存在未生效的单据");
        }

        if(validaAcceptanceEntity != null && entity.getId() !=null){
            if(entity.getId() != null && !entity.getId().equals(validaAcceptanceEntity.getId()) ){
                throw new BusinessException("该合同存在未生效的单据");
            }
        }

        RentEquipmentStartEntity vStartEntity = rentEquipmentStartService.selectByContractIdEquipmentStart(entity.getContractId());
        if(vStartEntity != null && vStartEntity.getContractId() != entity.getContractId()){
            throw new BusinessException("该合同存在未生效的设备启用单据");
        }

        RentEquipmentStopEntity vStopEntity = rentEquipmentStopService.selectByEquipmentStop(entity.getContractId());
        if(vStopEntity != null && vStopEntity.getContractId() != entity.getContractId()){
            throw new BusinessException("该合同存在未生效的设备停用单据");
        }
        CommonResponse<String> commonResponse= rentParameterService.selectValidationNewDate(entity.getContractId(),entity.getAcceptanceDate(),entity.getId());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        if(CollectionUtils.isNotEmpty(entity.getRentAcceptanceSubList())){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List<RentAcceptanceSubEntity> subList =entity.getRentAcceptanceSubList();
            EquipmentNewDateVO subDate =rentParameterService.selectValidationNewDateSub(entity.getContractId());
            for (int i = 0; i < subList.size(); i++) {
                RentAcceptanceSubEntity sub = entity.getRentAcceptanceSubList().get(i);
                if("del".equals(sub.getRowState())){
                    continue;
                }
                if(subDate != null && DateUtil.compareDate(sub.getMeterRentDate(),subDate.getPerformDate()) == -1){
                   throw new BusinessException("设备清单日期不是最新日期,最新日期:"+sdf.format(subDate.getPerformDate()));
                }
                ;
                if(StringUtils.isEmpty(sub.getFactoryCode())){
                    sub.setFactoryCode(randomCode()+"");
                }
                for (int j = i+1; j < subList.size(); j++) {
                    RentAcceptanceSubEntity subEntity = subList.get(j);
                    if("del".equals(subEntity.getRowState())){
                        continue;
                    }
                    if (sub.getFactoryCode().equals(subEntity.getFactoryCode())) {
                        throw new BusinessException("设备出场编码重复："+subEntity.getFactoryCode()+"验收明细编码互相重复！");
                    }
                }
                RentAcceptanceSubEntity rentAcceptanceSubEntity =this.selectFactoryCode(sub.getFactoryCode());
                if((rentAcceptanceSubEntity != null && sub.getId() != null) && !(rentAcceptanceSubEntity.getId().equals(sub.getId()))){
                    throw new BusinessException("设备出场编码重复："+rentAcceptanceSubEntity.getFactoryCode()+"已验收！");
                }
                if(sub.getId() == null){
                    if(rentAcceptanceSubEntity != null){
                        throw new BusinessException("设备出场编码重复："+rentAcceptanceSubEntity.getFactoryCode()+"已验收！");
                    }
                }
            }
        }
        List<RentAcceptanceSubEntity> rentAcceptanceSubList = entity.getRentAcceptanceSubList();
        for (RentAcceptanceSubEntity rentAcceptanceSubEntity : rentAcceptanceSubList){
            rentAcceptanceSubEntity.setNum(1);
        }

        this.saveOrUpdate(entity,false);

        //回写发货单数据
        if (entity.getAcceptanceSourceId() == 2) {
            Integer checkStatus = 0;
            RentDeliveryEntity deliveryEntity = rentDeliveryService.selectById(entity.getDeliveryId());
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<RentAcceptanceSubEntity> lambdaCheckDetail = Wrappers.<RentAcceptanceSubEntity>lambdaQuery();
            lambdaCheckDetail.eq(RentAcceptanceSubEntity::getDeliveryId,entity.getDeliveryId());
            List<RentAcceptanceSubEntity> checkDetailEntityList = rentAcceptanceSubService.list(lambdaCheckDetail);
            if(CollectionUtils.isNotEmpty(checkDetailEntityList)){
                Map<Long, List<RentAcceptanceSubEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(RentAcceptanceSubEntity::getDeliveryDetailId));
                LambdaQueryWrapper<RentDeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<RentDeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(RentDeliveryDetailEntity::getDeliveryId,entity.getDeliveryId());
                List<RentDeliveryDetailEntity> deliveryDetailEntityList = rentDeliveryDetailService.list(lambdaDeliveryDetail);
                for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                    List<RentAcceptanceSubEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)){
                        Integer checkNum = checkAllDetailEntityList.stream().mapToInt(RentAcceptanceSubEntity::getNum).sum();
                        deliveryDetailEntity.setCheckNum(BigDecimal.valueOf(checkNum));
                    }
                    if (null == deliveryDetailEntity.getCheckNum()){
                        deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                    }
                }

                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));

                if (allCheck){
                    checkStatus = 2;
                }
                if (anyCheck){
                    checkStatus = 1;
                }
                //更新发货验收状态和验收数量

                deliveryEntity.setCheckStatus(checkStatus);
                rentDeliveryService.updateById(deliveryEntity);
                rentDeliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }

            //推送供方
            //对单据进行加锁
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("获取当前系统编码失败！");
            }
            Map<String,Object> map = new HashMap<>();
            map.put("sourceId",deliveryEntity.getSourceId());
            map.put("checkStatus",checkStatus);
            map.put("systemId",ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = rentDeliveryService.updateSupplierStatus(deliveryEntity.getId(),dataInfo,PUSH_BILL_SERVER_URL,RequestMethod.POST,
                    deliveryEntity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
            if (!updateSupplierStatus){
                throw new BusinessException("单据推送失败！");
            }
        }
    }

    /**
     * 根据合同id
     * @param contractId
     * @return
     */
    public RentAcceptanceEntity selectByContractId(Long contractId){
        QueryWrapper<RentAcceptanceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr","0");
        queryWrapper.eq("bill_state","0");
        List<RentAcceptanceEntity> list =acceptanceMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            RentAcceptanceEntity entity = list.get(0);
            return entity;
        }
        return null;
    }

    @Override
    public void deletes(List<RentAcceptanceVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1){
            throw new BusinessException("验收单不允许批量删除!");
        }
        RentAcceptanceVO checkVO = vos.get(0);
        RentAcceptanceEntity checkEntity = super.selectById(checkVO.getId());
        List<RentAcceptanceSubEntity> checkDetailList = checkEntity.getRentAcceptanceSubList();
        RentDeliveryEntity deliveryEntity = rentDeliveryService.selectById(checkEntity.getDeliveryId());
        if (deliveryEntity != null){
            List<RentDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map<Long, RentAcceptanceSubEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(RentAcceptanceSubEntity::getDeliveryDetailId, Function.identity()));
            for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                if(checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())){
                    RentAcceptanceSubEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
                    deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(BigDecimal.valueOf(checkDetailEntity.getNum())));
                }
            }

            //判断发货单的验收状态
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                    (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));
            Integer checkStatus = 0;
            if (allCheck){
                checkStatus = 2;
            }
            if (anyCheck){
                checkStatus = 1;
            }
            //更新发货验收状态和验收数量
            deliveryEntity.setCheckStatus(checkStatus);
            rentDeliveryService.updateById(deliveryEntity);
            rentDeliveryDetailService.updateBatchById(deliveryDetailList);

            //推送供方
            //对单据进行加锁
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("获取当前系统编码失败！");
            }
            Map<String,Object> map = new HashMap<>();
            map.put("sourceId",deliveryEntity.getSourceId());
            map.put("checkStatus",checkStatus);
            map.put("systemId",ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = rentDeliveryService.updateSupplierStatus(deliveryEntity.getId(),dataInfo,PUSH_BILL_SERVER_URL,RequestMethod.POST,
                    deliveryEntity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
            if (!updateSupplierStatus){
                throw new BusinessException("单据推送失败！");
            }
        }

        super.removeByIds(vos.stream().map(RentAcceptanceVO::getId).collect(Collectors.toList()),true);
        return ;

    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        RentAcceptanceEntity checkEntity = super.selectById(billId);
        //设置供方签字信息
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE_CODE + "::" + checkEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", checkEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE_CODE, authority, checkEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            checkEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            checkEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(checkEntity, false);

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", checkEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        logger.info("dataInfo" + datInfo);
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", datInfo);

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", supplierId, JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url,
                        paramMap,
                        supplierId.toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送验收单据id-{}失败, {}", supplierId, sourceId, billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送验收单据id-{}给供方id-{}失败, {}", sourceId, supplierId, syncReqResp.getMsg());
                }
            } else {
                logger.error("获取验收单据id-{}对应附件信息失败, {}", sourceId, fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送验收单据id-{}给供方id-{} 异常，", sourceId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /**
     * 根据合同id
     * @return
     */
    @Override
    public RentAcceptanceSubEntity selectFactoryCode(String factoryCode){
        QueryWrapper<RentAcceptanceSubEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr","0");
        queryWrapper.eq("factory_code",factoryCode);

        List<RentAcceptanceSubEntity> list =rentAcceptanceSubMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            RentAcceptanceSubEntity entity = list.get(0);
            return entity;
        }
        return null;
    }
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method,String supplierId,String operate,String billTypeCode) {
        //推送供方
        //对单据进行加锁
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = jedisPool.getResource();
        try {
            locked = RedisTool.tryLock(jedis, key, operate, 600);
            if(!locked) {
                releaseLock(jedis, false, key, operate);
                logger.error("单据{}推送失败，单据锁获取失败-{}！", billId, locked);
                return false;
            }
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,method,dataInfo,supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, billPushResp.getMsg());
                }
            } else {
                logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, syncReqResp.getMsg());

            }
        } catch (Exception e) {
            logger.error("推送发货单单据id-{}给供方id-{} 异常，", billId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }
    private static Long randomCode()  {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        secureRandom.setSeed(1000000L);
        return secureRandom.nextInt(10000)+System.currentTimeMillis();
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }


    /**
     * 根据项目id、验收日期查询设备租赁单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Integer
     */
    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper<RentAcceptanceEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(RentAcceptanceEntity::getProjectId, projectId)
                .eq(RentAcceptanceEntity::getAcceptanceDate, checkDate);
        return super.count(lambdaQuery);
    }

    /**
     * 查询子表数据
     * @return
     */
    @Override
    public List<RentAcceptanceSubVO> refRentAcceptanceDataDetail(Page<RentAcceptanceSubVO> page, QueryWrapper queryWrapper) {
        List<RentAcceptanceSubVO> list = baseMapper.refRentAcceptanceDataDetail(page,queryWrapper);
        return list;
    }
}
