package com.ejianc.business.proequipmentcorppur.purchase.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.business.proequipmentcorppur.purchase.service.ISignatureService;
import com.ejianc.business.proequipmentcorppur.purchase.vo.PurchaseContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("purchaseSignatureService")
public class SignatureServiceImpl implements ISignatureService {
    @Autowired
    private IPurchaseContractService contractService;

    @Autowired
    private IChangePurchaseContractService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${contract.mainContract}")
    private String mainContarct;

    @Value("${contract.changeContract}")
    private String changeContract;
    @Autowired
    private IPurchaseContractService purchaseContractService;


    /**
     * 签章流程
     * 单据签章状态修改逻辑
     * 1.主合同若签章状态为已签章，则修改主合同签章状态和合同状态以及生效时间，否则只修改签章状态
     * 2.变更合同
     *      若签章状态为已签章则将变更信息回写主合同，生成变更记录，改变变更合同签章状态
     *      否则改变变更合同签章状态，修改主合同的变更合同签章状态
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        logger.info("进入签章状态修改流程------------->");
        if (mainContarct.equals(refCode)) {//主合同
            PurchaseContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null) {
                if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                    contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                    contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
                    contractEntity.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
                    contractEntity.setFilingRef(0);
                    contractEntity.setEffectiveDate(new Date());
                } else {
                    contractEntity.setSignatureStatus(String.valueOf(signatureStatus));
                }
                contractService.saveOrUpdate(contractEntity, false);
                purchaseContractService.pushContract(BeanMapper.map(contractEntity, PurchaseContractVO.class));
                logger.info("主合同签章状态已修改---------------->");
            } else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        } else if (changeContract.equals(refCode)) {//变更合同
            ChangePurchaseContractEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null) {
                if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                    return changeService.effectiveSaveWriteContract(id, changeEntity.getBillCode(), false,true);
                }else {
                    changeEntity.setSignatureStatus(String.valueOf(signatureStatus));
                    changeService.saveOrUpdate(changeEntity);
                    logger.info("变更合同签章状态已修改---------------->");
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(PurchaseContractEntity::getId, changeEntity.getContractId());
                    updateWrapper.set(PurchaseContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
