package com.ejianc.business.proequipmentcorppur.settlement.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备采购-采购合同结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_purchase_settlement")
public class PurchaseSettlementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="settlement_date")
    private Date settlementDate; // 结算日期
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="contract_property_code")
    private String contractPropertyCode; // 合同采购编码
    @TableField(value="contract_property_name")
    private String contractPropertyName; // 合同采购（属性）名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="signature_status")
    private Integer signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    @TableField(value="signature_type")
    private Integer signatureType; // 结算类型，0-过程,1-最终
    @TableField(value="settlement_mny")
    private BigDecimal settlementMny; // 结算金额(无税)
    @TableField(value="settlement_tax_mny")
    private BigDecimal settlementTaxMny; // 结算金额
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 结算税额
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 采购金额(无税)
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 采购金额
    @TableField(value="material_tax")
    private BigDecimal materialTax; // 采购税额
    @TableField(value="fee_mny")
    private BigDecimal feeMny; // 其他金额(无税)
    @TableField(value="fee_tax_mny")
    private BigDecimal feeTaxMny; // 其他金额
    @TableField(value="fee_tax")
    private BigDecimal feeTax; // 其他税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="contract_invoice_tax_mny")
    private BigDecimal contractInvoiceTaxMny; // 合同收票金额
    @TableField(value="contract_invoice_mny")
    private BigDecimal contractInvoiceMny; // 合同收票金额(不含税)
    @TableField(value="contract_pay_mny")
    private BigDecimal contractPayMny; // 合同已付金额
    @TableField(value="contract_pay_scale")
    private BigDecimal contractPayScale; // 合同支付比例
    @TableField(value="current_settlement_tax_mny")
    private BigDecimal currentSettlementTaxMny; // 含本期结算金额
    @TableField(value="current_settlement_mny")
    private BigDecimal currentSettlementMny; // 含本期结算金额（无税）
    @TableField(value="settlement_type")
    private Integer settlementType; // 对账单类型（0-物资采购结算单，1-混凝土结算单）
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value = "settlement_num")
    private Integer settlementNum;//生效结算次数
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;
    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;

    
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseSettlementDetailService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseSettlementDetailEntity> purchaseSettlementDetailList = new ArrayList<>(); // 设备采购结算明细表
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseSettlementFeeService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseSettlementFeeEntity> purchaseSettlementFeeList = new ArrayList<>(); // 设备采购结算其他费用表

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(Integer settlementNum) {
        this.settlementNum = settlementNum;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getSignatureType() {
        return signatureType;
    }

    public void setSignatureType(Integer signatureType) {
        this.signatureType = signatureType;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    public BigDecimal getContractPayScale() {
        return contractPayScale;
    }

    public void setContractPayScale(BigDecimal contractPayScale) {
        this.contractPayScale = contractPayScale;
    }
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }
    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    
    public List<PurchaseSettlementDetailEntity> getPurchaseSettlementDetailList() {
        return purchaseSettlementDetailList;
    }

    public void setPurchaseSettlementDetailList(List<PurchaseSettlementDetailEntity> purchaseSettlementDetailList) {
        this.purchaseSettlementDetailList = purchaseSettlementDetailList;
    }
    public List<PurchaseSettlementFeeEntity> getPurchaseSettlementFeeList() {
        return purchaseSettlementFeeList;
    }

    public void setPurchaseSettlementFeeList(List<PurchaseSettlementFeeEntity> purchaseSettlementFeeList) {
        this.purchaseSettlementFeeList = purchaseSettlementFeeList;
    }
}
