package com.ejianc.business.proequipmentcorprent.rentdelivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryDetailEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.bean.RentDeliveryEntity;
import com.ejianc.business.proequipmentcorprent.rentdelivery.mapper.RentDeliveryMapper;
import com.ejianc.business.proequipmentcorprent.rentdelivery.service.IRentDeliveryService;
import com.ejianc.business.proequipmentcorprent.rentdelivery.vo.RentDeliveryDetailVO;
import com.ejianc.business.proequipmentcorprent.rentdelivery.vo.RentDeliveryVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材-发货单
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class RentDeliveryServiceImpl extends BaseServiceImpl<RentDeliveryMapper, RentDeliveryEntity> implements IRentDeliveryService {
    @Autowired
    private IRentDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/corpRentDelivery/saveEquipmentDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "RENT-DELIVERY";//此处需要根据实际修改
    private final String OPERATE = "RENT-DELIVERY";
    private static final String BILL_TYPE_CODE = "EJCBT202210000024";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public RentAcceptanceVO queryDetailToCheck(Long id) {
        RentDeliveryEntity deliveryEntity = deliveryService.selectById(id);

        //处理组合验收数据返回
        RentAcceptanceVO checkVO = new RentAcceptanceVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(0);
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
//        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setProjectDepartmentId(deliveryEntity.getOrgId());
        checkVO.setProjectDepartmentName(deliveryEntity.getOrgName());
//        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
//        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setCarCode(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setSourceType(1);
        checkVO.setCompanyName(deliveryEntity.getOrgName());
        checkVO.setCompanyId(deliveryEntity.getOrgId());
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());

        checkVO.setRentOrgCode(deliveryEntity.getRentOrgCode());
        checkVO.setRentOrgId(deliveryEntity.getRentOrgId());
        checkVO.setRentOrgName(deliveryEntity.getRentOrgName());
        checkVO.setRentProjectAddr(deliveryEntity.getRentProjectAddr());
        checkVO.setRentProjectId(deliveryEntity.getRentProjectId());
        checkVO.setRentProjectCode(deliveryEntity.getRentProjectCode());
        checkVO.setRentProjectName(deliveryEntity.getRentProjectName());
        checkVO.setRentProjectType(deliveryEntity.getRentProjectType());
        RentContractEntity contractEntity = rentContractService.selectById(deliveryEntity.getContractId());
//        checkVO.setPricingType(contractEntity.getPricingType());

        //处理子表数据返回
        List<RentDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List<RentDeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1 )
                .collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)){
            ArrayList<RentAcceptanceSubVO> checkDetailVOS = new ArrayList<>();
            for (RentDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                RentAcceptanceSubVO checkDetailVO = new RentAcceptanceSubVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setEquipmentId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setEquipmentCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setCategoryId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setCategoryName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setUnitName(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpecs(deliveryDetailEntity.getSpec());
                checkDetailVO.setRentTypeId(deliveryDetailEntity.getRentType());
                checkDetailVO.setRentTypeName(deliveryDetailEntity.getRentTypeName());
                checkDetailVO.setNum(1);
                checkDetailVO.setRowState("add");

                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setRentAcceptanceSubList(checkDetailVOS);
        }
        return checkVO;
    }

    /**
     * type 0-关闭,1-新增和修改
     * @param id
     * @return
     */
    @Override
    @Transactional
    public RentDeliveryVO closeDelivery(Long id) {
        RentDeliveryEntity deliveryEntity = super.selectById(id);
        deliveryEntity.setCloseFlag(1);
        super.updateById(deliveryEntity);

        //推送供方数据
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败！");
        }
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",deliveryEntity.getSourceId());
        map.put("closeFlag",1);
        map.put("systemId",ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = updateSupplierStatus(deliveryEntity.getId(), dataInfo,PUSH_BILL_SERVER_URL,RequestMethod.POST,
                deliveryEntity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
        if (!updateSupplierStatus){
            throw new BusinessException("单据推送失败！");
        }

        return BeanMapper.map(deliveryEntity, RentDeliveryVO.class);
    }
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method,String supplierId,String operate,String billTypeCode) {
        //推送供方
        //对单据进行加锁
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = jedisPool.getResource();
        try {
            locked = RedisTool.tryLock(jedis, key, operate, 600);
            if(!locked) {
                releaseLock(jedis, false, key, operate);
                logger.error("单据{}推送失败，单据锁获取失败-{}！", billId, locked);
                return false;
            }
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,method,dataInfo,supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, billPushResp.getMsg());
                }
            } else {
                logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, syncReqResp.getMsg());

            }
        } catch (Exception e) {
            logger.error("推送发货单单据id-{}给供方id-{} 异常，", billId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public RentDeliveryVO saveOrUpdates(RentDeliveryVO saveOrUpdateVO) {
        RentDeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, RentDeliveryEntity.class);
        List<RentDeliveryDetailVO> materialDeliveryDetailList = saveOrUpdateVO.getEquipmentDeliveryDetailList();
        List<RentDeliveryDetailEntity> deliveryDetailEntityList = BeanMapper.mapList(materialDeliveryDetailList, RentDeliveryDetailEntity.class);
        entity.setDeliveryDetailList(deliveryDetailEntityList);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        super.saveOrUpdate(entity, false);
        RentDeliveryVO vo = BeanMapper.map(entity, RentDeliveryVO.class);
        return vo;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }


}
