package com.ejianc.business.proequipmentcorprent.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleDetailEntity;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleEntity;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleOtherEntity;
import com.ejianc.business.proequipmentcorprent.settle.enums.SettleTypeEnum;
import com.ejianc.business.proequipmentcorprent.settle.mapper.SettleMapper;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleDetailService;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleOtherService;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleService;
import com.ejianc.business.proequipmentcorprent.settle.vo.SettleRecordVO;
import com.ejianc.business.proequipmentcorprent.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import java.math.BigDecimal;
import java.util.*;

/**
 * 结算实体
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    @Autowired
    private IChangeService changeService;

    @Autowired
    private SettleMapper settleMapper;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;


    private static final String CHECK_PARAM_CODE_GC = "P-lE5KWw55";//结算金额控制-过程
    private static final String CHECK_PARAM_CODE_ZZ = "P-9sGUw20157";//结算金额控制-最终

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前合同已进行完工结算，请选择其他合同。");
        }
        QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("contract_id", contractId);
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
            changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
            changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            int changeResultCount = changeService.count(changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error("当前合同正在进行变更，不可以进行完工结算！");
            }
        }

        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，请选择其他合同。");
        }

//        //设置最小可用结算日期
//        Date resultDate = settleMapper.selectMaxSettleDate(contractId);
//        if (null == resultDate) {
//            resultDate = null != settleDate ? settleDate : new Date();
//            settleVO.setMinSettleDate(null);
//        } else {
//            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
//            resultDate = DateUtils.addDays(resultDate, 1);
//            settleVO.setMinSettleDate(resultDate);
//            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
//                resultDate = settleDate;
//            }
//        }
//        settleVO.setSettleDate(resultDate);
        //查询当前合同结算金额 已提交的
        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        //设置 已结算数据
        if (list.size() > 0) {
            settleVO.setSettleScale(list.get(0).getTotalSettleScale()==null?BigDecimal.ZERO : list.get(0).getTotalSettleScale());
            settleVO.setLastTaxMny(list.get(0).getTotalTaxMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
            settleVO.setLastMny(list.get(0).getTotalMny() == null ? BigDecimal.ZERO : list.get(0).getTotalMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        return CommonResponse.success("当前合同可用！", settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
//        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType()==1){
                vo.setSettleTypeStr("完工结算");
            }else if (vo.getSettleType()==0){
                vo.setSettleTypeStr("过程结算");
            }
            if (vo.getTotalSettleScale()!=null){
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring+'%');

            }
        });
        settleRecordVO.setSettleList(settleVOS);
        //取第一条数据计算累计结算金额 与比例
        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (lastSettleRecord!=null){
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
            //检测是否可以创建新的结算单
        }else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }


    /**
     * 校验逻辑
     * <p>
     * 节点结算：
     * 2）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的节点结算单据）
     * 3）判断是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行节点结算
     * <p>
     * 过程结算：
     * 1）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的过程结算单据）
     * 2）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行过程结算
     * <p>
     * 完工结算：
     * 1）是否有出库单没有进行领料结算，如果有，不可以进行完工结算
     * 2）是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
     * 3）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行完工结算（一个合同只可以有一个未生效的过程结算单据）
     * 4）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行完工结算
     *
     * @param contractId
     * @param settleType
     * @return
     */
    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.and(q -> q.in("settle_type", SettleTypeEnum.节点.getCode(), SettleTypeEnum.过程.getCode())
                .in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
        ).or().and(q -> q.eq("settle_type", SettleTypeEnum.完工));

        List<SettleEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList)) {
            if (SettleTypeEnum.完工.getCode().equals(settleType)) {
                return "合同已经生成了完工结算，不可以进行 " + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            } else {
                return "有未生效的过" + SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.节点.getCode()) + "算单据，不可以进行" + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            }
        }

        if (SettleTypeEnum.完工.getCode().equals(settleType)) {
            //TODO 1、是否有出库单没有进行领料结算，如果有，不可以进行完工结算
            //2、是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return "当前合同正在进行变更，不可以进行完工结算！";
                }
            }
        }

        return null;
    }

 // 从结算池中删除数据
 @Override
 public boolean delSettleFromPool(Long id) {
     SettlePoolVO spv = new SettlePoolVO();
     spv.setSourceId(id);

     CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
     if (res.isSuccess()) {
         logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
         return true;
     }
     logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
     throw new BusinessException("将结算单从结算池中删除失败:"+res.getMsg());
//     return false;
 }

 @Override
 public boolean pushSettleToPool(SettleVO settleVO) {
     SettlePoolVO poolVO = new SettlePoolVO();
     try {
         logger.info("结算单对象 -> 结算池对象自动转换开始");
         BeanConvertorUtil.convert(settleVO, poolVO);
         logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
         // 个别字段需要手动封装
         convertSettleVOToSettlePoolVO(settleVO, poolVO);

         poolVO.setBillCodeUrl("/ejc-proequipment-frontend/#/settleList/card?id=" + settleVO.getId());
         CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
         if (res.isSuccess()) {
             logger.info("结算单推送至结算池成功！结算单id-{}", settleVO.getId());
             return true;
         } else {
             logger.error("结算单推送结算池失败！结算单id-{}，{}", settleVO.getId(), res.getMsg());
             throw new BusinessException("结算单推送结算池失败:"+res.getMsg());
         }
     } catch (Exception e) {
         logger.error("结算-{}推送结算池失败，", settleVO.getId(), e);
         throw new BusinessException("结算单推送结算池失败!");
     }
//     return false;
 }

    private void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.安拆合同过程结算.getCode() : SettleSourceTypeEnum.安拆合同最终结算.getCode());
        poolVO.setSettleProperty(0);// 属性类型：支出
        poolVO.setHandleType(0);
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());// 累计结算金额（含税）
        poolVO.setLastMny(settleVO.getLastMny());// 累计结算金额（无税）
        poolVO.setLastTax(getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));// 累计结算税额
        poolVO.setContractType(ContractTypeEnum.安拆合同.getTypeCode());
        poolVO.setBillStateName(BillStateEnum.getEnumByStateCode(poolVO.getBillState()).getDescription());
        ContractEntity ce = contractService.selectById(settleVO.getContractId());
        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", settleVO.getContractId());
        if (ce == null) {
            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", settleVO.getContractId());
            return;
        }
        // 主合同
        poolVO.setContractFlag(1);// 是否有合同：1-是，0-否
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setContractTypeName(ContractTypeEnum.安拆合同.getTypeName());
        poolVO.setSupplementFlag(ce.getSupplementFlag());//合同类别
        poolVO.setMemo(ce.getMemo());//合同类别
        // 甲方
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        // 签订日期
        poolVO.setSignDate(ce.getSignDate());
        // 创建时间和人员 使用 结算单的创建时间和人员
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType("EJCBT202204000007");
//        if (settleVO.getSettleType() == 0) {
//            totalVO.setBussinessType(BussinessTypeEnum.安拆合同过程结算.getCode());//应该是安拆结算
//        }
//        if (settleVO.getSettleType() == 1) {
//            // 完工（最终）
//            totalVO.setBussinessType(SettleSourceTypeEnum.安拆合同最终结算.getCode());//应该是安拆结算
//        }
        totalVO.setBussinessType(BussinessTypeEnum.大型设备安拆合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());//结算
        if (settleVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(settleVO.getProjectId());
        }
        if (settleVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(settleVO.getOrgId());
        }
        LambdaQueryWrapper<SettleEntity> query = new LambdaQueryWrapper<>();
        query.eq(SettleEntity::getContractId, settleVO.getContractId());
        query.in(SettleEntity::getBillState, 1,3);
        query.eq(SettleEntity::getDr,0);
        List<SettleEntity> entity = settleService.list(query); // 过程结算
        BigDecimal sumMny = BigDecimal.ZERO;//本期结算金额(无税)
        BigDecimal sumTaxMny = BigDecimal.ZERO;//本期结算金额
        ContractEntity contractEntity = contractService.selectById(settleVO.getContractId());
        for (SettleEntity settleEntity : entity){
            sumMny = ComputeUtil.safeAdd(sumMny, settleEntity.getMny());
            sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, settleEntity.getTaxMny());
        }
        totalVO.setMoney(ComputeUtil.safeSub(sumMny,contractEntity.getContractMny())); //总计划金额无税
        totalVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny,contractEntity.getContractTaxMny())); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    //关联保存
    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity entity = baseMapper.selectById(settleVO.getId());
        if (CollectionUtils.isNotEmpty(settleVO.getDetailList())) {
            List<SettleDetailEntity> detailEntityList = BeanMapper.mapList(settleVO.getDetailList(), SettleDetailEntity.class);
            entity.setDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getOtherList())) {
            List<SettleOtherEntity> otherEntityList = BeanMapper.mapList(settleVO.getOtherList(), SettleOtherEntity.class);
            entity.setOtherList(otherEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, SettleVO.class));
    }
    @Override
    public void costPush(SettleEntity settleEntity) {
        logger.info("开始costPush");
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null == otherEntity.getSubjectId() || null == otherEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(detailList) && ListUtil.isEmpty(otherList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = settleEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(settleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-安拆结算Id---{}",settleEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(settleEntity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(settleEntity);
            }
        }
        //更新是否关联
        settleEntity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }


    private void saveCost(SettleEntity settleEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<SettleOtherEntity> otherlList = settleEntity.getOtherList();
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                costDetailVO.setHappenMny(detailEntity.getSettleMny());
                costDetailVO.setSourceTabType("SETTLE_EQ_JS_DETAIL");
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherlList)) {
            for (SettleOtherEntity settleOtherEntity : otherlList) {
                CostDetailVO costDetailVO = BeanMapper.map(settleOtherEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(settleOtherEntity.getId());
                costDetailVO.setHappenTaxMny(settleOtherEntity.getTaxMny());
                costDetailVO.setHappenMny(settleOtherEntity.getMny());
                costDetailVO.setSourceTabType("SETTLE_EQ_JS_OTHER");
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.设备安拆结算单.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipment-frontend/#/settleList/card?id=" + settleEntity.getId());
                costDetailVO.setSourceId(settleEntity.getId());
                costDetailVO.setHappenDate(settleEntity.getSettleDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("SETTLE_EQ_JS");
                costDetailVO.setProjectId(settleEntity.getProjectId());
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }


    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }
    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(SettleVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        //----start有合同预警域
        if(vo.getContractId()!=null) {
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsMny(contractEntity,vo));//金额
        }
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public  List<ParamsCheckVO> checkParamsMny(ContractEntity contractEntity, SettleVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettleType()){//结算类型：0-过程，1-完工
            case 0:CHECK_PARAM_CODE= CHECK_PARAM_CODE_GC;break;
            case 1:CHECK_PARAM_CODE= CHECK_PARAM_CODE_ZZ;break;
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal totalSettleTaxMny = null==vo.getTotalTaxMny()?BigDecimal.ZERO:vo.getTotalTaxMny();
                    BigDecimal settleTaxMny = null==vo.getTaxMny()?BigDecimal.ZERO:vo.getTaxMny();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        SettleEntity settleEntity = settleService.selectById(id);
        //最终结算单生效推送目标成本
        if(1==settleEntity.getSettleType()){// 结算类型：0-过程，1-完工
            String linkUrl;
            linkUrl = BaseHost + "ejc-proequipment-frontend/#/settleList/card?id=" + id;
            ExecutionVO executionVO = settleService.targetCost(BeanMapper.map(settleEntity, SettleVO.class), linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        return CommonResponse.success("目标成本推送成功");
    }
    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
    @Override
    public void updateContractPoolSettle(SettleVO vo, Boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSettleType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
            if (type) {
                totalSettleTaxMny = vo.getTotalTaxMny() == null ? BigDecimal.ZERO : vo.getTotalTaxMny();
                totalSettleMny = vo.getTotalMny() == null ? BigDecimal.ZERO : vo.getTotalMny();
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            } else {//撤回删除本次结算金额
                totalSettleTaxMny = ComputeUtil.safeSub(vo.getTotalTaxMny(), vo.getTaxMny());
                totalSettleMny = ComputeUtil.safeSub(vo.getTotalMny(), vo.getMny());
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSettleType()) { // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }

}
