package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractDetailedService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("purchaseAcceptance") 
public class PurchaseAcceptanceBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IPurchaseAcceptanceService service;
	@Autowired
	private IPurchaseContractService contractService;
	@Autowired
	private IPurchaseContractDetailedService equipmentDetailedService;
	@Autowired
	private IPurchaseAcceptanceSubService subService;
	@Autowired
	private IAssetService assetService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//这个地方写推送 固定资产 和其他的业务区分开
		QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("purchase_acceptance_id",billId);
		List<AssetEntity> list = assetService.list(queryWrapper);
		if (CollectionUtils.isEmpty(list)){
			assetService.pushAsset(billId);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		logger.info("333333333333333---------->: {}", JSONObject.toJSONString(contractEntity));
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<PurchaseContractDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		logger.info("4444444444444444---------->: {}", JSONObject.toJSONString(equipmentList));
		PurchaseContractDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		logger.info("555555555555555555---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(1);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()+1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//		 参数是单据类型编码字符串 根据需求是否打开下面代码
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		logger.info("333333333333333---------->: {}", JSONObject.toJSONString(contractEntity));
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<PurchaseContractDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		logger.info("4444444444444444---------->: {}", JSONObject.toJSONString(equipmentList));
		PurchaseContractDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		logger.info("555555555555555555---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(0);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()-1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);
        //弃审删除固定资产卡片
		QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("purchase_acceptance_id",billId);
		List<AssetEntity> list = assetService.list(queryWrapper);
		AssetEntity assetEntity = list.get(0);
	    if (CollectionUtils.isNotEmpty(list)){
			CommonResponse<String> response = billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
			if(!response.isSuccess()){
				return CommonResponse.error("验收生成的固定资产卡片被下游引用无法撤回！"+resp.getMsg());
			}else {
				assetService.removeById(assetEntity.getId());
			}
		}
		return CommonResponse.success("采购验收处理成功！");
	}

}
