package com.ejianc.business.proequipmentcorppur.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AmortizeSetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetRecordEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAmortizeSetService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetRecordVO;
import com.ejianc.business.proequipmentcorppur.consts.SourceQueryTypeUrlEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 固定资产
 *
 * @author generator
 */
@Controller
@RequestMapping("asset")
@Api(value = " 固定资产", tags = {" 固定资产"})
public class AssetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改

    @Autowired
    private IAssetService service;

    @Autowired
    private IAssetRecordService assetRecordService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAmortizeSetService amortizeSetService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody AssetVO saveOrUpdateVO) {
        AssetEntity entity = BeanMapper.map(saveOrUpdateVO, AssetEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            QueryWrapper<AssetEntity> queryRepeatCodeWrapper = new QueryWrapper<>();
            queryRepeatCodeWrapper.eq("bill_code", saveOrUpdateVO.getBillCode());
            queryRepeatCodeWrapper.select("COUNT(*) as billCode");
            AssetEntity one = service.getOne(queryRepeatCodeWrapper);
            if (!one.getBillCode().equals("0")) {
                throw new BusinessException("资产编码重复!");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setAssetStatus(0);
                entity.setEquipmentStatus(1);
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            AssetEntity assetEntity = service.selectById(entity.getId());
            if (!assetEntity.getBillCode().equals(saveOrUpdateVO.getBillCode())) {
                QueryWrapper<AssetEntity> queryRepeatCodeWrapper = new QueryWrapper<>();
                queryRepeatCodeWrapper.eq("bill_code", saveOrUpdateVO.getBillCode());
                queryRepeatCodeWrapper.select("COUNT(*) as billCode");
                AssetEntity one = service.getOne(queryRepeatCodeWrapper);
                if (!one.getBillCode().equals("0")) {
                    throw new BusinessException("资产编码重复!");
                }
            }
        }
        service.saveOrUpdate(entity, false);
        AssetVO vo = BeanMapper.map(entity, AssetVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetVO> queryDetail(@RequestParam Long id) {
        AssetEntity entity = service.selectById(id);
        AssetVO vo = BeanMapper.map(entity, AssetVO.class);
        if (entity.getBillState().equals(1) || entity.getBillState().equals(3)) {
            QueryWrapper<AssetRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("asset_id", id);
            List<AssetRecordEntity> assetRecordList = assetRecordService.list(queryWrapper);
            List<AssetRecordVO> assetRecordVOS = BeanMapper.mapList(assetRecordList, AssetRecordVO.class);
            if (CollectionUtils.isNotEmpty(assetRecordList)) {
                for (AssetRecordVO assetRecordVO : assetRecordVOS) {
                    String sourceUrl = SourceQueryTypeUrlEnum.getUrl(assetRecordVO.getSourceType().toString());
                    assetRecordVO.setSourceUrl(sourceUrl);
                    String name = SourceQueryTypeUrlEnum.getName(assetRecordVO.getSourceType().toString());
                    assetRecordVO.setSourceBliName(name);
                }
            }
            vo.setAssetRecordList(assetRecordVOS);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AssetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        //搜索：设备出厂编码、设备分类、设备名称、使用项目
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("equipmentTypeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long parentOrgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("parentOrgId")) {
            Object obj = param.getParams().get("parentOrgId").getValue();
            String parentOrgIdStr = String.valueOf(obj);
            parentOrgId = Long.parseLong(parentOrgIdStr);
            param.getParams().remove("parentOrgId");
        }
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(parentOrgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<AssetVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<AssetVO> assetVOS = service.queryAssetPage(page, wrapper,orgIds);
        page.setTotal(page.getTotal());
        page.setRecords(assetVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Long parentOrgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("parentOrgId")) {
            Object obj = param.getParams().get("parentOrgId").getValue();
            String parentOrgIdStr = String.valueOf(obj);
            parentOrgId = Long.parseLong(parentOrgIdStr);
        }
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(parentOrgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<AssetVO> assetVOS = service.queryAssetPage(null, wrapper,orgIds);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        for (AssetVO assetVO : assetVOS) {
            if (assetVO.getEquipmentStatus() != null){
                switch (assetVO.getEquipmentStatus()) {
                    case 1:
                        assetVO.setEquipmentStatusName("在用");
                        break;
                    case 2:
                        assetVO.setEquipmentStatusName("处置");
                        break;
                    case 3:
                        assetVO.setEquipmentStatusName("闲置");
                        break;
                    case 4:
                        assetVO.setEquipmentStatusName("调拨");
                        break;
                    case 5:
                        assetVO.setEquipmentStatusName("报废");
                        break;
                }
            }
            if (assetVO.getRentState() != null) {
                if (assetVO.getRentState().equals(1)) {
                    assetVO.setRentStateName("启用");
                } else if (assetVO.getSourceType().equals(2)) {
                    assetVO.setSourceTypeName("停用");
                }
            }
        }
        beans.put("records", assetVOS);
        ExcelExport.getInstance().export("Asset-export.xlsx", beans, response);
    }


    /**
     * 设备调出选择设备使用参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @ApiOperation("参照")
    @RequestMapping(value = "/refAssetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> refAssetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        //搜索：设备出厂编码、设备名称、产权单位、生产厂家。
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("propertyRightCompany");
        fuzzyFields.add("manufacturer");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 只查闲置的设备
        // 设备状态 1:再用 2:处置 3：闲置 4：调拨 5：报废
        param.getParams().put("equipmentStatus", new Parameter(QueryParam.EQ, 3));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            //变更单位 changeCompany 1：产权 2：管理
            if (_con.containsKey("changeCompany") && _con.containsKey("orgId")) {
                if ("1".equals(_con.get("changeCompany"))){//产权单位
                    param.getParams().put("propertyRightCompanyId", new Parameter(QueryParam.EQ, _con.get("orgId")));
                }else if ("2".equals(_con.get("changeCompany"))){//管理单位
                    param.getParams().put("manageCompanyId", new Parameter(QueryParam.EQ, _con.get("orgId")));
                }
            }

        }

        IPage<AssetEntity> page = service.queryPage(param, false);
        IPage<AssetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AssetVO> assetVOS = BeanMapper.mapList(page.getRecords(), AssetVO.class);

        if (CollectionUtils.isNotEmpty(assetVOS)) {
            for (AssetVO assetVO : assetVOS) {
                if (assetVO.getEquipmentStatus() == 3){
                    assetVO.setEquipmentStatusName("闲置");
                }
            }
        }
        pageData.setRecords(assetVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 设备报废、摊销设置 选择设备使用参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @ApiOperation("摊销设置 选择设备使用参照")
    @RequestMapping(value = "/refAssetScrapData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetVO>> refAssetScrapData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /*
         * 设备报废参照查询逻辑
         * 根据当前组织权限加载本下在场设备（在用、闲置）信息。
         */

        //搜索：设备出厂编码、设备名称、产权单位、生产厂家。
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentTypeName");
        fuzzyFields.add("manageCompany");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 只查在用、闲置的设备
        // 设备状态 1:再用 2:处置 3：闲置
        param.getParams().put("equipmentStatus", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("参照传入参数：{}", JSONObject.toJSONString(_con));
            //变更单位 changeCompany 1：产权 2：管理
            if (_con.containsKey("orgId")) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, _con.get("orgId")));
            }
        }

        IPage<AssetEntity> page = service.queryPage(param, false);
        IPage<AssetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AssetVO> assetVOS = BeanMapper.mapList(page.getRecords(), AssetVO.class);

        if (CollectionUtils.isNotEmpty(assetVOS)) {
            for (AssetVO assetVO : assetVOS) {
                if (assetVO.getEquipmentStatus() == 1){
                    assetVO.setEquipmentStatusName("在用");
                }else if (assetVO.getEquipmentStatus() == 3){
                    assetVO.setEquipmentStatusName("闲置");
                }
            }
        }
        pageData.setRecords(assetVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    public ComplexParam getAmortizeQueryParam(String amortizeDate) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("last_amortize_date", new Parameter(QueryParam.EQ, null));
        //验收日期当月也可摊销
        c2.getParams().put("check_date", new Parameter(QueryParam.LT, amortizeDate + "-31"));
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("last_amortize_date", new Parameter(QueryParam.LT, amortizeDate));

        c1.getComplexParams().add(c3);

        return c1;
    }


    @ApiOperation("查询残值信息")
    @RequestMapping(value = "/queryResidualValueInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetVO> queryResidualValueInfo(@ApiParam(name = "vo", required = true) @RequestBody AssetVO vo) {
        Map<Long, Long> amortizeSetmap = new HashMap<>();
        amortizeSetmap.put(vo.getEquipmentId(), vo.getEquipmentTypeId());
        Map<Long, AmortizeSetEntity> amortizeMap = amortizeSetService.getSet(amortizeSetmap, vo.getOrgId());
        AmortizeSetEntity amortizeSetEntity = amortizeMap.get(vo.getEquipmentId());
        if (amortizeSetEntity != null) {
            BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
            logger.info("调用固定资产摊销设置残值率残值率:" + residualValueRate);
            BigDecimal rate = ComputeUtil.safeDiv(residualValueRate, new BigDecimal(100));
            BigDecimal residualValueTax = ComputeUtil.safeMultiply(rate,
                    vo.getOriginalValueTax());
            BigDecimal residualValue = ComputeUtil.safeMultiply(rate,
                    vo.getOriginalValue());
            vo.setResidualValueRate(residualValueRate);
            vo.setResidualValueTax(residualValueTax);
            vo.setResidualValue(residualValue);
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
